/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.ArrayTimeSeq;
import com.netflix.atlas.core.model.BasicTimeSeries;
import com.netflix.atlas.core.model.DsType$Gauge$;
import com.netflix.atlas.core.model.FunctionTimeSeq;
import com.netflix.atlas.core.model.ItemId;
import com.netflix.atlas.core.model.LazyTimeSeries;
import com.netflix.atlas.core.model.Query;
import com.netflix.atlas.core.model.Query$;
import com.netflix.atlas.core.model.TaggedItem$;
import com.netflix.atlas.core.model.TimeSeq;
import com.netflix.atlas.core.model.TimeSeries;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class TimeSeries$ {
    public static final TimeSeries$ MODULE$ = new TimeSeries$();
    private static final Map<String, String> noDataTags = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"NO_DATA")}));
    private static final ItemId noDataId = TaggedItem$.MODULE$.computeId(MODULE$.noDataTags());

    private Map<String, String> noDataTags() {
        return noDataTags;
    }

    private ItemId noDataId() {
        return noDataId;
    }

    public TimeSeries noData(long step) {
        FunctionTimeSeq data = new FunctionTimeSeq(DsType$Gauge$.MODULE$, step, (Function1<Object, Object>)(JFunction1.mcDJ.sp & Serializable)x$1 -> Double.NaN);
        return new BasicTimeSeries(this.noDataId(), this.noDataTags(), "NO DATA", data);
    }

    public TimeSeries noData(Query query, long step) {
        Map<String, String> tags = Query$.MODULE$.tags(query);
        FunctionTimeSeq data = new FunctionTimeSeq(DsType$Gauge$.MODULE$, step, (Function1<Object, Object>)(JFunction1.mcDJ.sp & Serializable)x$2 -> Double.NaN);
        return new LazyTimeSeries(tags.isEmpty() ? this.noDataTags() : tags, "NO DATA", data);
    }

    public TimeSeries apply(Map<String, String> tags, String label, TimeSeq data) {
        return new LazyTimeSeries(tags, label, data);
    }

    public TimeSeries apply(Map<String, String> tags, TimeSeq data) {
        return this.apply(tags, this.toLabel(tags), data);
    }

    public String toLabel(Map<String, String> tags) {
        return tags.isEmpty() ? "NO TAGS" : this.toLabel((List<String>)((List)tags.keys().toList().sortWith((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(x$3), x$4)))), tags);
    }

    public String toLabel(List<String> keys, Map<String, String> tags) {
        String str = keys.map((Function1 & Serializable)k -> new StringBuilder(1).append((String)k).append("=").append(tags.getOrElse(k, (Function0 & Serializable)() -> "NULL")).toString()).mkString(", ");
        return keys.size() == 1 ? str : String.valueOf(str);
    }

    public TimeSeries aggregate(Iterator<TimeSeries> ds, long start, long end, Function2<Object, Object, Object> f) {
        Predef$.MODULE$.require(ds.nonEmpty(), (Function0 & Serializable)() -> "must have 1 or more time series to perform aggregation");
        TimeSeries init = (TimeSeries)ds.next();
        ArrayTimeSeq buf = init.data().bounded(start, end);
        Map<String, String> tags = init.tags();
        while (ds.hasNext()) {
            TimeSeries t = (TimeSeries)ds.next();
            tags = TaggedItem$.MODULE$.aggrTags(tags, t.tags());
            buf.update(t.data(), f);
        }
        return this.apply(tags, buf);
    }

    private TimeSeries$() {
    }
}

