/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.index;

import com.netflix.atlas.core.index.IndexStats$;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5f\u0001\u0002$H\u0001IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u001d\u0011)\b\u0001Q\u0001\n%D\u0011Ba\u001e\u0001\u0005\u0004%IA!\u0007\t\u0011\te\u0004\u0001)A\u0005\u00057A\u0011Ba\u001f\u0001\u0005\u0004%IA!\u0007\t\u0011\tu\u0004\u0001)A\u0005\u00057AqAa \u0001\t\u0013\u0011\t\tC\u0004\u0003\b\u0002!\tA!#\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\"9!1\u0015\u0001\u0005\n\t\u0015v!\u0002=H\u0011\u0003Ih!\u0002$H\u0011\u0003Q\b\"\u00022\u000f\t\u0003Yh\u0001\u0002?\u000f\u0001vD!\"a\u0007\u0011\u0005+\u0007I\u0011AA\u000f\u0011)\ty\u0003\u0005B\tB\u0003%\u0011q\u0004\u0005\u000b\u0003c\u0001\"Q3A\u0005\u0002\u0005M\u0002BCA\u001e!\tE\t\u0015!\u0003\u00026!Q\u0011Q\b\t\u0003\u0016\u0004%\t!a\r\t\u0015\u0005}\u0002C!E!\u0002\u0013\t)\u0004\u0003\u0004c!\u0011\u0005\u0011\u0011\t\u0005\n\u0003\u001b\u0002\u0012\u0011!C\u0001\u0003\u001fB\u0011\"a\u0016\u0011#\u0003%\t!!\u0017\t\u0013\u0005=\u0004#%A\u0005\u0002\u0005E\u0004\"CA;!E\u0005I\u0011AA9\u0011%\t9\bEA\u0001\n\u0003\nI\bC\u0005\u0002\u0006B\t\t\u0011\"\u0001\u0002\b\"I\u0011q\u0012\t\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003;\u0003\u0012\u0011!C!\u0003?C\u0011\"!,\u0011\u0003\u0003%\t!a,\t\u0013\u0005e\u0006#!A\u0005B\u0005m\u0006\"CA`!\u0005\u0005I\u0011IAa\u0011%\t\u0019\rEA\u0001\n\u0003\n)\rC\u0005\u0002HB\t\t\u0011\"\u0011\u0002J\u001eI\u0011Q\u001a\b\u0002\u0002#\u0005\u0011q\u001a\u0004\ty:\t\t\u0011#\u0001\u0002R\"1!M\nC\u0001\u0003SD\u0011\"a1'\u0003\u0003%)%!2\t\u0013\u0005-h%!A\u0005\u0002\u00065\b\"CA{M\u0005\u0005I\u0011QA|\u0011%\u0011IAJA\u0001\n\u0013\u0011YA\u0002\u0004\u0003\u00149!%Q\u0003\u0005\u000b\u0005/a#Q3A\u0005\u0002\te\u0001B\u0003B\u0014Y\tE\t\u0015!\u0003\u0003\u001c!Q!\u0011\u0006\u0017\u0003\u0016\u0004%\tA!\u0007\t\u0015\t-BF!E!\u0002\u0013\u0011Y\u0002\u0003\u0004cY\u0011\u0005!Q\u0006\u0005\n\u0003\u001bb\u0013\u0011!C\u0001\u0005kA\u0011\"a\u0016-#\u0003%\tAa\u000f\t\u0013\u0005=D&%A\u0005\u0002\tm\u0002\"CA<Y\u0005\u0005I\u0011IA=\u0011%\t)\tLA\u0001\n\u0003\t9\tC\u0005\u0002\u00102\n\t\u0011\"\u0001\u0003@!I\u0011Q\u0014\u0017\u0002\u0002\u0013\u0005\u0013q\u0014\u0005\n\u0003[c\u0013\u0011!C\u0001\u0005\u0007B\u0011\"!/-\u0003\u0003%\tEa\u0012\t\u0013\u0005}F&!A\u0005B\u0005\u0005\u0007\"CAbY\u0005\u0005I\u0011IAc\u0011%\t9\rLA\u0001\n\u0003\u0012YeB\u0005\u0003P9\t\t\u0011#\u0003\u0003R\u0019I!1\u0003\b\u0002\u0002#%!1\u000b\u0005\u0007E~\"\tAa\u0017\t\u0013\u0005\rw(!A\u0005F\u0005\u0015\u0007\"CAv\u007f\u0005\u0005I\u0011\u0011B/\u0011%\t)pPA\u0001\n\u0003\u0013\u0019\u0007C\u0005\u0003\n}\n\t\u0011\"\u0003\u0003\f!I!q\u000e\b\u0012\u0002\u0013\u0005!\u0011\u000f\u0002\u000b\u0013:$W\r_*uCR\u001c(B\u0001%J\u0003\u0015Ig\u000eZ3y\u0015\tQ5*\u0001\u0003d_J,'B\u0001'N\u0003\u0015\tG\u000f\\1t\u0015\tqu*A\u0004oKR4G.\u001b=\u000b\u0003A\u000b1aY8n\u0007\u0001\u0019\"\u0001A*\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g\u0003!\u0011XmZ5tiJL\bCA.a\u001b\u0005a&BA/_\u0003\r\t\u0007/\u001b\u0006\u0003?6\u000b\u0011b\u001d9fGR\fGo\u001c:\n\u0005\u0005d&\u0001\u0003*fO&\u001cHO]=\u0002\rqJg.\u001b;?)\t!g\r\u0005\u0002f\u00015\tq\tC\u0004Z\u0005A\u0005\t\u0019\u0001.\u0002\u001d9,XNY3s\u001f\u001a4\u0016\r\\;fgV\t\u0011\u000e\u0005\u0003kcN4X\"A6\u000b\u00051l\u0017AC2p]\u000e,(O]3oi*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005I\\'!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u00111\f^\u0005\u0003kr\u0013!!\u00133\u0011\u0005]dcBA3\u000e\u0003)Ie\u000eZ3y'R\fGo\u001d\t\u0003K:\u0019\"AD*\u0015\u0003e\u0014qaS3z'R\fGoE\u0003\u0011'z\f\u0019\u0001\u0005\u0002U\u007f&\u0019\u0011\u0011A+\u0003\u000fA\u0013x\u000eZ;diB!\u0011QAA\u000b\u001d\u0011\t9!!\u0005\u000f\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004R\u0003\u0019a$o\\8u}%\ta+C\u0002\u0002\u0014U\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0005e!\u0001D*fe&\fG.\u001b>bE2,'bAA\n+\u0006\u00191.Z=\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003SqA!a\t\u0002&A\u0019\u0011\u0011B+\n\u0007\u0005\u001dR+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O)\u0016\u0001B6fs\u0002\n\u0001B\\;n\u0013R,Wn]\u000b\u0003\u0003k\u00012\u0001VA\u001c\u0013\r\tI$\u0016\u0002\u0005\u0019>tw-A\u0005ok6LE/Z7tA\u0005Ia.^7WC2,Xm]\u0001\u000b]Vlg+\u00197vKN\u0004C\u0003CA\"\u0003\u000f\nI%a\u0013\u0011\u0007\u0005\u0015\u0003#D\u0001\u000f\u0011\u001d\tYb\u0006a\u0001\u0003?Aq!!\r\u0018\u0001\u0004\t)\u0004C\u0004\u0002>]\u0001\r!!\u000e\u0002\t\r|\u0007/\u001f\u000b\t\u0003\u0007\n\t&a\u0015\u0002V!I\u00111\u0004\r\u0011\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0003cA\u0002\u0013!a\u0001\u0003kA\u0011\"!\u0010\u0019!\u0003\u0005\r!!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\f\u0016\u0005\u0003?\tif\u000b\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!C;oG\",7m[3e\u0015\r\tI'V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u001d+\t\u0005U\u0012QL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0010\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q8\u0002\t1\fgnZ\u0005\u0005\u0003W\ty(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\nB\u0019A+a#\n\u0007\u00055UKA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0006e\u0005c\u0001+\u0002\u0016&\u0019\u0011qS+\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001cz\t\t\u00111\u0001\u0002\n\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!)\u0011\r\u0005\r\u0016\u0011VAJ\u001b\t\t)KC\u0002\u0002(V\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY+!*\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003c\u000b9\fE\u0002U\u0003gK1!!.V\u0005\u001d\u0011un\u001c7fC:D\u0011\"a'!\u0003\u0003\u0005\r!a%\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003w\ni\fC\u0005\u0002\u001c\u0006\n\t\u00111\u0001\u0002\n\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\n\u0006AAo\\*ue&tw\r\u0006\u0002\u0002|\u00051Q-];bYN$B!!-\u0002L\"I\u00111\u0014\u0013\u0002\u0002\u0003\u0007\u00111S\u0001\b\u0017\u0016L8\u000b^1u!\r\t)EJ\n\u0006M\u0005M\u0017q\u001c\t\r\u0003+\fY.a\b\u00026\u0005U\u00121I\u0007\u0003\u0003/T1!!7V\u0003\u001d\u0011XO\u001c;j[\u0016LA!!8\u0002X\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:p\u0003\tIw.\u0003\u0003\u0002\u0018\u0005\rHCAAh\u0003\u0015\t\u0007\u000f\u001d7z)!\t\u0019%a<\u0002r\u0006M\bbBA\u000eS\u0001\u0007\u0011q\u0004\u0005\b\u0003cI\u0003\u0019AA\u001b\u0011\u001d\ti$\u000ba\u0001\u0003k\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002z\n\u0015\u0001#\u0002+\u0002|\u0006}\u0018bAA\u007f+\n1q\n\u001d;j_:\u0004\u0012\u0002\u0016B\u0001\u0003?\t)$!\u000e\n\u0007\t\rQK\u0001\u0004UkBdWm\r\u0005\n\u0005\u000fQ\u0013\u0011!a\u0001\u0003\u0007\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011i\u0001\u0005\u0003\u0002~\t=\u0011\u0002\u0002B\t\u0003\u007f\u0012aa\u00142kK\u000e$(A\u0003,bYV,WI\u001c;ssN)Af\u0015@\u0002\u0004\u0005IA/[7fgR\fW\u000e]\u000b\u0003\u00057\u0001BA!\b\u0003$5\u0011!q\u0004\u0006\u0004\u0005CY\u0017AB1u_6L7-\u0003\u0003\u0003&\t}!AC!u_6L7\rT8oO\u0006QA/[7fgR\fW\u000e\u001d\u0011\u0002\u000b\r|WO\u001c;\u0002\r\r|WO\u001c;!)\u0019\u0011yC!\r\u00034A\u0019\u0011Q\t\u0017\t\u000f\t]\u0011\u00071\u0001\u0003\u001c!9!\u0011F\u0019A\u0002\tmAC\u0002B\u0018\u0005o\u0011I\u0004C\u0005\u0003\u0018I\u0002\n\u00111\u0001\u0003\u001c!I!\u0011\u0006\u001a\u0011\u0002\u0003\u0007!1D\u000b\u0003\u0005{QCAa\u0007\u0002^Q!\u00111\u0013B!\u0011%\tYjNA\u0001\u0002\u0004\tI\t\u0006\u0003\u00022\n\u0015\u0003\"CANs\u0005\u0005\t\u0019AAJ)\u0011\tYH!\u0013\t\u0013\u0005m%(!AA\u0002\u0005%E\u0003BAY\u0005\u001bB\u0011\"a'>\u0003\u0003\u0005\r!a%\u0002\u0015Y\u000bG.^3F]R\u0014\u0018\u0010E\u0002\u0002F}\u001aRa\u0010B+\u0003?\u0004\"\"!6\u0003X\tm!1\u0004B\u0018\u0013\u0011\u0011I&a6\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003RQ1!q\u0006B0\u0005CBqAa\u0006C\u0001\u0004\u0011Y\u0002C\u0004\u0003*\t\u0003\rAa\u0007\u0015\t\t\u0015$Q\u000e\t\u0006)\u0006m(q\r\t\b)\n%$1\u0004B\u000e\u0013\r\u0011Y'\u0016\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\t\u001d1)!AA\u0002\t=\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003t)\u001a!,!\u0018\u0002\u001f9,XNY3s\u001f\u001a4\u0016\r\\;fg\u0002\nqB\\;nE\u0016\u0014xJZ'fiJL7m]\u0001\u0011]Vl'-\u001a:PM6+GO]5dg\u0002\nAB\\;nE\u0016\u0014xJZ&fsN\fQB\\;nE\u0016\u0014xJZ&fsN\u0004\u0013aC2sK\u0006$XmR1vO\u0016$BAa\u0007\u0003\u0004\"9!QQ\u0005A\u0002\u0005}\u0011\u0001\u00028b[\u0016\f\u0001#\u001e9eCR,\u0017J\u001c3fqN#\u0018\r^:\u0015\t\t-%\u0011\u0013\t\u0004)\n5\u0015b\u0001BH+\n!QK\\5u\u0011\u001d\t\tD\u0003a\u0001\u0003\u0013\u000ba\"\u001e9eCR,7*Z=Ti\u0006$8\u000f\u0006\u0003\u0003\f\n]\u0005b\u0002BM\u0017\u0001\u0007!1T\u0001\u0006gR\fGo\u001d\t\u0007\u0003\u000b\u0011iJ!)\n\t\t}\u0015\u0011\u0004\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002x!\u0005iQ\u000f\u001d3bi\u0016\\U-_*uCR$\u0002Ba#\u0003(\n%&1\u0016\u0005\b\u0005\u000bc\u0001\u0019AA\u0010\u0011\u001d\tY\u0002\u0004a\u0001\u0003?AqA!\u000b\r\u0001\u0004\t)\u0004")
public class IndexStats {
    private final Registry registry;
    private final ConcurrentHashMap<Id, ValueEntry> numberOfValues;
    private final AtomicLong numberOfMetrics;
    private final AtomicLong numberOfKeys;

    public static Registry $lessinit$greater$default$1() {
        return IndexStats$.MODULE$.$lessinit$greater$default$1();
    }

    private ConcurrentHashMap<Id, ValueEntry> numberOfValues() {
        return this.numberOfValues;
    }

    private AtomicLong numberOfMetrics() {
        return this.numberOfMetrics;
    }

    private AtomicLong numberOfKeys() {
        return this.numberOfKeys;
    }

    private AtomicLong createGauge(String name) {
        return (AtomicLong)((PolledMeter.Builder)PolledMeter.using((Registry)this.registry).withName(name)).monitorValue((Number)new AtomicLong(0L));
    }

    public void updateIndexStats(int numItems) {
        this.numberOfMetrics().set(numItems);
    }

    public void updateKeyStats(List<KeyStat> stats) {
        this.numberOfKeys().set(stats.length());
        long now = this.registry.clock().wallTime();
        int n = 20;
        List sorted = (List)stats.sortWith((Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)IndexStats.$anonfun$updateKeyStats$1(x$1, x$2)));
        sorted.take(n).foreach((Function1 & Serializable)stat -> {
            IndexStats.$anonfun$updateKeyStats$2(this, stat);
            return BoxedUnit.UNIT;
        });
        LongRef numValues = LongRef.create((long)0L);
        LongRef numItems = LongRef.create((long)0L);
        ((List)sorted.drop(n)).foreach((Function1 & Serializable)stat -> {
            IndexStats.$anonfun$updateKeyStats$3(numValues, numItems, stat);
            return BoxedUnit.UNIT;
        });
        this.updateKeyStat("atlas.index.numberOfValues", "-others-", numValues.elem);
        this.updateKeyStat("atlas.index.numberOfItems", "-others-", numItems.elem);
        java.util.Iterator<Map.Entry<Id, ValueEntry>> iter = this.numberOfValues().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Id, ValueEntry> entry = iter.next();
            if (entry.getValue().timestamp().get() >= now) continue;
            PolledMeter.remove((Registry)this.registry, (Id)entry.getKey());
            this.registry.gauge(entry.getKey()).set(Double.NaN);
            iter.remove();
        }
    }

    private void updateKeyStat(String name, String key, long count) {
        Id valueId = this.registry.createId(name, new String[]{"key", key});
        ValueEntry entry = this.numberOfValues().computeIfAbsent(valueId, id -> {
            AtomicLong gauge = (AtomicLong)((PolledMeter.Builder)PolledMeter.using((Registry)$this.registry).withId(id)).monitorValue((Number)new AtomicLong());
            return new ValueEntry(new AtomicLong($this.registry.clock().wallTime()), gauge);
        });
        entry.timestamp().set(this.registry.clock().wallTime());
        entry.count().set(count);
    }

    public static final /* synthetic */ boolean $anonfun$updateKeyStats$1(KeyStat x$1, KeyStat x$2) {
        return x$1.numValues() > x$2.numValues();
    }

    public static final /* synthetic */ void $anonfun$updateKeyStats$2(IndexStats $this, KeyStat stat) {
        $this.updateKeyStat("atlas.index.numberOfValues", stat.key(), stat.numValues());
        $this.updateKeyStat("atlas.index.numberOfItems", stat.key(), stat.numItems());
    }

    public static final /* synthetic */ void $anonfun$updateKeyStats$3(LongRef numValues$1, LongRef numItems$1, KeyStat stat) {
        numValues$1.elem += stat.numValues();
        numItems$1.elem += stat.numItems();
    }

    public IndexStats(Registry registry) {
        this.registry = registry;
        this.numberOfValues = new ConcurrentHashMap();
        this.numberOfMetrics = this.createGauge("atlas.db.size");
        this.numberOfKeys = this.createGauge("atlas.index.numberOfKeys");
    }

    public static class KeyStat
    implements Product,
    Serializable {
        private final String key;
        private final long numItems;
        private final long numValues;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public long numItems() {
            return this.numItems;
        }

        public long numValues() {
            return this.numValues;
        }

        public KeyStat copy(String key, long numItems, long numValues) {
            return new KeyStat(key, numItems, numValues);
        }

        public String copy$default$1() {
            return this.key();
        }

        public long copy$default$2() {
            return this.numItems();
        }

        public long copy$default$3() {
            return this.numValues();
        }

        public String productPrefix() {
            return "KeyStat";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.key();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.numItems());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.numValues());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyStat;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "key";
                    break;
                }
                case 1: {
                    string = "numItems";
                    break;
                }
                case 2: {
                    string = "numValues";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.numItems()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.numValues()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KeyStat)) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyStat keyStat = (KeyStat)x$1;
            if (this.numItems() != keyStat.numItems()) return false;
            if (this.numValues() != keyStat.numValues()) return false;
            String string = this.key();
            String string2 = keyStat.key();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!keyStat.canEqual(this)) return false;
            return true;
        }

        public KeyStat(String key, long numItems, long numValues) {
            this.key = key;
            this.numItems = numItems;
            this.numValues = numValues;
            Product.$init$((Product)this);
        }
    }

    public static class ValueEntry
    implements Product,
    Serializable {
        private final AtomicLong timestamp;
        private final AtomicLong count;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AtomicLong timestamp() {
            return this.timestamp;
        }

        public AtomicLong count() {
            return this.count;
        }

        public ValueEntry copy(AtomicLong timestamp, AtomicLong count) {
            return new ValueEntry(timestamp, count);
        }

        public AtomicLong copy$default$1() {
            return this.timestamp();
        }

        public AtomicLong copy$default$2() {
            return this.count();
        }

        public String productPrefix() {
            return "ValueEntry";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.timestamp();
                    break;
                }
                case 1: {
                    object = this.count();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ValueEntry;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "timestamp";
                    break;
                }
                case 1: {
                    string = "count";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ValueEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            ValueEntry valueEntry = (ValueEntry)x$1;
            if (!BoxesRunTime.equalsNumNum((Number)this.timestamp(), (Number)valueEntry.timestamp())) return false;
            if (!BoxesRunTime.equalsNumNum((Number)this.count(), (Number)valueEntry.count())) return false;
            if (!valueEntry.canEqual(this)) return false;
            return true;
        }

        public ValueEntry(AtomicLong timestamp, AtomicLong count) {
            this.timestamp = timestamp;
            this.count = count;
            Product.$init$((Product)this);
        }
    }
}

