/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.db.Database;
import com.netflix.atlas.core.index.IndexStats;
import com.netflix.atlas.core.index.IndexStats$;
import com.netflix.atlas.core.index.RoaringTagIndex;
import com.netflix.atlas.core.index.TagIndex;
import com.netflix.atlas.core.index.TagQuery;
import com.netflix.atlas.core.index.TagQuery$;
import com.netflix.atlas.core.model.DataExpr;
import com.netflix.atlas.core.model.EvalContext;
import com.netflix.atlas.core.model.Query;
import com.netflix.atlas.core.model.TaggedItem;
import com.netflix.atlas.core.model.TimeSeries;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001D\u0007\u00011!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005bB%\u0001\u0005\u0004%I\u0001\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B#\t\u000f-\u0003!\u0019!C\u0001\u0019\"1!\u000b\u0001Q\u0001\n5CQa\u0015\u0001\u0005\u0002QCQa\u0018\u0001\u0005\n\u0001\u0014AcU5na2,7\u000b^1uS\u000e$\u0015\r^1cCN,'B\u0001\b\u0010\u0003\t!'M\u0003\u0002\u0011#\u0005!1m\u001c:f\u0015\t\u00112#A\u0003bi2\f7O\u0003\u0002\u0015+\u00059a.\u001a;gY&D(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!D\u0005\u0003E5\u0011\u0001\u0002R1uC\n\f7/Z\u0001\u0005I\u0006$\u0018\rE\u0002&[Ar!AJ\u0016\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0005%:\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\ta3$A\u0004qC\u000e\\\u0017mZ3\n\u00059z#\u0001\u0002'jgRT!\u0001L\u000e\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mz\u0011!B7pI\u0016d\u0017BA\u001b3\u0005)!\u0016.\\3TKJLWm]\u0001\u0007G>tg-[4\u0011\u0005abT\"A\u001d\u000b\u0005YR$BA\u001e\u0016\u0003!!\u0018\u0010]3tC\u001a,\u0017BA\u001f:\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"2\u0001Q!C!\t\u0001\u0003\u0001C\u0003$\u0007\u0001\u0007A\u0005C\u00037\u0007\u0001\u0007q'\u0001\u0005nCbd\u0015N\\3t+\u0005)\u0005C\u0001\u000eG\u0013\t95DA\u0002J]R\f\u0011\"\\1y\u0019&tWm\u001d\u0011\u0002\u001b5\f\u0007\u0010R1uCB|\u0017N\u001c;t\u00039i\u0017\r\u001f#bi\u0006\u0004x.\u001b8ug\u0002\nQ!\u001b8eKb,\u0012!\u0014\t\u0004\u001dB\u0003T\"A(\u000b\u0005-{\u0011BA)P\u0005!!\u0016mZ%oI\u0016D\u0018AB5oI\u0016D\b%A\u0004fq\u0016\u001cW\u000f^3\u0015\u0007\u0011*&\fC\u0003W\u0015\u0001\u0007q+A\u0004d_:$X\r\u001f;\u0011\u0005EB\u0016BA-3\u0005-)e/\u00197D_:$X\r\u001f;\t\u000bmS\u0001\u0019\u0001/\u0002\t\u0015D\bO\u001d\t\u0003cuK!A\u0018\u001a\u0003\u0011\u0011\u000bG/Y#yaJ\f!b\u00195fG.d\u0015.\\5u)\u0011\tGM\u001c9\u0011\u0005i\u0011\u0017BA2\u001c\u0005\u0011)f.\u001b;\t\u000b\u0015\\\u0001\u0019\u00014\u0002\u0011\r\fG/Z4pef\u0004\"aZ6\u000f\u0005!L\u0007CA\u0014\u001c\u0013\tQ7$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016\u001c\u0011\u0015y7\u00021\u0001F\u0003\u0005q\u0007\"B9\f\u0001\u0004)\u0015aA7bq\u0002")
public class SimpleStaticDatabase
implements Database {
    private final int maxLines;
    private final int maxDatapoints;
    private final TagIndex<TimeSeries> index;

    private int maxLines() {
        return this.maxLines;
    }

    private int maxDatapoints() {
        return this.maxDatapoints;
    }

    public TagIndex<TimeSeries> index() {
        return this.index;
    }

    @Override
    public List<TimeSeries> execute(EvalContext context, DataExpr expr) {
        List result;
        block2: {
            List list;
            TagQuery q = new TagQuery((Option<Query>)new Some((Object)expr.query()), TagQuery$.MODULE$.apply$default$2(), TagQuery$.MODULE$.apply$default$3(), TagQuery$.MODULE$.apply$default$4());
            long offset = expr.offset().toMillis();
            if (offset == 0L) {
                list = expr.eval(context, this.index().findItems(q)).data();
            } else {
                EvalContext offsetContext = context.withOffset(expr.offset().toMillis());
                list = result = expr.eval(offsetContext, this.index().findItems(q)).data().map((Function1 & Serializable)t -> t.offset(offset));
            }
            if (!result.nonEmpty()) break block2;
            int lines = result.size();
            int datapoints = lines * context.bufferSize();
            this.checkLimit("lines", lines, this.maxLines());
            this.checkLimit("datapoints", datapoints, this.maxDatapoints());
        }
        return result;
    }

    private void checkLimit(String category, int n, int max) {
        Predef$.MODULE$.require(n <= max, (Function0 & Serializable)() -> new StringBuilder(14).append("too many ").append(category).append(": ").append(n).append(" > ").append(max).toString());
    }

    public SimpleStaticDatabase(List<TimeSeries> data, Config config) {
        this.maxLines = config.getInt("max-lines");
        this.maxDatapoints = config.getInt("max-datapoints");
        this.index = new RoaringTagIndex((TaggedItem[])data.toArray(ClassTag$.MODULE$.apply(TimeSeries.class)), new IndexStats(IndexStats$.MODULE$.$lessinit$greater$default$1()));
    }
}

