/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.db.AggregateCollector;
import com.netflix.atlas.core.db.LimitedAggregateCollector;
import com.netflix.atlas.core.db.TimeSeriesBuffer;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.CollectorStats;
import com.netflix.atlas.core.model.CollectorStatsBuilder;
import com.netflix.atlas.core.model.ConsolidationFunction;
import com.netflix.atlas.core.model.DataExpr;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u0007\u000f\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006S\u0001!\tAK\u0003\u0005[\u0001\u0001a\u0006C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\t\r)\u0003\u0001\u0015!\u0003>\u0011\u001dY\u0005\u00011A\u0005\n1Cq!\u0015\u0001A\u0002\u0013%!\u000b\u0003\u0004Y\u0001\u0001\u0006K!\u0014\u0005\u00063\u0002!\tA\u0017\u0005\u00063\u0002!\t\u0001\u0019\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\u0011\u0011d\u0012:pkB\u0014\u00150Q4he\u0016<\u0017\r^3D_2dWm\u0019;pe*\u0011q\u0002E\u0001\u0003I\nT!!\u0005\n\u0002\t\r|'/\u001a\u0006\u0003'Q\tQ!\u0019;mCNT!!\u0006\f\u0002\u000f9,GO\u001a7jq*\tq#A\u0002d_6\u001c\u0001a\u0005\u0002\u00015A\u00111\u0004H\u0007\u0002\u001d%\u0011QD\u0004\u0002\u001a\u0019&l\u0017\u000e^3e\u0003\u001e<'/Z4bi\u0016\u001cu\u000e\u001c7fGR|'/\u0001\u0002giB\u0011\u0001E\n\b\u0003C\u0011j\u0011A\t\u0006\u0003GA\tQ!\\8eK2L!!\n\u0012\u0002\u0011\u0011\u000bG/Y#yaJL!a\n\u0015\u0003\u000f\u001d\u0013x.\u001e9Cs*\u0011QEI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003CA\u000e\u0001\u0011\u0015q\"\u00011\u0001 \u0005\u001dYU-\u001f+za\u0016\u0004\"a\f\u001d\u000f\u0005A2\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0019\u0003\u0019a$o\\8u})\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9D'A\u0004ck\u001a4WM]:\u0016\u0003u\u0002BAP\"F\u000f6\tqH\u0003\u0002A\u0003\u00069Q.\u001e;bE2,'B\u0001\"5\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\t~\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002G\u00075\t\u0001\u0001\u0005\u0002\u001c\u0011&\u0011\u0011J\u0004\u0002\u0013\u0003\u001e<'/Z4bi\u0016\u001cu\u000e\u001c7fGR|'/\u0001\u0005ck\u001a4WM]:!\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002\u001bB\u0011ajT\u0007\u0002i%\u0011\u0001\u000b\u000e\u0002\u0004\u0013:$\u0018A\u00042vM\u001a,'oU5{K~#S-\u001d\u000b\u0003'Z\u0003\"A\u0014+\n\u0005U#$\u0001B+oSRDqaV\u0004\u0002\u0002\u0003\u0007Q*A\u0002yIE\n1BY;gM\u0016\u00148+\u001b>fA\u0005\u0019\u0011\r\u001a3\u0015\u0005M[\u0006\"\u0002/\n\u0001\u0004i\u0016!\u00012\u0011\u0005mq\u0016BA0\u000f\u0005A!\u0016.\\3TKJLWm\u001d\"vM\u001a,'\u000fF\u0004NC\u001a$ho_?\t\u000b\tT\u0001\u0019A2\u0002\tQ\fwm\u001d\t\u0005_\u0011tc&\u0003\u0002fu\t\u0019Q*\u00199\t\u000b\u001dT\u0001\u0019\u00015\u0002\r\tdwnY6t!\rIg.\u001d\b\u0003U2t!!M6\n\u0003UJ!!\u001c\u001b\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002niA\u0011\u0011E]\u0005\u0003g\n\u0012QA\u00117pG.DQ!\u001e\u0006A\u00025\u000bA!Y4he\")qO\u0003a\u0001q\u0006\u00111M\u001a\t\u0003CeL!A\u001f\u0012\u0003+\r{gn]8mS\u0012\fG/[8o\rVt7\r^5p]\")AP\u0003a\u0001\u001b\u0006AQ.\u001e7uSBdW\rC\u0003\u007f\u0015\u0001\u0007q0A\u0005oK^\u0014UO\u001a4feB)a*!\u0001d;&\u0019\u00111\u0001\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0014A\u0002:fgVdG/\u0006\u0002\u0002\nA\u0019\u0011N\\/\u0002\u000bM$\u0018\r^:\u0016\u0005\u0005=\u0001cA\u0011\u0002\u0012%\u0019\u00111\u0003\u0012\u0003\u001d\r{G\u000e\\3di>\u00148\u000b^1ug\u0002")
public class GroupByAggregateCollector
extends LimitedAggregateCollector {
    private final DataExpr.GroupBy ft;
    private final HashMap<String, AggregateCollector> buffers;
    private int bufferSize;

    private HashMap<String, AggregateCollector> buffers() {
        return this.buffers;
    }

    private int bufferSize() {
        return this.bufferSize;
    }

    private void bufferSize_$eq(int x$1) {
        this.bufferSize = x$1;
    }

    @Override
    public void add(TimeSeriesBuffer b) {
        String k = this.ft.keyString(b.tags());
        if (k == null) {
            return;
        }
        AggregateCollector c = (AggregateCollector)this.buffers().get((Object)k).getOrElse((Function0 & Serializable)() -> {
            void var3_3;
            this.checkLimits(this.buffers().size() + 1, (this.buffers().size() + 1) * b.values().length);
            AggregateCollector collector = this.newCollector($this.ft.af());
            this.buffers().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)collector));
            return var3_3;
        });
        c.add(b);
    }

    @Override
    public int add(Map<String, String> tags, List<Block> blocks, int aggr, ConsolidationFunction cf, int multiple, Function1<Map<String, String>, TimeSeriesBuffer> newBuffer) {
        String k = this.ft.keyString(tags);
        if (k == null) {
            return 0;
        }
        AggregateCollector c = (AggregateCollector)this.buffers().get((Object)k).getOrElse((Function0 & Serializable)() -> {
            void var2_2;
            if (this.bufferSize() > 0) {
                this.checkLimits(this.buffers().size() + 1, (this.buffers().size() + 1) * this.bufferSize());
            }
            AggregateCollector collector = this.newCollector($this.ft.af());
            this.buffers().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)collector));
            return var2_2;
        });
        this.bufferSize_$eq(c.add(tags, blocks, aggr, cf, multiple, newBuffer));
        return this.bufferSize();
    }

    @Override
    public List<TimeSeriesBuffer> result() {
        return ((IterableOnceOps)this.buffers().values().flatMap((Function1 & Serializable)x$1 -> x$1.result())).toList();
    }

    @Override
    public CollectorStats stats() {
        CollectorStatsBuilder statBuffer = new CollectorStatsBuilder();
        this.buffers().values().foreach((Function1 & Serializable)c -> {
            statBuffer.update(c.stats());
            return BoxedUnit.UNIT;
        });
        return statBuffer.result();
    }

    public GroupByAggregateCollector(DataExpr.GroupBy ft) {
        this.ft = ft;
        this.buffers = HashMap$.MODULE$.empty();
        this.bufferSize = -1;
    }
}

