/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.model.ArrayBlock;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.ConstantBlock;
import com.netflix.atlas.core.model.RollupBlock;
import com.netflix.atlas.core.model.SparseBlock;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BlockStats$ {
    public static final BlockStats$ MODULE$ = new BlockStats$();
    private static final CompositeRegistry registry = Spectator.globalRegistry();
    private static final AtomicLong arrayCount = MODULE$.createGauge("atlas.block.arrayCount");
    private static final AtomicLong constantCount = MODULE$.createGauge("atlas.block.constantCount");
    private static final AtomicLong sparseCount = MODULE$.createGauge("atlas.block.sparseCount");
    private static final AtomicLong arrayBytes = MODULE$.createGauge("atlas.block.arrayBytes");
    private static final AtomicLong constantBytes = MODULE$.createGauge("atlas.block.constantBytes");
    private static final AtomicLong sparseBytes = MODULE$.createGauge("atlas.block.sparseBytes");

    private CompositeRegistry registry() {
        return registry;
    }

    public AtomicLong arrayCount() {
        return arrayCount;
    }

    public AtomicLong constantCount() {
        return constantCount;
    }

    public AtomicLong sparseCount() {
        return sparseCount;
    }

    public AtomicLong arrayBytes() {
        return arrayBytes;
    }

    public AtomicLong constantBytes() {
        return constantBytes;
    }

    public AtomicLong sparseBytes() {
        return sparseBytes;
    }

    private AtomicLong createGauge(String name) {
        return (AtomicLong)((PolledMeter.Builder)PolledMeter.using((Registry)this.registry()).withName(name)).monitorValue((Number)new AtomicLong(0L));
    }

    private void inc(Block block, AtomicLong count, AtomicLong bytes) {
        count.incrementAndGet();
        bytes.addAndGet(block.byteCount());
    }

    public void inc(Block block2) {
        Block block3 = block2;
        if (block3 instanceof ArrayBlock) {
            this.inc(block2, this.arrayCount(), this.arrayBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (block3 instanceof ConstantBlock) {
            this.inc(block2, this.constantCount(), this.constantBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (block3 instanceof SparseBlock) {
            this.inc(block2, this.sparseCount(), this.sparseBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (block3 instanceof RollupBlock) {
            RollupBlock rollupBlock = (RollupBlock)block3;
            rollupBlock.blocks().foreach((Function1 & Serializable)block -> {
                BlockStats$.MODULE$.inc(block);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void dec(Block block, AtomicLong count, AtomicLong bytes) {
        count.decrementAndGet();
        bytes.addAndGet(-block.byteCount());
    }

    public void dec(Block block2) {
        Block block3 = block2;
        if (block3 instanceof ArrayBlock) {
            this.dec(block2, this.arrayCount(), this.arrayBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (block3 instanceof ConstantBlock) {
            this.dec(block2, this.constantCount(), this.constantBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (block3 instanceof SparseBlock) {
            this.dec(block2, this.sparseCount(), this.sparseBytes());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (block3 instanceof RollupBlock) {
            RollupBlock rollupBlock = (RollupBlock)block3;
            rollupBlock.blocks().foreach((Function1 & Serializable)block -> {
                BlockStats$.MODULE$.dec(block);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void update(Block oldBlock, Block newBlock) {
        this.dec(oldBlock);
        this.inc(newBlock);
    }

    private double percent(long value, long total) {
        return total == 0L ? 0.0 : 100.0 * (double)value / (double)total;
    }

    private Object mkStatMap(long array, long constant, long sparse) {
        Map raw = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"array"), (Object)BoxesRunTime.boxToLong((long)array)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"constant"), (Object)BoxesRunTime.boxToLong((long)constant)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sparse"), (Object)BoxesRunTime.boxToLong((long)sparse))}));
        long total = BoxesRunTime.unboxToLong((Object)raw.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"total"), (Object)BoxesRunTime.boxToLong((long)total)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"raw"), (Object)raw), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"percents"), (Object)raw.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t._1()), (Object)BoxesRunTime.boxToDouble((double)MODULE$.percent(t._2$mcJ$sp(), total)))))}));
    }

    public Map<String, Object> statsMap() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"counts"), this.mkStatMap(this.arrayCount().get(), this.constantCount().get(), this.sparseCount().get())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytes"), this.mkStatMap(this.arrayBytes().get(), this.constantBytes().get(), this.sparseBytes().get()))}));
    }

    public void clear() {
        this.arrayCount().set(0L);
        this.sparseCount().set(0L);
        this.constantCount().set(0L);
        this.arrayBytes().set(0L);
        this.sparseBytes().set(0L);
        this.constantCount().set(0L);
    }

    private BlockStats$() {
    }
}

