/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import io.confluent.ksql.metrics.TopicSensors;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import java.io.IOException;

@JsonDeserialize(using=QueryHostStatDeserializer.class)
@JsonSerialize(using=QueryHostStatSerializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryHostStat
extends TopicSensors.Stat {
    private final KsqlHostInfoEntity host;

    @JsonCreator
    public QueryHostStat(@JsonProperty(value="host") KsqlHostInfoEntity host, @JsonProperty(value="name") String name, @JsonProperty(value="value") double value, @JsonProperty(value="timestamp") long timestamp) {
        super(name, value, timestamp);
        this.host = host;
    }

    public static QueryHostStat fromStat(TopicSensors.Stat stat, KsqlHostInfoEntity host) {
        return new QueryHostStat(host, stat.name(), stat.getValue(), stat.getTimestamp());
    }

    public KsqlHostInfoEntity host() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryHostStat)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueryHostStat that = (QueryHostStat)((Object)o);
        return Objects.equal((Object)this.host, (Object)that.host);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.host});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class QueryHostStatSerializer
    extends JsonSerializer<QueryHostStat> {
        QueryHostStatSerializer() {
        }

        public void serialize(QueryHostStat stat, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", stat.name());
            jsonGenerator.writeStringField("host", stat.host().toString());
            jsonGenerator.writeObjectField("value", (Object)stat.getValue());
            jsonGenerator.writeNumberField("timestamp", stat.getTimestamp());
            jsonGenerator.writeEndObject();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class QueryHostStatDeserializer
    extends JsonDeserializer<QueryHostStat> {
        QueryHostStatDeserializer() {
        }

        public QueryHostStat deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String name = node.get("name").textValue();
            double value = node.get("value").numberValue().doubleValue();
            long timestamp = node.get("timestamp").numberValue().longValue();
            KsqlHostInfoEntity host = new KsqlHostInfoEntity(node.get("host").textValue());
            return new QueryHostStat(host, name, value, timestamp);
        }
    }
}

