/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Objects;
import java.util.Optional;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.regexp.Regexp;

public class StringSchemaValidatingVisitor
extends Visitor {
    private final Object subject;
    private String stringSubject;
    private int stringLength;
    private final ValidatingVisitor owner;

    public StringSchemaValidatingVisitor(Object subject, ValidatingVisitor owner) {
        this.subject = subject;
        this.owner = Objects.requireNonNull(owner, "failureReporter cannot be null");
    }

    @Override
    void visitStringSchema(StringSchema stringSchema) {
        if (this.owner.passesTypeCheck(String.class, stringSchema.requireString(), stringSchema.isNullable())) {
            this.stringSubject = (String)this.subject;
            this.stringLength = this.stringSubject.codePointCount(0, this.stringSubject.length());
            super.visitStringSchema(stringSchema);
        }
    }

    @Override
    void visitMinLength(Integer minLength) {
        if (minLength != null && this.stringLength < minLength) {
            this.owner.failure("expected minLength: " + minLength + ", actual: " + this.stringLength, "minLength");
        }
    }

    @Override
    void visitMaxLength(Integer maxLength) {
        if (maxLength != null && this.stringLength > maxLength) {
            this.owner.failure("expected maxLength: " + maxLength + ", actual: " + this.stringLength, "maxLength");
        }
    }

    @Override
    void visitPattern(Regexp pattern) {
        if (pattern != null && pattern.patternMatchingFailure(this.stringSubject).isPresent()) {
            String message = String.format("string [%s] does not match pattern %s", this.subject, pattern.toString());
            this.owner.failure(message, "pattern");
        }
    }

    @Override
    void visitFormat(FormatValidator formatValidator) {
        Optional<String> failure = formatValidator.validate(this.stringSubject);
        if (failure.isPresent()) {
            this.owner.failure(failure.get(), "format");
        }
    }
}

