/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.serde.deserializers;

import io.circe.parser.package$;
import io.conduktor.serde.domain.DeserializedData;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedBytes$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedDouble$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedEmbeddedAvro$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedFloat$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedInt$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedJson$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedLong$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedMessagePack$;
import io.conduktor.serde.domain.DeserializedFormat$DeserializedString$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Base64;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.msgpack.core.MessagePack;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import zio.ZIO;
import zio.ZIO$;
import zio.kafka.serde.Deserializer;
import zio.kafka.serde.Deserializer$;

public final class Deserializers$ {
    public static final Deserializers$ MODULE$ = new Deserializers$();
    private static final Deserializer<Object, Option<DeserializedData>> longDeserializer = Deserializer$.MODULE$.long().map((Function1 & Serializable)object -> Deserializers$.$anonfun$longDeserializer$1(BoxesRunTime.unboxToLong((Object)object))).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> intDeserializer = Deserializer$.MODULE$.int().map((Function1 & Serializable)object -> Deserializers$.$anonfun$intDeserializer$1(BoxesRunTime.unboxToInt((Object)object))).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> floatDeserializer = Deserializer$.MODULE$.float().map((Function1 & Serializable)object -> Deserializers$.$anonfun$floatDeserializer$1(BoxesRunTime.unboxToFloat((Object)object))).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> doubleDeserializer = Deserializer$.MODULE$.double().map((Function1 & Serializable)object -> Deserializers$.$anonfun$doubleDeserializer$1(BoxesRunTime.unboxToDouble((Object)object))).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> stringDeserializer = Deserializer$.MODULE$.string().map((Function1 & Serializable)x$1 -> new DeserializedData(DeserializedFormat$DeserializedString$.MODULE$, (String)x$1)).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> jsonDeserializer = Deserializer$.MODULE$.string().mapM((Function1 & Serializable)string -> ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> package$.MODULE$.parse(string))).map((Function1 & Serializable)json -> new DeserializedData(DeserializedFormat$DeserializedJson$.MODULE$, json.noSpaces())).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> bytesBase64Deserializer = Deserializer$.MODULE$.byteArray().map((Function1 & Serializable)data -> {
        String string = Base64.getEncoder().encodeToString((byte[])data);
        return new DeserializedData(DeserializedFormat$DeserializedBytes$.MODULE$, string);
    }).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> messagePackDeserializer = Deserializer$.MODULE$.byteArray().mapM((Function1 & Serializable)data -> ZIO.ZIOAutoCloseableOps$.MODULE$.bracketAuto$extension(ZIO$.MODULE$.ZIOAutoCloseableOps(ZIO$.MODULE$.effect((Function0 & Serializable)() -> MessagePack.newDefaultUnpacker((byte[])data))), (Function1 & Serializable)unpacker -> ZIO$.MODULE$.effect((Function0 & Serializable)() -> {
        String string = unpacker.unpackValue().toJson();
        return new DeserializedData(DeserializedFormat$DeserializedMessagePack$.MODULE$, string);
    }))).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());
    private static final Deserializer<Object, Option<DeserializedData>> avroEmbeddedDeserializer = Deserializer$.MODULE$.apply((Function3 & Serializable)(x$2, x$3, bytes) -> {
        byte[] byArray = bytes;
        ZIO zIO = byArray == null ? ZIO$.MODULE$.succeed((Function0 & Serializable)() -> null) : ZIO$.MODULE$.effect((Function0 & Serializable)() -> {
            GenericDatumReader reader = new GenericDatumReader();
            ByteArrayInputStream dataAsInputStream = new ByteArrayInputStream((byte[])bytes);
            DataFileStream dataFileStream = new DataFileStream((InputStream)dataAsInputStream, (DatumReader)reader);
            return new DeserializedData(DeserializedFormat$DeserializedEmbeddedAvro$.MODULE$, CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)dataFileStream).asScala().mkString("[", ", ", "]"));
        });
        return zIO;
    }).asOption((.less.colon.less)$less$colon$less$.MODULE$.refl());

    public Deserializer<Object, Option<DeserializedData>> longDeserializer() {
        return longDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> intDeserializer() {
        return intDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> floatDeserializer() {
        return floatDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> doubleDeserializer() {
        return doubleDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> stringDeserializer() {
        return stringDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> jsonDeserializer() {
        return jsonDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> bytesBase64Deserializer() {
        return bytesBase64Deserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> messagePackDeserializer() {
        return messagePackDeserializer;
    }

    public Deserializer<Object, Option<DeserializedData>> avroEmbeddedDeserializer() {
        return avroEmbeddedDeserializer;
    }

    public String io$conduktor$serde$deserializers$Deserializers$$recordAsJson(Object record) {
        return record.toString();
    }

    public static final /* synthetic */ DeserializedData $anonfun$longDeserializer$1(long l) {
        return new DeserializedData(DeserializedFormat$DeserializedLong$.MODULE$, Long.toString(l));
    }

    public static final /* synthetic */ DeserializedData $anonfun$intDeserializer$1(int n) {
        return new DeserializedData(DeserializedFormat$DeserializedInt$.MODULE$, Integer.toString(n));
    }

    public static final /* synthetic */ DeserializedData $anonfun$floatDeserializer$1(float f) {
        return new DeserializedData(DeserializedFormat$DeserializedFloat$.MODULE$, Float.toString(f));
    }

    public static final /* synthetic */ DeserializedData $anonfun$doubleDeserializer$1(double d) {
        return new DeserializedData(DeserializedFormat$DeserializedDouble$.MODULE$, Double.toString(d));
    }

    private Deserializers$() {
    }
}

