/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.tracing;

import cats.effect.tracing.RingBuffer;
import cats.effect.tracing.TracingConstants;
import cats.effect.tracing.TracingEvent;
import cats.effect.tracing.TracingPlatform;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Tracing$
extends TracingPlatform {
    public static final Tracing$ MODULE$ = new Tracing$();
    private static final String TurnRight = "\u2570";
    private static final String Junction = "\u251c";
    private static final String[] runLoopFilter = (String[])((Object[])new String[]{"cats.effect.", "scala.runtime.", "scala.scalajs.runtime."});
    private static final String[] stackTraceClassNameFilter = (String[])((Object[])new String[]{"cats.", "sbt.", "java.", "jdk.", "sun.", "scala.", "org.scalajs."});

    public TracingEvent buildEvent() {
        return new TracingEvent.StackTrace();
    }

    public final String[] stackTraceClassNameFilter() {
        return stackTraceClassNameFilter;
    }

    public StackTraceElement combineOpAndCallSite(StackTraceElement methodSite, StackTraceElement callSite) {
        String methodSiteMethodName = methodSite.getMethodName();
        String op = this.decodeMethodName(methodSiteMethodName);
        return new StackTraceElement(new StringBuilder(3).append(op).append(" @ ").append(callSite.getClassName()).toString(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
    }

    public boolean isInternalClass(String className) {
        int len = this.stackTraceClassNameFilter().length;
        for (int i = 0; i < len; ++i) {
            if (!className.startsWith(this.stackTraceClassNameFilter()[i])) continue;
            return true;
        }
        return false;
    }

    public StackTraceElement cats$effect$tracing$Tracing$$getOpAndCallSite(StackTraceElement[] stackTrace) {
        int len = stackTrace.length;
        for (int idx = 1; idx < len; ++idx) {
            String callSiteFileName;
            String callSiteMethodName;
            StackTraceElement methodSite = stackTrace[idx - 1];
            StackTraceElement callSite = stackTrace[idx];
            String callSiteClassName = callSite.getClassName();
            if (this.applyStackTraceFilter(callSiteClassName, callSiteMethodName = callSite.getMethodName(), callSiteFileName = callSite.getFileName())) continue;
            return this.combineOpAndCallSite(methodSite, callSite);
        }
        return null;
    }

    public void augmentThrowable(boolean enhancedExceptions, Throwable t, RingBuffer events) {
        block1: {
            boolean augmented;
            StackTraceElement[] stackTrace;
            if (!TracingConstants.isStackTracing || !enhancedExceptions || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])(stackTrace = t.getStackTrace())))) break block1;
            boolean bl = augmented = ((StackTraceElement)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])stackTrace))).getClassName().indexOf(64) != -1;
            if (!augmented) {
                StackTraceElement[] prefix = this.dropRunLoopFrames$1(stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])this.getFrames(events).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                t.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])prefix), (Object)suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
            }
        }
    }

    public List<StackTraceElement> getFrames(RingBuffer events) {
        return events.toList().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TracingEvent, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TracingEvent.StackTrace) {
                    TracingEvent.StackTrace stackTrace = (TracingEvent.StackTrace)A1;
                    object = Tracing$.MODULE$.cats$effect$tracing$Tracing$$getOpAndCallSite(stackTrace.getStackTrace());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TracingEvent x1) {
                TracingEvent tracingEvent = x1;
                boolean bl = tracingEvent instanceof TracingEvent.StackTrace;
                return bl;
            }
        }).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Tracing$.$anonfun$getFrames$2(x$1)));
    }

    public String prettyPrint(RingBuffer events) {
        List<StackTraceElement> frames = this.getFrames(events);
        return ((List)frames.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StackTraceElement frame = (StackTraceElement)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String junc = index == frames.length() - 1 ? TurnRight : Junction;
            String string = new StringBuilder(2).append(" ").append(junc).append(" ").append(frame).toString();
            return string;
        }).mkString(System.lineSeparator());
    }

    private final boolean applyRunLoopFilter$1(StackTraceElement ste) {
        String name = ste.getClassName();
        int len = runLoopFilter.length;
        for (int i = 0; i < len; ++i) {
            if (!name.startsWith(runLoopFilter[i])) continue;
            return true;
        }
        return false;
    }

    private final StackTraceElement[] dropRunLoopFrames$1(StackTraceElement[] frames) {
        ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
        for (StackTraceElement frame : frames) {
            if (this.applyRunLoopFilter$1(frame)) {
                return (StackTraceElement[])buffer.toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
            }
            buffer.$plus$eq((Object)frame);
        }
        return (StackTraceElement[])buffer.toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
    }

    public static final /* synthetic */ boolean $anonfun$getFrames$2(StackTraceElement x$1) {
        return x$1 != null;
    }

    private Tracing$() {
    }
}

