/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.nucleus;

import com.linkedin.cytodynamics.nucleus.BaseOriginRestrictionFilter;
import com.linkedin.cytodynamics.nucleus.OriginMatchResults;
import java.io.File;
import java.net.URL;

public class FileOriginRestrictionFilter
extends BaseOriginRestrictionFilter {
    private File directory;
    private final boolean recursive;

    protected FileOriginRestrictionFilter(File directory, boolean recursive, OriginMatchResults originMatchResults) {
        super(originMatchResults);
        this.directory = directory;
        this.recursive = recursive;
    }

    @Override
    public boolean matches(URL url) {
        if (!url.getProtocol().equals("file")) {
            return false;
        }
        try {
            File theFile = new File(url.toURI());
            if (!this.recursive) {
                return theFile.getParentFile().equals(this.directory);
            }
            File currentFile = theFile;
            while (currentFile.getParentFile() != null) {
                if (currentFile.getParentFile().equals(this.directory)) {
                    return true;
                }
                currentFile = currentFile.getParentFile();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

