/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EncodedKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;
import org.slieb.throwables.SupplierWithThrowable;

public class PublicKeyBuilder {
    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    private static class BuildFinalImpl<PK extends PublicKey>
    implements BuildFinal<PK> {
        private final SupplierWithThrowable<PK, GeneralSecurityException> supplier;

        BuildFinalImpl(SupplierWithThrowable<PK, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public PK build() throws GeneralSecurityException {
            return (PK)((PublicKey)this.supplier.getWithThrowable());
        }
    }

    private static class DHParametersStageImpl<PK extends PublicKey>
    implements DHParameterStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        DHParametersStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<DHPublicKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<DHPublicKey>(() -> (DHPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }

        @Override
        public BuildFinal<DHPublicKey> withKeySpec(DHPublicKeySpec keySpec) {
            return new BuildFinalImpl<DHPublicKey>(() -> (DHPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }
    }

    private static class ParametersStageImpl<PK extends PublicKey>
    implements ParametersStage<PK> {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        ParametersStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<PK> withKeySpec(KeySpec keySpec) {
            return new BuildFinalImpl(() -> ((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }
    }

    private static class DSAParametersStageImpl
    implements DSAParametersStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        DSAParametersStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<DSAPublicKey> withKeySpec(DSAPublicKeySpec keySpec) {
            return new BuildFinalImpl<DSAPublicKey>(() -> (DSAPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }

        @Override
        public BuildFinal<DSAPublicKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<DSAPublicKey>(() -> (DSAPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }
    }

    private static class ECParametersStageImpl
    implements ECParametersStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        ECParametersStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<ECPublicKey> withKeySpec(ECPublicKeySpec keySpec) {
            return new BuildFinalImpl<ECPublicKey>(() -> (ECPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }

        @Override
        public BuildFinal<ECPublicKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<ECPublicKey>(() -> (ECPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }
    }

    private static class RSAParametersStageImpl
    implements RSAParametersStage {
        private final SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier;

        RSAParametersStageImpl(SupplierWithThrowable<KeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<RSAPublicKey> withKeySpec(RSAPublicKeySpec keySpec) {
            return new BuildFinalImpl<RSAPublicKey>(() -> (RSAPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }

        @Override
        public BuildFinal<RSAPublicKey> withKeySpec(EncodedKeySpec keySpec) {
            return new BuildFinalImpl<RSAPublicKey>(() -> (RSAPublicKey)((KeyFactory)this.supplier.getWithThrowable()).generatePublic(keySpec));
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<KeyFactory, GeneralSecurityException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public <PK extends PublicKey> ParametersStage<PK> withAlgorithm(String algorithm) {
            return new ParametersStageImpl(this.getInstance().withAlgorithm(algorithm));
        }

        @Override
        public <PK extends PublicKey> ParametersStage<PK> withAlgorithmAndProvider(String algorithm, String provider) {
            return new ParametersStageImpl(this.getInstance().withAlgorithmAndProvider(algorithm, provider));
        }

        @Override
        public RSAParametersStage withRSA() {
            return new RSAParametersStageImpl(this.getInstance().withAlgorithm("RSA"));
        }

        @Override
        public ECParametersStage withEC() {
            return new ECParametersStageImpl(this.getInstance().withAlgorithm("EC"));
        }

        @Override
        public DSAParametersStage withDSA() {
            return new DSAParametersStageImpl(this.getInstance().withAlgorithm("DSA"));
        }

        @Override
        public DHParameterStage withDH() {
            return new DHParametersStageImpl(this.getInstance().withAlgorithm("DH"));
        }
    }

    public static interface BuildFinal<PK extends PublicKey> {
        public PK build() throws GeneralSecurityException;
    }

    public static interface DHParameterStage
    extends EncodedParametersStage<DHPublicKey> {
        public BuildFinal<DHPublicKey> withKeySpec(DHPublicKeySpec var1);
    }

    public static interface ECParametersStage
    extends EncodedParametersStage<ECPublicKey> {
        public BuildFinal<ECPublicKey> withKeySpec(ECPublicKeySpec var1);
    }

    public static interface DSAParametersStage
    extends EncodedParametersStage<DSAPublicKey> {
        public BuildFinal<DSAPublicKey> withKeySpec(DSAPublicKeySpec var1);
    }

    public static interface RSAParametersStage
    extends EncodedParametersStage<RSAPublicKey> {
        public BuildFinal<RSAPublicKey> withKeySpec(RSAPublicKeySpec var1);
    }

    public static interface EncodedParametersStage<PK extends PublicKey> {
        public BuildFinal<PK> withKeySpec(EncodedKeySpec var1);
    }

    public static interface ParametersStage<PK extends PublicKey> {
        public BuildFinal<PK> withKeySpec(KeySpec var1);
    }

    public static interface InstanceStage {
        public <PK extends PublicKey> ParametersStage<PK> withAlgorithm(String var1);

        public <PK extends PublicKey> ParametersStage<PK> withAlgorithmAndProvider(String var1, String var2);

        public RSAParametersStage withRSA();

        public ECParametersStage withEC();

        public DSAParametersStage withDSA();

        public DHParameterStage withDH();
    }
}

