/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.security.GeneralSecurityException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import org.slieb.throwables.SupplierWithThrowable;

public class PasswordBuilder {
    public static InitialStage builder() {
        return new InitialStageImpl();
    }

    private static class SecretKeyFactoryBuildFinal
    implements BuildFinal {
        private final SupplierWithThrowable<PBEKey, GeneralSecurityException> secretKeySupplier;

        SecretKeyFactoryBuildFinal(SupplierWithThrowable<PBEKey, GeneralSecurityException> secretKeySupplier) {
            this.secretKeySupplier = secretKeySupplier;
        }

        @Override
        public PBEKey build() throws GeneralSecurityException {
            return (PBEKey)this.secretKeySupplier.getWithThrowable();
        }
    }

    private static class SecretKeySpecBuildFinal
    implements BuildFinal {
        private final SupplierWithThrowable<PBEKey, GeneralSecurityException> keySpecSupplier;

        SecretKeySpecBuildFinal(SupplierWithThrowable<PBEKey, GeneralSecurityException> keySpecSupplier) {
            this.keySpecSupplier = keySpecSupplier;
        }

        @Override
        public PBEKey build() throws GeneralSecurityException {
            return (PBEKey)this.keySpecSupplier.getWithThrowable();
        }
    }

    private static class KeyLengthStageImpl
    implements KeyLengthStage {
        private final SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier;
        private final char[] password;
        private final int iterations;
        private final byte[] salt;

        KeyLengthStageImpl(SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier, char[] password, int iterations, byte[] salt) {
            this.supplier = supplier;
            this.password = password;
            this.iterations = iterations;
            this.salt = salt;
        }

        @Override
        public BuildFinal withKeyLength(int keyLength) {
            return new SecretKeySpecBuildFinal((SupplierWithThrowable<PBEKey, GeneralSecurityException>)((SupplierWithThrowable)() -> (PBEKey)((SecretKeyFactory)this.supplier.getWithThrowable()).generateSecret(new PBEKeySpec(this.password, this.salt, this.iterations, keyLength))));
        }
    }

    private static class SaltStageImpl
    implements SaltStage {
        private final SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier;
        private final char[] password;
        private final int iterations;

        SaltStageImpl(SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier, char[] password, int iterations) {
            this.supplier = supplier;
            this.password = password;
            this.iterations = iterations;
        }

        @Override
        public KeyLengthStage withSalt(byte[] salt) {
            return new KeyLengthStageImpl(this.supplier, this.password, this.iterations, salt);
        }
    }

    private static class IterationStageImpl
    implements IterationStage {
        private final SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier;
        private final char[] password;

        IterationStageImpl(SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier, char[] password) {
            this.supplier = supplier;
            this.password = password;
        }

        @Override
        public SaltStage withIterations(int iterations) {
            return new SaltStageImpl(this.supplier, this.password, iterations);
        }
    }

    private static class PasswordStageImpl
    implements PasswordStage {
        private final SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier;

        PasswordStageImpl(SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public IterationStage withPassword(char[] password) {
            return new IterationStageImpl(this.supplier, password);
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public PasswordStage withAlgorithm(String algorithm) {
            return new PasswordStageImpl((SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> SecretKeyFactory.getInstance(algorithm)));
        }

        @Override
        public PasswordStage withAlgorithmAndProvider(String algorithm, String provider) {
            return new PasswordStageImpl((SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> SecretKeyFactory.getInstance(algorithm, provider)));
        }

        @Override
        public PasswordStage withPBKDF2WithHmacSHA256() {
            return new PasswordStageImpl((SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256")));
        }

        @Override
        public PasswordStage withPBKDF2WithHmacSHA384() {
            return new PasswordStageImpl((SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> SecretKeyFactory.getInstance("PBKDF2WithHmacSHA384")));
        }

        @Override
        public PasswordStage withPBKDF2WithHmacSHA512() {
            return new PasswordStageImpl((SupplierWithThrowable<SecretKeyFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512")));
        }
    }

    public static interface BuildFinal {
        public PBEKey build() throws GeneralSecurityException;
    }

    public static interface KeyLengthStage {
        public BuildFinal withKeyLength(int var1);
    }

    public static interface SaltStage {
        public KeyLengthStage withSalt(byte[] var1);
    }

    public static interface IterationStage {
        public SaltStage withIterations(int var1);
    }

    public static interface PasswordStage {
        public IterationStage withPassword(char[] var1);
    }

    public static interface InitialStage {
        public PasswordStage withAlgorithm(String var1);

        public PasswordStage withAlgorithmAndProvider(String var1, String var2);

        public PasswordStage withPBKDF2WithHmacSHA256();

        public PasswordStage withPBKDF2WithHmacSHA384();

        public PasswordStage withPBKDF2WithHmacSHA512();
    }
}

