/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slieb.throwables.SupplierWithThrowable;

public class PKCS8EncodedKeySpecBuilder {
    public static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    private PKCS8EncodedKeySpecBuilder() {
    }

    public static ContentStage builder() {
        return new ContentStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final SupplierWithThrowable<PKCS8EncodedKeySpec, Exception> supplier;

        BuildFinalImpl(SupplierWithThrowable<PKCS8EncodedKeySpec, Exception> supplier) {
            this.supplier = supplier;
        }

        @Override
        public PKCS8EncodedKeySpec build() throws Exception {
            return (PKCS8EncodedKeySpec)this.supplier.getWithThrowable();
        }
    }

    private static class PasswordStageImpl
    implements PasswordStage {
        private final SupplierWithThrowable<byte[], Exception> supplier;

        PasswordStageImpl(SupplierWithThrowable<byte[], Exception> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal withPassword(char[] password) {
            return new BuildFinalImpl((SupplierWithThrowable<PKCS8EncodedKeySpec, Exception>)((SupplierWithThrowable)() -> {
                byte[] privateKeyBytes = (byte[])this.supplier.getWithThrowable();
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(privateKeyBytes);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
                Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
                SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(password));
                cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
                return encryptedPrivateKeyInfo.getKeySpec(cipher);
            }));
        }

        @Override
        public BuildFinal withNoPassword() {
            return new BuildFinalImpl((SupplierWithThrowable<PKCS8EncodedKeySpec, Exception>)((SupplierWithThrowable)() -> new PKCS8EncodedKeySpec((byte[])this.supplier.getWithThrowable())));
        }
    }

    private static class ContentStageImpl
    implements ContentStage {
        private ContentStageImpl() {
        }

        @Override
        public PasswordStage withContent(String content) {
            return new PasswordStageImpl((SupplierWithThrowable<byte[], Exception>)((SupplierWithThrowable)() -> {
                Matcher matcher = KEY_PATTERN.matcher(content);
                if (!matcher.find()) {
                    throw new GeneralSecurityException("found no private key!");
                }
                return Base64.getMimeDecoder().decode(matcher.group(1));
            }));
        }

        @Override
        public PasswordStage withReader(Reader reader) {
            return new PasswordStageImpl((SupplierWithThrowable<byte[], Exception>)((SupplierWithThrowable)() -> {
                int numCharsRead;
                char[] arr = new char[16384];
                StringBuilder buffer = new StringBuilder();
                while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                    buffer.append(arr, 0, numCharsRead);
                }
                reader.close();
                String content = buffer.toString();
                Matcher matcher = KEY_PATTERN.matcher(content);
                if (!matcher.find()) {
                    throw new GeneralSecurityException("found no private key!");
                }
                return Base64.getMimeDecoder().decode(matcher.group(1));
            }));
        }
    }

    public static interface BuildFinal {
        public PKCS8EncodedKeySpec build() throws Exception;
    }

    public static interface PasswordStage {
        public BuildFinal withPassword(char[] var1);

        public BuildFinal withNoPassword();
    }

    public static interface ContentStage {
        public PasswordStage withContent(String var1);

        public PasswordStage withReader(Reader var1);
    }
}

