/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.Objects;
import org.slieb.throwables.SupplierWithThrowable;

public class CertificateBuilder {
    private CertificateBuilder() {
    }

    public static InstanceStage builder() {
        return new InstanceStageImpl();
    }

    private static class BuildFinalImpl<T extends Certificate>
    implements BuildFinal<T> {
        private final SupplierWithThrowable<CertificateFactory, CertificateException> supplier;
        private final SupplierWithThrowable<InputStream, IOException> inputStreamSupplier;

        BuildFinalImpl(SupplierWithThrowable<CertificateFactory, CertificateException> supplier, SupplierWithThrowable<InputStream, IOException> inputStreamSupplier) {
            this.supplier = supplier;
            this.inputStreamSupplier = inputStreamSupplier;
        }

        @Override
        public T build() throws CertificateException {
            return (T)((CertificateFactory)this.supplier.getWithThrowable()).generateCertificate((InputStream)this.inputStreamSupplier.get());
        }

        @Override
        public Collection<T> chain() throws CertificateException {
            return ((CertificateFactory)this.supplier.getWithThrowable()).generateCertificates((InputStream)this.inputStreamSupplier.get());
        }

        @Override
        public CertPath certPath() throws CertificateException {
            return ((CertificateFactory)this.supplier.getWithThrowable()).generateCertPath((InputStream)this.inputStreamSupplier.get());
        }

        @Override
        public CRL crl() throws CertificateException, CRLException {
            return ((CertificateFactory)this.supplier.getWithThrowable()).generateCRL((InputStream)this.inputStreamSupplier.get());
        }

        @Override
        public Collection<? extends CRL> crls() throws CertificateException, CRLException {
            return ((CertificateFactory)this.supplier.getWithThrowable()).generateCRLs((InputStream)this.inputStreamSupplier.get());
        }
    }

    private static class InputStageImpl<T extends Certificate>
    implements InputStage<T> {
        private final SupplierWithThrowable<CertificateFactory, CertificateException> supplier;

        InputStageImpl(SupplierWithThrowable<CertificateFactory, CertificateException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal<T> withString(String content) {
            Objects.requireNonNull(content);
            return this.withBytes(content.getBytes(StandardCharsets.US_ASCII));
        }

        @Override
        public BuildFinal<T> withBytes(byte[] bytes) {
            Objects.requireNonNull(bytes);
            return this.withInputStream(new ByteArrayInputStream(bytes));
        }

        @Override
        public BuildFinal<T> withKeySpec(X509EncodedKeySpec keySpec) {
            return this.withBytes(keySpec.getEncoded());
        }

        @Override
        public BuildFinal<T> withByteBuffer(ByteBuffer byteBuffer) {
            Objects.requireNonNull(byteBuffer);
            return this.withBytes(byteBuffer.array());
        }

        @Override
        public BuildFinal<T> withResource(String path, ClassLoader classLoader) {
            Objects.requireNonNull(path);
            Objects.requireNonNull(classLoader);
            return new BuildFinalImpl(this.supplier, (SupplierWithThrowable<InputStream, IOException>)((SupplierWithThrowable)() -> classLoader.getResourceAsStream(path)));
        }

        @Override
        public BuildFinal<T> withPath(Path path) {
            Objects.requireNonNull(path);
            return new BuildFinalImpl(this.supplier, (SupplierWithThrowable<InputStream, IOException>)((SupplierWithThrowable)() -> Files.newInputStream(path, new OpenOption[0])));
        }

        @Override
        public BuildFinal<T> withReader(Reader reader) {
            Objects.requireNonNull(reader);
            SupplierWithThrowable inputStreamSupplier = () -> {
                int numCharsRead;
                char[] charBuffer = new char[16384];
                StringBuilder builder = new StringBuilder();
                while ((numCharsRead = reader.read(charBuffer, 0, charBuffer.length)) != -1) {
                    builder.append(charBuffer, 0, numCharsRead);
                }
                try {
                    ByteArrayInputStream byteArrayInputStream;
                    try (ByteArrayInputStream targetStream = new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));){
                        byteArrayInputStream = targetStream;
                    }
                    return byteArrayInputStream;
                }
                finally {
                    reader.close();
                }
            };
            return new BuildFinalImpl(this.supplier, (SupplierWithThrowable<InputStream, IOException>)inputStreamSupplier);
        }

        @Override
        public BuildFinal<T> withInputStream(InputStream inputStream) {
            Objects.requireNonNull(inputStream);
            return new BuildFinalImpl(this.supplier, (SupplierWithThrowable<InputStream, IOException>)((SupplierWithThrowable)() -> inputStream));
        }
    }

    private static class InstanceStageImpl
    extends InstanceGenerator<CertificateFactory, CertificateException>
    implements InstanceStage {
        private InstanceStageImpl() {
        }

        @Override
        public InputStage<X509Certificate> withX509() {
            return new InputStageImpl<X509Certificate>(this.getInstance().withAlgorithm("X.509"));
        }

        @Override
        public <T extends Certificate> InputStage<T> withAlgorithm(String algorithm) {
            return new InputStageImpl(this.getInstance().withAlgorithm(algorithm));
        }

        @Override
        public <T extends Certificate> InputStage<T> withAlgorithmAndProvider(String algorithm, String provider) {
            return new InputStageImpl(this.getInstance().withAlgorithmAndProvider(algorithm, provider));
        }
    }

    public static interface BuildFinal<T extends Certificate> {
        public T build() throws CertificateException;

        public Collection<T> chain() throws CertificateException;

        public CertPath certPath() throws CertificateException;

        public CRL crl() throws CertificateException, CRLException;

        public Collection<? extends CRL> crls() throws CertificateException, CRLException;
    }

    public static interface InputStage<T extends Certificate> {
        public BuildFinal<T> withByteBuffer(ByteBuffer var1);

        public BuildFinal<T> withInputStream(InputStream var1);

        public BuildFinal<T> withResource(String var1, ClassLoader var2);

        public BuildFinal<T> withPath(Path var1);

        public BuildFinal<T> withReader(Reader var1);

        public BuildFinal<T> withString(String var1);

        public BuildFinal<T> withBytes(byte[] var1);

        public BuildFinal<T> withKeySpec(X509EncodedKeySpec var1);
    }

    public static interface InstanceStage {
        public InputStage<X509Certificate> withX509();

        public <T extends Certificate> InputStage<T> withAlgorithm(String var1);

        public <T extends Certificate> InputStage<T> withAlgorithmAndProvider(String var1, String var2);
    }
}

