/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class AuthenticatedEncryptionBuilder {
    public static final String AES_GCM_TRANSFORMATION = "AES/GCM/NoPadding";
    public static final int TAG_LENGTH = 128;

    public static InitialStage builder() {
        return new InitialStageImpl();
    }

    private static class ModeStageImpl
    implements ModeStage {
        private final SecretKey key;
        private final byte[] iv;

        ModeStageImpl(SecretKey key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }

        @Override
        public Cipher encrypt() throws GeneralSecurityException {
            Cipher cipher = Cipher.getInstance(AuthenticatedEncryptionBuilder.AES_GCM_TRANSFORMATION);
            cipher.init(1, (Key)this.key, new GCMParameterSpec(128, this.iv));
            return cipher;
        }

        @Override
        public Cipher decrypt() throws GeneralSecurityException {
            Cipher cipher = Cipher.getInstance(AuthenticatedEncryptionBuilder.AES_GCM_TRANSFORMATION);
            cipher.init(2, (Key)this.key, new GCMParameterSpec(128, this.iv));
            return cipher;
        }
    }

    private static class IvStageImpl
    implements IvStage {
        private final SecretKey key;

        IvStageImpl(SecretKey key) {
            this.key = key;
        }

        @Override
        public ModeStage withIv(byte[] iv) {
            Objects.requireNonNull(iv, "Initialization vector must not be null!");
            if (iv.length != 12) {
                throw new IllegalStateException("Initialization vector must be 12 bytes from SecureRandom!");
            }
            return new ModeStageImpl(this.key, iv);
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public IvStage withSecretKey(SecretKey key) {
            Objects.requireNonNull(key, "SecretKey must not be null!");
            if (!key.getAlgorithm().equals("AES")) {
                throw new IllegalStateException("SecretKey algorithm must equal AES!");
            }
            return new IvStageImpl(key);
        }
    }

    public static interface ModeStage {
        public Cipher encrypt() throws GeneralSecurityException;

        public Cipher decrypt() throws GeneralSecurityException;
    }

    public static interface IvStage {
        public ModeStage withIv(byte[] var1);
    }

    public static interface InitialStage {
        public IvStage withSecretKey(SecretKey var1);
    }
}

