/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.graphviz;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/conduktor/graphviz/GraphViz;", "", "()V", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "toVisJsonForWebView", "Lkotlin/Pair;", "", "g", "Lio/conduktor/graphviz/GraphViz$VisGraph;", "Edge", "Graph", "Node", "VisColor", "VisEdge", "VisEdgeColor", "VisGraph", "VisHighlight", "VisNode", "kafka"})
public final class GraphViz {
    @NotNull
    public static final GraphViz INSTANCE = new GraphViz();
    @NotNull
    private static final ObjectMapper om = new ObjectMapper();

    private GraphViz() {
    }

    @NotNull
    public final Pair<String, String> toVisJsonForWebView(@NotNull VisGraph g) {
        return TuplesKt.to((Object)om.writeValueAsString(g.getNodes()), (Object)om.writeValueAsString(g.getEdges()));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0014B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\u001b\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0004H\u00c6\u0003J+\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/conduktor/graphviz/GraphViz$Graph;", "A", "", "nodes", "", "", "Lio/conduktor/graphviz/GraphViz$Node;", "(Ljava/util/Map;)V", "getNodes", "()Ljava/util/Map;", "addNode", "node", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "kafka"})
    public static final class Graph<A> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Node<A>> nodes;

        public Graph(@NotNull Map<String, Node<A>> nodes) {
            this.nodes = nodes;
        }

        @NotNull
        public final Map<String, Node<A>> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final Graph<A> addNode(@NotNull Node<A> node) {
            return this.copy(MapsKt.plus(this.nodes, (Pair)TuplesKt.to((Object)node.getName(), node)));
        }

        @NotNull
        public final Map<String, Node<A>> component1() {
            return this.nodes;
        }

        @NotNull
        public final Graph<A> copy(@NotNull Map<String, Node<A>> nodes) {
            return new Graph<A>(nodes);
        }

        public static /* synthetic */ Graph copy$default(Graph graph, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = graph.nodes;
            }
            return graph.copy(map);
        }

        @NotNull
        public String toString() {
            return "Graph(nodes=" + this.nodes + ")";
        }

        public int hashCode() {
            return ((Object)this.nodes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)other;
            return Intrinsics.areEqual(this.nodes, graph.nodes);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/conduktor/graphviz/GraphViz$Graph$Companion;", "", "()V", "empty", "Lio/conduktor/graphviz/GraphViz$Graph;", "A", "kafka"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <A> Graph<A> empty() {
                return new Graph(MapsKt.emptyMap());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u0015\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J8\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u00002\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lio/conduktor/graphviz/GraphViz$Node;", "A", "", "name", "", "payload", "edges", "", "Lio/conduktor/graphviz/GraphViz$Edge;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/util/List;)V", "getEdges", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getPayload", "()Ljava/lang/Object;", "Ljava/lang/Object;", "addEdge", "", "to", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/Object;Ljava/util/List;)Lio/conduktor/graphviz/GraphViz$Node;", "equals", "other", "hashCode", "", "toString", "kafka"})
    public static final class Node<A> {
        @NotNull
        private final String name;
        private final A payload;
        @NotNull
        private final List<Edge> edges;

        public Node(@NotNull String name, A payload, @NotNull List<Edge> edges) {
            this.name = name;
            this.payload = payload;
            this.edges = edges;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final A getPayload() {
            return this.payload;
        }

        @NotNull
        public final List<Edge> getEdges() {
            return this.edges;
        }

        public final boolean addEdge(@NotNull Edge to) {
            return this.edges.add(to);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final A component2() {
            return this.payload;
        }

        @NotNull
        public final List<Edge> component3() {
            return this.edges;
        }

        @NotNull
        public final Node<A> copy(@NotNull String name, A payload, @NotNull List<Edge> edges) {
            return new Node<A>(name, payload, edges);
        }

        public static /* synthetic */ Node copy$default(Node node, String string, Object object, List list, int n, Object object2) {
            if ((n & 1) != 0) {
                string = node.name;
            }
            if ((n & 2) != 0) {
                object = node.payload;
            }
            if ((n & 4) != 0) {
                list = node.edges;
            }
            return node.copy(string, object, list);
        }

        @NotNull
        public String toString() {
            return "Node(name=" + this.name + ", payload=" + this.payload + ", edges=" + this.edges + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.payload == null ? 0 : this.payload.hashCode());
            result = result * 31 + ((Object)this.edges).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)node.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.payload, node.payload)) {
                return false;
            }
            return Intrinsics.areEqual(this.edges, node.edges);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/conduktor/graphviz/GraphViz$Edge;", "", "target", "", "operation", "(Ljava/lang/String;Ljava/lang/String;)V", "getOperation", "()Ljava/lang/String;", "getTarget", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka"})
    public static final class Edge {
        @NotNull
        private final String target;
        @NotNull
        private final String operation;

        public Edge(@NotNull String target, @NotNull String operation) {
            this.target = target;
            this.operation = operation;
        }

        @NotNull
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final String getOperation() {
            return this.operation;
        }

        @NotNull
        public final String component1() {
            return this.target;
        }

        @NotNull
        public final String component2() {
            return this.operation;
        }

        @NotNull
        public final Edge copy(@NotNull String target, @NotNull String operation) {
            return new Edge(target, operation);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = edge.target;
            }
            if ((n & 2) != 0) {
                string2 = edge.operation;
            }
            return edge.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Edge(target=" + this.target + ", operation=" + this.operation + ")";
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = result * 31 + this.operation.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)edge.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.operation, (Object)edge.operation);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/conduktor/graphviz/GraphViz$VisGraph;", "", "nodes", "", "Lio/conduktor/graphviz/GraphViz$VisNode;", "edges", "Lio/conduktor/graphviz/GraphViz$VisEdge;", "(Ljava/util/List;Ljava/util/List;)V", "getEdges", "()Ljava/util/List;", "getNodes", "addEdge", "edge", "addNode", "node", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "kafka"})
    public static final class VisGraph {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<VisNode> nodes;
        @NotNull
        private final List<VisEdge> edges;
        @NotNull
        private static final VisGraph empty = new VisGraph(CollectionsKt.emptyList(), CollectionsKt.emptyList());

        public VisGraph(@NotNull List<VisNode> nodes, @NotNull List<VisEdge> edges) {
            this.nodes = nodes;
            this.edges = edges;
        }

        @NotNull
        public final List<VisNode> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final List<VisEdge> getEdges() {
            return this.edges;
        }

        @NotNull
        public final VisGraph addNode(@NotNull VisNode node) {
            return VisGraph.copy$default(this, CollectionsKt.plus((Collection)this.nodes, (Object)node), null, 2, null);
        }

        @NotNull
        public final VisGraph addEdge(@NotNull VisEdge edge) {
            return VisGraph.copy$default(this, null, CollectionsKt.plus((Collection)this.edges, (Object)edge), 1, null);
        }

        @NotNull
        public final List<VisNode> component1() {
            return this.nodes;
        }

        @NotNull
        public final List<VisEdge> component2() {
            return this.edges;
        }

        @NotNull
        public final VisGraph copy(@NotNull List<VisNode> nodes, @NotNull List<VisEdge> edges) {
            return new VisGraph(nodes, edges);
        }

        public static /* synthetic */ VisGraph copy$default(VisGraph visGraph, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = visGraph.nodes;
            }
            if ((n & 2) != 0) {
                list2 = visGraph.edges;
            }
            return visGraph.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "VisGraph(nodes=" + this.nodes + ", edges=" + this.edges + ")";
        }

        public int hashCode() {
            int result = ((Object)this.nodes).hashCode();
            result = result * 31 + ((Object)this.edges).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisGraph)) {
                return false;
            }
            VisGraph visGraph = (VisGraph)other;
            if (!Intrinsics.areEqual(this.nodes, visGraph.nodes)) {
                return false;
            }
            return Intrinsics.areEqual(this.edges, visGraph.edges);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/conduktor/graphviz/GraphViz$VisGraph$Companion;", "", "()V", "empty", "Lio/conduktor/graphviz/GraphViz$VisGraph;", "getEmpty", "()Lio/conduktor/graphviz/GraphViz$VisGraph;", "kafka"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final VisGraph getEmpty() {
                return empty;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lio/conduktor/graphviz/GraphViz$VisNode;", "", "id", "", "label", "shape", "color", "Lio/conduktor/graphviz/GraphViz$VisColor;", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/conduktor/graphviz/GraphViz$VisColor;Ljava/lang/String;)V", "getColor", "()Lio/conduktor/graphviz/GraphViz$VisColor;", "getId", "()Ljava/lang/String;", "getLabel", "getShape", "getType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka"})
    public static final class VisNode {
        @NotNull
        private final String id;
        @NotNull
        private final String label;
        @NotNull
        private final String shape;
        @NotNull
        private final VisColor color;
        @NotNull
        private final String type;

        public VisNode(@NotNull String id, @NotNull String label, @NotNull String shape, @NotNull VisColor color, @NotNull String type) {
            this.id = id;
            this.label = label;
            this.shape = shape;
            this.color = color;
            this.type = type;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String getShape() {
            return this.shape;
        }

        @NotNull
        public final VisColor getColor() {
            return this.color;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        @NotNull
        public final String component3() {
            return this.shape;
        }

        @NotNull
        public final VisColor component4() {
            return this.color;
        }

        @NotNull
        public final String component5() {
            return this.type;
        }

        @NotNull
        public final VisNode copy(@NotNull String id, @NotNull String label, @NotNull String shape, @NotNull VisColor color, @NotNull String type) {
            return new VisNode(id, label, shape, color, type);
        }

        public static /* synthetic */ VisNode copy$default(VisNode visNode, String string, String string2, String string3, VisColor visColor, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = visNode.id;
            }
            if ((n & 2) != 0) {
                string2 = visNode.label;
            }
            if ((n & 4) != 0) {
                string3 = visNode.shape;
            }
            if ((n & 8) != 0) {
                visColor = visNode.color;
            }
            if ((n & 0x10) != 0) {
                string4 = visNode.type;
            }
            return visNode.copy(string, string2, string3, visColor, string4);
        }

        @NotNull
        public String toString() {
            return "VisNode(id=" + this.id + ", label=" + this.label + ", shape=" + this.shape + ", color=" + this.color + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.label.hashCode();
            result = result * 31 + this.shape.hashCode();
            result = result * 31 + this.color.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisNode)) {
                return false;
            }
            VisNode visNode = (VisNode)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)visNode.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)visNode.label)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shape, (Object)visNode.shape)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.color, (Object)visNode.color)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)visNode.type);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/conduktor/graphviz/GraphViz$VisColor;", "", "background", "", "highlight", "Lio/conduktor/graphviz/GraphViz$VisHighlight;", "(Ljava/lang/String;Lio/conduktor/graphviz/GraphViz$VisHighlight;)V", "getBackground", "()Ljava/lang/String;", "getHighlight", "()Lio/conduktor/graphviz/GraphViz$VisHighlight;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka"})
    public static final class VisColor {
        @NotNull
        private final String background;
        @NotNull
        private final VisHighlight highlight;

        public VisColor(@NotNull String background, @NotNull VisHighlight highlight) {
            this.background = background;
            this.highlight = highlight;
        }

        @NotNull
        public final String getBackground() {
            return this.background;
        }

        @NotNull
        public final VisHighlight getHighlight() {
            return this.highlight;
        }

        @NotNull
        public final String component1() {
            return this.background;
        }

        @NotNull
        public final VisHighlight component2() {
            return this.highlight;
        }

        @NotNull
        public final VisColor copy(@NotNull String background, @NotNull VisHighlight highlight) {
            return new VisColor(background, highlight);
        }

        public static /* synthetic */ VisColor copy$default(VisColor visColor, String string, VisHighlight visHighlight, int n, Object object) {
            if ((n & 1) != 0) {
                string = visColor.background;
            }
            if ((n & 2) != 0) {
                visHighlight = visColor.highlight;
            }
            return visColor.copy(string, visHighlight);
        }

        @NotNull
        public String toString() {
            return "VisColor(background=" + this.background + ", highlight=" + this.highlight + ")";
        }

        public int hashCode() {
            int result = this.background.hashCode();
            result = result * 31 + this.highlight.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisColor)) {
                return false;
            }
            VisColor visColor = (VisColor)other;
            if (!Intrinsics.areEqual((Object)this.background, (Object)visColor.background)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.highlight, (Object)visColor.highlight);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/conduktor/graphviz/GraphViz$VisHighlight;", "", "background", "", "(Ljava/lang/String;)V", "getBackground", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka"})
    public static final class VisHighlight {
        @NotNull
        private final String background;

        public VisHighlight(@NotNull String background) {
            this.background = background;
        }

        @NotNull
        public final String getBackground() {
            return this.background;
        }

        @NotNull
        public final String component1() {
            return this.background;
        }

        @NotNull
        public final VisHighlight copy(@NotNull String background) {
            return new VisHighlight(background);
        }

        public static /* synthetic */ VisHighlight copy$default(VisHighlight visHighlight, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = visHighlight.background;
            }
            return visHighlight.copy(string);
        }

        @NotNull
        public String toString() {
            return "VisHighlight(background=" + this.background + ")";
        }

        public int hashCode() {
            return this.background.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisHighlight)) {
                return false;
            }
            VisHighlight visHighlight = (VisHighlight)other;
            return Intrinsics.areEqual((Object)this.background, (Object)visHighlight.background);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006!"}, d2={"Lio/conduktor/graphviz/GraphViz$VisEdge;", "", "from", "", "to", "color", "Lio/conduktor/graphviz/GraphViz$VisEdgeColor;", "arrows", "dashes", "", "title", "(Ljava/lang/String;Ljava/lang/String;Lio/conduktor/graphviz/GraphViz$VisEdgeColor;Ljava/lang/String;ZLjava/lang/String;)V", "getArrows", "()Ljava/lang/String;", "getColor", "()Lio/conduktor/graphviz/GraphViz$VisEdgeColor;", "getDashes", "()Z", "getFrom", "getTitle", "getTo", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "kafka"})
    public static final class VisEdge {
        @NotNull
        private final String from;
        @NotNull
        private final String to;
        @NotNull
        private final VisEdgeColor color;
        @NotNull
        private final String arrows;
        private final boolean dashes;
        @NotNull
        private final String title;

        public VisEdge(@NotNull String from, @NotNull String to, @NotNull VisEdgeColor color, @NotNull String arrows, boolean dashes, @NotNull String title) {
            this.from = from;
            this.to = to;
            this.color = color;
            this.arrows = arrows;
            this.dashes = dashes;
            this.title = title;
        }

        @NotNull
        public final String getFrom() {
            return this.from;
        }

        @NotNull
        public final String getTo() {
            return this.to;
        }

        @NotNull
        public final VisEdgeColor getColor() {
            return this.color;
        }

        @NotNull
        public final String getArrows() {
            return this.arrows;
        }

        public final boolean getDashes() {
            return this.dashes;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String component1() {
            return this.from;
        }

        @NotNull
        public final String component2() {
            return this.to;
        }

        @NotNull
        public final VisEdgeColor component3() {
            return this.color;
        }

        @NotNull
        public final String component4() {
            return this.arrows;
        }

        public final boolean component5() {
            return this.dashes;
        }

        @NotNull
        public final String component6() {
            return this.title;
        }

        @NotNull
        public final VisEdge copy(@NotNull String from, @NotNull String to, @NotNull VisEdgeColor color, @NotNull String arrows, boolean dashes, @NotNull String title) {
            return new VisEdge(from, to, color, arrows, dashes, title);
        }

        public static /* synthetic */ VisEdge copy$default(VisEdge visEdge, String string, String string2, VisEdgeColor visEdgeColor, String string3, boolean bl, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = visEdge.from;
            }
            if ((n & 2) != 0) {
                string2 = visEdge.to;
            }
            if ((n & 4) != 0) {
                visEdgeColor = visEdge.color;
            }
            if ((n & 8) != 0) {
                string3 = visEdge.arrows;
            }
            if ((n & 0x10) != 0) {
                bl = visEdge.dashes;
            }
            if ((n & 0x20) != 0) {
                string4 = visEdge.title;
            }
            return visEdge.copy(string, string2, visEdgeColor, string3, bl, string4);
        }

        @NotNull
        public String toString() {
            return "VisEdge(from=" + this.from + ", to=" + this.to + ", color=" + this.color + ", arrows=" + this.arrows + ", dashes=" + this.dashes + ", title=" + this.title + ")";
        }

        public int hashCode() {
            int result = this.from.hashCode();
            result = result * 31 + this.to.hashCode();
            result = result * 31 + this.color.hashCode();
            result = result * 31 + this.arrows.hashCode();
            int n = this.dashes ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.title.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisEdge)) {
                return false;
            }
            VisEdge visEdge = (VisEdge)other;
            if (!Intrinsics.areEqual((Object)this.from, (Object)visEdge.from)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.to, (Object)visEdge.to)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.color, (Object)visEdge.color)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.arrows, (Object)visEdge.arrows)) {
                return false;
            }
            if (this.dashes != visEdge.dashes) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)visEdge.title);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/conduktor/graphviz/GraphViz$VisEdgeColor;", "", "color", "", "opacity", "", "(Ljava/lang/String;D)V", "getColor", "()Ljava/lang/String;", "getOpacity", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kafka"})
    public static final class VisEdgeColor {
        @NotNull
        private final String color;
        private final double opacity;

        public VisEdgeColor(@NotNull String color, double opacity) {
            this.color = color;
            this.opacity = opacity;
        }

        public /* synthetic */ VisEdgeColor(String string, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d = 1.0;
            }
            this(string, d);
        }

        @NotNull
        public final String getColor() {
            return this.color;
        }

        public final double getOpacity() {
            return this.opacity;
        }

        @NotNull
        public final String component1() {
            return this.color;
        }

        public final double component2() {
            return this.opacity;
        }

        @NotNull
        public final VisEdgeColor copy(@NotNull String color, double opacity) {
            return new VisEdgeColor(color, opacity);
        }

        public static /* synthetic */ VisEdgeColor copy$default(VisEdgeColor visEdgeColor, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = visEdgeColor.color;
            }
            if ((n & 2) != 0) {
                d = visEdgeColor.opacity;
            }
            return visEdgeColor.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "VisEdgeColor(color=" + this.color + ", opacity=" + this.opacity + ")";
        }

        public int hashCode() {
            int result = this.color.hashCode();
            result = result * 31 + Double.hashCode(this.opacity);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisEdgeColor)) {
                return false;
            }
            VisEdgeColor visEdgeColor = (VisEdgeColor)other;
            if (!Intrinsics.areEqual((Object)this.color, (Object)visEdgeColor.color)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.opacity, (Object)visEdgeColor.opacity);
        }
    }
}

