/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart.domain;

import io.conduktor.jumpstart.agent.JumpstartAgent;
import io.conduktor.jumpstart.domain.AgentProperties;
import io.conduktor.jumpstart.domain.Component;
import io.conduktor.jumpstart.domain.Kafka$;
import io.conduktor.jumpstart.domain.SchemaRegistry$;
import io.conduktor.jumpstart.domain.Zookeeper$;
import io.conduktor.primitives.types.Port;
import io.conduktor.primitives.types.Port$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import zio.nio.file.Path;
import zio.nio.file.Path$;

public final class AgentProperties$
implements Serializable {
    public static final AgentProperties$ MODULE$ = new AgentProperties$();
    private static final Regex agentRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*jumpstartagent_.*.jar=port=(\\d+),component=(kafka|zookeeper|registry).*"));
    private static final Path AgentJarPath = Path$.MODULE$.apply(JumpstartAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI()).normalize();

    public Option<Path> $lessinit$greater$default$3() {
        return this.AgentJarPath().parent();
    }

    private Regex agentRegex() {
        return agentRegex;
    }

    public Option<AgentProperties> parse(String cmd) {
        None$ none$;
        Option option;
        String string = cmd;
        if (string != null && !(option = this.agentRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String port = (String)((LinearSeqOps)option.get()).apply(0);
            String component = (String)((LinearSeqOps)option.get()).apply(1);
            none$ = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(port)).zip(this.componentFromString(component)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int p = tuple2._1$mcI$sp();
                Component c = (Component)tuple2._2();
                AgentProperties agentProperties = new AgentProperties((Port)Port$.MODULE$.from(p).toOption().get(), c, MODULE$.apply$default$3());
                return agentProperties;
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String componentToString(Component component) {
        String string;
        Component component2 = component;
        if (Zookeeper$.MODULE$.equals(component2)) {
            string = "zookeeper";
        } else if (Kafka$.MODULE$.equals(component2)) {
            string = "kafka";
        } else if (SchemaRegistry$.MODULE$.equals(component2)) {
            string = "registry";
        } else {
            throw new MatchError((Object)component2);
        }
        return string;
    }

    public Option<Component> componentFromString(String component) {
        None$ none$;
        block5: {
            String string = component;
            switch (string == null ? 0 : string.hashCode()) {
                case -690212803: {
                    if (!"registry".equals(string)) break;
                    none$ = new Some((Object)SchemaRegistry$.MODULE$);
                    break block5;
                }
                case 101807910: {
                    if (!"kafka".equals(string)) break;
                    none$ = new Some((Object)Kafka$.MODULE$);
                    break block5;
                }
                case 1600681804: {
                    if (!"zookeeper".equals(string)) break;
                    none$ = new Some((Object)Zookeeper$.MODULE$);
                    break block5;
                }
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Path AgentJarPath() {
        return AgentJarPath;
    }

    public AgentProperties apply(Port port, Component component, Option<Path> basePath) {
        return new AgentProperties(port, component, basePath);
    }

    public Option<Path> apply$default$3() {
        return this.AgentJarPath().parent();
    }

    public Option<Tuple3<Port, Component, Option<Path>>> unapply(AgentProperties x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.port(), (Object)x$0.component(), x$0.basePath()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AgentProperties$.class);
    }

    private AgentProperties$() {
    }
}

