/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.views.clients;

import io.conduktor.views.clients.consumer.ConsumedRecord;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u000e\u001a\u00020\r2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014J.\u0010\u0015\u001a\u00020\r2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H$J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H$J\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017J\u0006\u0010\u001d\u001a\u00020\u0003R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/conduktor/views/clients/RecordBuffer;", "", "viewSize", "", "(I)V", "buffer", "", "Lio/conduktor/views/clients/consumer/ConsumedRecord;", "getBuffer", "()Ljava/util/Collection;", "oldestTimestamp", "", "viewIsFull", "", "add", "message", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "", "Lio/conduktor/kafka/admin/Message;", "record", "Lkotlin/Lazy;", "addToBuffer", "keepNOrdered", "", "allResults", "", "mergeBufferWith", "inView", "mergeWithViewAndClear", "size", "desktop"})
public abstract class RecordBuffer {
    private final int viewSize;
    private long oldestTimestamp;
    private boolean viewIsFull;

    public RecordBuffer(int viewSize) {
        this.viewSize = viewSize;
        this.oldestTimestamp = Long.MAX_VALUE;
    }

    @NotNull
    protected abstract Collection<ConsumedRecord> getBuffer();

    protected abstract boolean addToBuffer(@NotNull ConsumerRecord<byte[], byte[]> var1, @NotNull Lazy<ConsumedRecord> var2);

    @NotNull
    protected abstract Collection<ConsumedRecord> mergeBufferWith(@NotNull List<ConsumedRecord> var1);

    /*
     * WARNING - void declaration
     */
    public final boolean add(@NotNull ConsumerRecord<byte[], byte[]> message2, @NotNull Lazy<ConsumedRecord> record) {
        boolean bl;
        if (!this.viewIsFull && this.getBuffer().size() < this.viewSize) {
            void var3_3;
            boolean isAdded = this.addToBuffer(message2, record);
            if (isAdded && message2.timestamp() < this.oldestTimestamp) {
                this.oldestTimestamp = message2.timestamp();
            }
            bl = var3_3;
        } else {
            bl = message2.timestamp() > this.oldestTimestamp ? this.addToBuffer(message2, record) : false;
        }
        return bl;
    }

    public final int size() {
        return this.getBuffer().size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConsumedRecord> mergeWithViewAndClear(@NotNull List<ConsumedRecord> inView) {
        List<ConsumedRecord> list2;
        if (this.getBuffer().isEmpty()) {
            list2 = inView;
        } else {
            void var2_2;
            List<ConsumedRecord> res2 = this.keepNOrdered(this.mergeBufferWith(inView));
            this.viewIsFull = res2.size() >= this.viewSize;
            if (!((Collection)res2).isEmpty()) {
                this.oldestTimestamp = ((ConsumedRecord)CollectionsKt.last(res2)).getTimestamp();
            }
            this.getBuffer().clear();
            list2 = var2_2;
        }
        return list2;
    }

    private final List<ConsumedRecord> keepNOrdered(Collection<ConsumedRecord> allResults) {
        return CollectionsKt.sortedWith((Iterable)allResults, ConsumedRecord.Companion.getTimestampComparator().reversed()).subList(0, Math.min(this.viewSize, allResults.size()));
    }
}

