/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.utils;

import io.conduktor.JavaFxExtensionsKt;
import io.conduktor.auth.user.ConduktorUser;
import io.conduktor.auth.user.SubscriptionFallbackReason;
import io.conduktor.controllers.ClusterPermissionsChecker;
import io.conduktor.utils.SubscriptionUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/conduktor/utils/SubscriptionUtils;", "", "()V", "alertNotAuthorized", "", "user", "Lio/conduktor/auth/user/ConduktorUser;", "permissionMissing", "Lio/conduktor/controllers/ClusterPermissionsChecker$FeatureException;", "desktop"})
public final class SubscriptionUtils {
    @NotNull
    public static final SubscriptionUtils INSTANCE = new SubscriptionUtils();

    private SubscriptionUtils() {
    }

    public final void alertNotAuthorized(@NotNull ConduktorUser user2, @NotNull ClusterPermissionsChecker.FeatureException permissionMissing) {
        if (permissionMissing instanceof ClusterPermissionsChecker.FeatureRestrictedException) {
            String string = permissionMissing.getMessage();
            if (string == null) {
                string = "This feature has been restricted by your administrator.";
            }
            JavaFxExtensionsKt.safeWarning("Restricted", string, (Function0<Unit>)((Function0)alertNotAuthorized.1.INSTANCE));
        } else if (user2.subscriptionExpired()) {
            JavaFxExtensionsKt.safeWarning("Please Upgrade", "Your " + (user2.getWasTrial() ? "trial" : "subscription") + " or user authentication has expired. Try to logout/login. If the issue persists, you need to upgrade your account. Thank you.", (Function0<Unit>)((Function0)alertNotAuthorized.2.INSTANCE));
        } else {
            SubscriptionFallbackReason subscriptionFallbackReason = user2.getFallback();
            switch (subscriptionFallbackReason == null ? -1 : WhenMappings.$EnumSwitchMapping$0[subscriptionFallbackReason.ordinal()]) {
                case 1: {
                    JavaFxExtensionsKt.safeWarning("Too many trials", "In order to continue to benefit from all the features of Conduktor, you need to upgrade your account. Thank you.", (Function0<Unit>)((Function0)alertNotAuthorized.3.INSTANCE));
                    break;
                }
                case 2: {
                    JavaFxExtensionsKt.safeWarning("Too many activations", "You are logged in on too many machines. A license is personal and cannot be shared.\n\nDue to this behavior, you can only connect to single-broker clusters on this machine.\n\nYou may contact our support to unlock the situation.", (Function0<Unit>)((Function0)alertNotAuthorized.4.INSTANCE));
                    break;
                }
                default: {
                    String string = permissionMissing.getMessage();
                    if (string == null) {
                        string = "Not available in your plan, please upgrade to get this feature.";
                    }
                    JavaFxExtensionsKt.safeWarning("Please Upgrade", string, (Function0<Unit>)((Function0)alertNotAuthorized.5.INSTANCE));
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SubscriptionFallbackReason.values().length];
            nArray[SubscriptionFallbackReason.MultipleTrials.ordinal()] = 1;
            nArray[SubscriptionFallbackReason.TooManyActivations.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

