/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.exporter.ObjectJsonifier;
import io.conduktor.models.Node;
import io.conduktor.models.settings.ConduktorConfig;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lio/conduktor/exporter/NodeJsonifier;", "Lio/conduktor/exporter/ObjectJsonifier;", "Lio/conduktor/models/Node;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "withMetrics", "", "nodes", "", "(Lio/conduktor/models/settings/ConduktorConfig;ZLjava/util/List;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "getNodes", "()Ljava/util/List;", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getWithMetrics", "()Z", "toJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "a", "desktop"})
final class NodeJsonifier
implements ObjectJsonifier<Node> {
    @NotNull
    private final ConduktorConfig config;
    private final boolean withMetrics;
    @NotNull
    private final List<Node> nodes;
    @NotNull
    private final ObjectMapper om;

    public NodeJsonifier(@NotNull ConduktorConfig config, boolean withMetrics, @NotNull List<Node> nodes) {
        this.config = config;
        this.withMetrics = withMetrics;
        this.nodes = nodes;
        this.om = new ObjectMapper();
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    public final boolean getWithMetrics() {
        return this.withMetrics;
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    @NotNull
    public JsonNode toJson(@NotNull Node a) {
        ObjectNode node = this.om.createObjectNode();
        if (this.config.getShowBrokerIdColumn()) {
            node.put("id", String.valueOf(a.getId()));
        }
        if (this.config.getShowBrokerRackColumn()) {
            node.put("rack", a.getRack());
        }
        node.put("listener", a.getHostAndPort());
        node.put("partitions", a.getPartitionCount());
        node.put("skew", a.skew(this.nodes));
        node.put("leaders", a.getPartitionLeaderCount());
        node.put("leaders_skew", a.leaderSkew(this.nodes));
        if (this.withMetrics) {
            node.put("bytes_in", ((Number)a.getMetrics().getBytesInProperty().getValue()).doubleValue());
            node.put("bytes_out", ((Number)a.getMetrics().getBytesOutProperty().getValue()).doubleValue());
        }
        if (this.config.getShowBrokerSizeColumn()) {
            node.put("size", a.getLogDirSize());
        }
        return (JsonNode)node;
    }
}

