/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird.immutable;

import com.twitter.algebird.immutable.BitSet;
import scala.Function1;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;

public final class BitSet$ {
    public static final BitSet$ MODULE$ = new BitSet$();
    private static final BitSet Empty;
    private static final Ordering<BitSet> orderingForBitSet;

    static {
        int newEmpty_offset = 0;
        Empty = new BitSet.Leaf(newEmpty_offset, new long[32]);
        orderingForBitSet = new Ordering<BitSet>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<BitSet> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public boolean isReverseOf(Ordering<?> other) {
                return Ordering.isReverseOf$((Ordering)this, other);
            }

            public <U> Ordering<U> on(Function1<U, BitSet> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering<BitSet> orElse(Ordering<BitSet> other) {
                return Ordering.orElse$((Ordering)this, other);
            }

            public <S> Ordering<BitSet> orElseBy(Function1<BitSet, S> f, Ordering<S> ord) {
                return Ordering.orElseBy$((Ordering)this, f, ord);
            }

            public Ordering.OrderingOps mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(BitSet x, BitSet y) {
                Iterator<Object> itx = x.iterator();
                Iterator<Object> ity = y.iterator();
                while (itx.hasNext() && ity.hasNext()) {
                    int c = Integer.compare(BoxesRunTime.unboxToInt((Object)itx.next()), BoxesRunTime.unboxToInt((Object)ity.next()));
                    if (c == 0) continue;
                    return c;
                }
                if (itx.hasNext()) {
                    return 1;
                }
                if (ity.hasNext()) {
                    return -1;
                }
                return 0;
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }

    public final BitSet empty() {
        return this.Empty();
    }

    public final BitSet Empty() {
        return Empty;
    }

    public BitSet newEmpty(int offset) {
        return new BitSet.Leaf(offset, new long[32]);
    }

    /*
     * WARNING - void declaration
     */
    public final BitSet apply(Seq<Object> xs) {
        void var2_4;
        BitSet.Leaf leaf;
        if (xs.isEmpty()) {
            return this.Empty();
        }
        int newEmpty_offset = 0;
        BitSet.Leaf leaf2 = leaf = new BitSet.Leaf(newEmpty_offset, new long[32]);
        leaf = null;
        BitSet bs = leaf2;
        Iterator iter = xs.iterator();
        while (iter.hasNext()) {
            bs = ((BitSet)bs).mutableAdd(BoxesRunTime.unboxToInt((Object)iter.next()));
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public final BitSet apply(int[] xs) {
        void var2_4;
        BitSet.Leaf leaf;
        if (xs.length == 0) {
            return this.Empty();
        }
        int newEmpty_offset = 0;
        BitSet.Leaf leaf2 = leaf = new BitSet.Leaf(newEmpty_offset, new long[32]);
        leaf = null;
        BitSet bs = leaf2;
        for (int idx = 0; idx < xs.length; ++idx) {
            bs = ((BitSet)bs).mutableAdd(xs[idx]);
        }
        return var2_4;
    }

    public int index(int n, int o, int h) {
        return n - o >>> h * 5 + 6;
    }

    public BitSet parentFor(BitSet b) {
        int h = b.height() + 1;
        int o = b.offset() & -(1 << h * 5 + 11);
        BitSet[] cs = new BitSet[32];
        int i = b.offset() - o >>> h * 5 + 6;
        cs[i] = b;
        return new BitSet.Branch(o, h, cs);
    }

    public BitSet.Branch com$twitter$algebird$immutable$BitSet$$adoptedPlus(BitSet b, int n) {
        BitSet.Branch parent;
        while (true) {
            int h = b.height() + 1;
            int o = b.offset() & -(1 << h * 5 + 11);
            BitSet[] cs = new BitSet[32];
            parent = new BitSet.Branch(o, h, cs);
            int i = b.offset() - o >>> h * 5 + 6;
            cs[i] = b;
            int n2 = n - o >>> h * 5 + 6;
            if (n2 >= 0 && 32 > n2) break;
            b = parent;
        }
        parent.$plus$eq(n);
        return parent;
    }

    public BitSet com$twitter$algebird$immutable$BitSet$$adoptedUnion(BitSet b, BitSet rhs) {
        BitSet.Branch parent;
        while (true) {
            int h = b.height() + 1;
            int o = b.offset() & -(1 << h * 5 + 11);
            BitSet[] cs = new BitSet[32];
            parent = new BitSet.Branch(o, h, cs);
            int i = b.offset() - o >>> h * 5 + 6;
            cs[i] = b;
            int n = rhs.offset() - o >>> h * 5 + 6;
            if (n >= 0 && 32 > n && rhs.height() <= parent.height()) break;
            b = parent;
        }
        return parent.$bar(rhs);
    }

    public Ordering<BitSet> orderingForBitSet() {
        return orderingForBitSet;
    }

    private BitSet$() {
    }
}

