/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.MinHasher;
import com.twitter.algebird.MinHasher$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Y3Aa\u0003\u0007\u0001'!Ia\u0004\u0001B\u0001B\u0003%\u0001d\b\u0005\nA\u0001\u0011\t\u0011)A\u00051\u0005BQA\t\u0001\u0005\u0002\rBQA\t\u0001\u0005\n\u001dBQA\t\u0001\u0005\u00025BQ!\u000e\u0001\u0005BYBQa\u000e\u0001\u0005BYBQ\u0001\u000f\u0001\u0005ReBQ\u0001\u000f\u0001\u0005R\u0015CQa\u0014\u0001\u0005\u0002A\u00131\"T5o\u0011\u0006\u001c\b.\u001a:4e)\u0011QBD\u0001\tC2<WMY5sI*\u0011q\u0002E\u0001\bi^LG\u000f^3s\u0015\u0005\t\u0012aA2p[\u000e\u00011C\u0001\u0001\u0015!\r)b\u0003G\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\n\u001b&t\u0007*Y:iKJ\u0004\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u00111!\u00138u\u0003%qW/\u001c%bg\",7/\u0003\u0002\u001f-\u0005Aa.^7CC:$7/\u0003\u0002!-\u00051A(\u001b8jiz\"2\u0001J\u0013'!\t)\u0002\u0001C\u0003\u001f\u0007\u0001\u0007\u0001\u0004C\u0003!\u0007\u0001\u0007\u0001\u0004\u0006\u0002%Q!)\u0011\u0006\u0002a\u0001U\u0005\t\u0001\u0010\u0005\u0003\u001aWaA\u0012B\u0001\u0017\u001b\u0005\u0019!V\u000f\u001d7feQ\u0019AEL\u001a\t\u000b=*\u0001\u0019\u0001\u0019\u0002\u001fQ\f'oZ3u)\"\u0014Xm\u001d5pY\u0012\u0004\"!G\u0019\n\u0005IR\"A\u0002#pk\ndW\rC\u00035\u000b\u0001\u0007\u0001$\u0001\u0005nCb\u0014\u0015\u0010^3t\u0003!A\u0017m\u001d5TSj,W#\u0001\r\u0002\u000f5\f\u0007\u0010S1tQ\u0006Q!-^5mI\u0006\u0013(/Y=\u0015\u0005i\u0002\u0005cA\r<{%\u0011AH\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00033yJ!a\u0010\u000e\u0003\t\tKH/\u001a\u0005\u0007\u0003\"!\t\u0019\u0001\"\u0002\u0005\u0019t\u0007cA\rD1%\u0011AI\u0007\u0002\ty\tLh.Y7f}Q\u0019aiS'\u0015\u0005i:\u0005\"B!\n\u0001\u0004A\u0005#B\rJ1aA\u0012B\u0001&\u001b\u0005%1UO\\2uS>t'\u0007C\u0003M\u0013\u0001\u0007!(\u0001\u0003mK\u001a$\b\"\u0002(\n\u0001\u0004Q\u0014!\u0002:jO\"$\u0018aC1qaJ|\u0007pQ8v]R$\"!\u0015+\u0011\u0005e\u0011\u0016BA*\u001b\u0005\u0011auN\\4\t\u000bUS\u0001\u0019\u0001\u001e\u0002\u0007MLw\r")
public class MinHasher32
extends MinHasher<Object> {
    @Override
    public int hashSize() {
        return 4;
    }

    @Override
    public int maxHash() {
        return Integer.MAX_VALUE;
    }

    @Override
    public byte[] buildArray(Function0<Object> fn) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.numBytes());
        IntBuffer writeBuffer = byteBuffer.asIntBuffer();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), super.numHashes()).foreach((Function1 & Serializable)x$8 -> writeBuffer.put(fn.apply$mcI$sp()));
        return byteBuffer.array();
    }

    @Override
    public byte[] buildArray(byte[] left, byte[] right, Function2<Object, Object, Object> fn) {
        IntBuffer leftBuffer = ByteBuffer.wrap(left).asIntBuffer();
        IntBuffer rightBuffer = ByteBuffer.wrap(right).asIntBuffer();
        return this.buildArray((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> fn.apply$mcIII$sp(leftBuffer.get(), rightBuffer.get()));
    }

    public long approxCount(byte[] sig) {
        IntBuffer buffer = ByteBuffer.wrap(sig).asIntBuffer();
        long mean = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), super.numHashes()).map((Function1)(JFunction1.mcJI.sp & Serializable)x$9 -> buffer.get()).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)super.numHashes();
        return 0x100000000L / (mean + 0x80000000L);
    }

    public MinHasher32(int numHashes, int numBands) {
        super(numHashes, numBands, Numeric.IntIsIntegral$.MODULE$);
    }

    private MinHasher32(Tuple2<Object, Object> x) {
        this(x._1$mcI$sp(), x._2$mcI$sp());
    }

    public MinHasher32(double targetThreshold, int maxBytes) {
        this(MinHasher$.MODULE$.pickHashesAndBands(targetThreshold, maxBytes / 4));
    }
}

