/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.Optional;
import java.util.function.Supplier;
import org.slieb.throwables.FunctionWithThrowable;

public class SuppressedException
extends RuntimeException {
    protected SuppressedException(Throwable cause) {
        super(cause);
    }

    public static <T, E extends Throwable> T suppress(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <E extends Throwable> void suppress(Runnable runnable) {
        runnable.run();
    }

    public static SuppressedException wrapException(Throwable cause) {
        return new SuppressedException(cause);
    }

    public static <T, E extends Throwable> T unwrapSuppressedException(Supplier<T> supplier, Class<E> exceptionClass) throws E {
        try {
            return supplier.get();
        }
        catch (SuppressedException e) {
            throw (Throwable)SuppressedException.unwrapExceptionCause(e, exceptionClass).orElseThrow(() -> e);
        }
    }

    public static <T> T unwrapSuppressedException(Supplier<T> supplier) throws Throwable {
        try {
            return supplier.get();
        }
        catch (SuppressedException e) {
            throw e.getCause();
        }
    }

    public static <E extends Throwable> void unwrapSuppressedException(Runnable runnable, Class<E> exception) throws E {
        try {
            runnable.run();
        }
        catch (SuppressedException e) {
            throw (Throwable)SuppressedException.unwrapExceptionCause(e, exception).orElseThrow(() -> e);
        }
    }

    public static void unwrapSuppressedException(Runnable runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (SuppressedException e) {
            throw e.getCause();
        }
    }

    public static <E extends Throwable> Optional<E> unwrapExceptionCause(SuppressedException suppressed, Class<E> exceptionClass) {
        return Optional.of(suppressed).map(Throwable::getCause).flatMap(FunctionWithThrowable.castFunctionWithThrowable(exceptionClass::cast).thatReturnsOptional());
    }

    static <E extends Throwable> void throwUnsafelyAsUnchecked(Throwable exception) throws E {
        throw exception;
    }
}

