/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongBinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface LongBinaryOperatorWithThrowable<E extends Throwable>
extends LongBinaryOperator {
    public static <E extends Throwable> LongBinaryOperatorWithThrowable<E> castLongBinaryOperatorWithThrowable(LongBinaryOperatorWithThrowable<E> longbinaryoperatorwiththrowable) {
        return longbinaryoperatorwiththrowable;
    }

    public static <E extends Throwable> LongBinaryOperator aLongBinaryOperatorThatUnsafelyThrowsUnchecked(LongBinaryOperatorWithThrowable<E> longbinaryoperatorwiththrowable) throws E {
        return longbinaryoperatorwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> LongBinaryOperatorWithThrowable<E> asLongBinaryOperatorWithThrowable(LongBinaryOperator longbinaryoperator) {
        return longbinaryoperator::applyAsLong;
    }

    @Override
    default public long applyAsLong(long v1, long v2) {
        try {
            return this.applyAsLongWithThrowable(v1, v2);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public long applyAsLongWithThrowable(long var1, long var3) throws E;

    default public LongBinaryOperator thatReturnsOnCatch(long defaultReturnValue) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public LongBinaryOperator thatUnsafelyThrowsUnchecked() throws E {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return 0L;
            }
        };
    }

    default public LongBinaryOperatorWithThrowable<E> withLogging(Logger logger, String message) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                logger.error(message, new Object[]{v1, v2, throwable});
                throw throwable;
            }
        };
    }

    default public LongBinaryOperatorWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in LongBinaryOperatorWithThrowable with the arguments [{}, {}]");
    }

    default public LongBinaryOperatorWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public LongBinaryOperatorWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public LongBinaryOperatorWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return (v1, v2) -> {
            try {
                return this.applyAsLongWithThrowable(v1, v2);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1, v2});
                throw throwable;
            }
        };
    }
}

