/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface IntConsumerWithThrowable<E extends Throwable>
extends IntConsumer {
    public static <E extends Throwable> IntConsumerWithThrowable<E> castIntConsumerWithThrowable(IntConsumerWithThrowable<E> intconsumerwiththrowable) {
        return intconsumerwiththrowable;
    }

    public static <E extends Throwable> IntConsumer aIntConsumerThatUnsafelyThrowsUnchecked(IntConsumerWithThrowable<E> intconsumerwiththrowable) throws E {
        return intconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> IntConsumerWithThrowable<E> asIntConsumerWithThrowable(IntConsumer intconsumer) {
        return intconsumer::accept;
    }

    @Override
    default public void accept(int v1) {
        try {
            this.acceptWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(int var1) throws E;

    default public IntConsumer thatThrowsNothing() {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public IntConsumer thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public IntConsumerWithThrowable<E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public IntConsumerWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in IntConsumerWithThrowable with the argument [{}]");
    }

    default public IntConsumerWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public IntConsumerWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public IntConsumerWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

