/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface DoubleConsumerWithThrowable<E extends Throwable>
extends DoubleConsumer {
    public static <E extends Throwable> DoubleConsumerWithThrowable<E> castDoubleConsumerWithThrowable(DoubleConsumerWithThrowable<E> doubleconsumerwiththrowable) {
        return doubleconsumerwiththrowable;
    }

    public static <E extends Throwable> DoubleConsumer aDoubleConsumerThatUnsafelyThrowsUnchecked(DoubleConsumerWithThrowable<E> doubleconsumerwiththrowable) throws E {
        return doubleconsumerwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> DoubleConsumerWithThrowable<E> asDoubleConsumerWithThrowable(DoubleConsumer doubleconsumer) {
        return doubleconsumer::accept;
    }

    @Override
    default public void accept(double v1) {
        try {
            this.acceptWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void acceptWithThrowable(double var1) throws E;

    default public DoubleConsumer thatThrowsNothing() {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public DoubleConsumer thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public DoubleConsumerWithThrowable<E> withLogging(Logger logger, String message) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                logger.error(message, (Object)v1, (Object)throwable);
                throw throwable;
            }
        };
    }

    default public DoubleConsumerWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in DoubleConsumerWithThrowable with the argument [{}]");
    }

    default public DoubleConsumerWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public DoubleConsumerWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public DoubleConsumerWithThrowable<E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                this.acceptWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

