/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary;

import crosby.binary.Osmformat;
import crosby.binary.StringTable;
import crosby.binary.file.BlockOutputStream;
import crosby.binary.file.FileBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BinarySerializer {
    protected final int MIN_DENSE = 10;
    protected int batch_limit = 4000;
    protected int granularity = 100;
    protected int date_granularity = 1000;
    protected boolean omit_metadata = false;
    protected int batch_size = 0;
    protected int total_entities = 0;
    private StringTable stringtable = new StringTable();
    protected List<PrimGroupWriterInterface> groups = new ArrayList<PrimGroupWriterInterface>();
    protected BlockOutputStream output;
    long debug_bytes = 0L;

    public void configGranularity(int n) {
        this.granularity = n;
    }

    public void configOmit(boolean bl) {
        this.omit_metadata = bl;
    }

    public void configBatchLimit(int n) {
        this.batch_limit = n;
    }

    public BinarySerializer(BlockOutputStream blockOutputStream) {
        this.output = blockOutputStream;
    }

    public StringTable getStringTable() {
        return this.stringtable;
    }

    public void flush() throws IOException {
        this.processBatch();
        this.output.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    public void processBatch() {
        if (this.groups.size() == 0) {
            return;
        }
        Osmformat.PrimitiveBlock.Builder builder = Osmformat.PrimitiveBlock.newBuilder();
        this.stringtable.clear();
        for (PrimGroupWriterInterface primGroupWriterInterface : this.groups) {
            primGroupWriterInterface.addStringsToStringtable();
        }
        this.stringtable.finish();
        for (PrimGroupWriterInterface primGroupWriterInterface : this.groups) {
            Osmformat.PrimitiveGroup primitiveGroup = primGroupWriterInterface.serialize();
            if (primitiveGroup == null) continue;
            builder.addPrimitivegroup(primitiveGroup);
        }
        builder.setStringtable(this.stringtable.serialize());
        builder.setGranularity(this.granularity);
        builder.setDateGranularity(this.date_granularity);
        Osmformat.PrimitiveBlock primitiveBlock = builder.build();
        this.debug_bytes += (long)primitiveBlock.getSerializedSize();
        try {
            this.output.write(FileBlock.newInstance("OSMData", primitiveBlock.toByteString(), null));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error(iOException);
        }
        finally {
            this.batch_size = 0;
            this.groups.clear();
        }
    }

    public long mapRawDegrees(double d) {
        return (long)(d / 1.0E-9);
    }

    public int mapDegrees(double d) {
        return (int)(d / 1.0E-7 / (double)(this.granularity / 100));
    }

    protected static interface PrimGroupWriterInterface {
        public void addStringsToStringtable();

        public Osmformat.PrimitiveGroup serialize();
    }
}

