/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.tools;

public class BitReader {
    private final byte[] buf;
    private final int offset;
    private int index;
    private int bitPosition;

    public BitReader(byte[] buf) {
        this(buf, 0);
    }

    public BitReader(byte[] buf, int start) {
        this.buf = buf;
        this.offset = start;
        this.reset();
    }

    public void reset() {
        this.index = this.offset;
        this.bitPosition = 0;
    }

    public void position(int bitPos) {
        this.index = this.offset + bitPos / 8;
        this.bitPosition = bitPos & 7;
    }

    public void skip(int bits) {
        this.position(this.getBitPosition() + bits);
    }

    public boolean get1() {
        int off = this.bitPosition++;
        byte b = this.buf[this.index];
        if (this.bitPosition == 8) {
            this.bitPosition = 0;
            ++this.index;
        }
        return (b >> off & 1) == 1;
    }

    public int get(int n) {
        if (n == 1) {
            return this.get1() ? 1 : 0;
        }
        int nb = n + this.bitPosition;
        int shift = 0;
        long work = 0L;
        do {
            work |= ((long)this.buf[this.index++] & 0xFFL) << shift;
            shift += 8;
        } while ((nb -= 8) > 0);
        if (nb < 0) {
            --this.index;
        }
        int res = (int)(work >>> this.bitPosition);
        int n2 = this.bitPosition = nb < 0 ? nb + 8 : 0;
        if (n < 32) {
            res &= (1 << n) - 1;
        }
        return res;
    }

    public int sget(int n) {
        int top;
        int res = this.get(n);
        if (n < 32 && (res & (top = 1 << n - 1)) != 0) {
            int mask = top - 1;
            res = ~mask | res;
        }
        return res;
    }

    public int sget2(int n) {
        assert (n > 1);
        int top = 1 << n - 1;
        int mask = top - 1;
        int base = 0;
        long res = this.get(n);
        while (res == (long)top) {
            base += mask;
            res = this.get(n);
        }
        res = (res & (long)top) == 0L ? (res += (long)base) : (res | (long)(~mask)) - (long)base;
        return (int)res;
    }

    public int getBitPosition() {
        return (this.index - this.offset) * 8 + this.bitPosition;
    }
}

