/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import java.util.regex.Pattern;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.MapDetails;
import uk.me.parabola.splitter.RoundingUtils;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;

public class DensityMap {
    private static final int SEA_NODE_FACTOR = 2;
    private final int width;
    private final int height;
    private final int shift;
    private int[][] nodeMap;
    private Area bounds;
    private long totalNodeCount;

    public DensityMap(Area area, int resolution) {
        assert (resolution >= 1 && resolution <= 24);
        this.shift = 24 - resolution;
        this.bounds = RoundingUtils.round(area, resolution);
        this.height = this.bounds.getHeight() >> this.shift;
        this.width = this.bounds.getWidth() >> this.shift;
        this.nodeMap = new int[this.width][];
    }

    public java.awt.geom.Area rasterPolygon(java.awt.geom.Area polygonArea) {
        List<List<Point>> shapes;
        if (polygonArea == null) {
            return null;
        }
        java.awt.geom.Area simpleArea = new java.awt.geom.Area();
        if (!polygonArea.intersects(Utils.area2Rectangle(this.bounds, 0))) {
            return simpleArea;
        }
        int gridElemWidth = this.bounds.getWidth() / this.width;
        int gridElemHeight = this.bounds.getHeight() / this.height;
        Rectangle polygonBbox = polygonArea.getBounds();
        int minLat = Math.max((int)polygonBbox.getMinY(), this.bounds.getMinLat());
        int maxLat = Math.min((int)polygonBbox.getMaxY(), this.bounds.getMaxLat());
        int minY = this.latToY(minLat);
        int maxY = this.latToY(maxLat);
        assert (minY >= 0 && minY <= this.height);
        assert (maxY >= 0 && maxY <= this.height);
        for (int x = 0; x < this.width; ++x) {
            int lon = this.xToLon(x);
            if ((double)(lon + gridElemWidth) < polygonBbox.getMinX() || (double)lon > polygonBbox.getMaxX() || !polygonArea.intersects(lon, polygonBbox.getMinY(), gridElemWidth, polygonBbox.getHeight())) continue;
            int firstY = -1;
            for (int y = 0; y < this.height; ++y) {
                int lat = this.yToLat(y);
                if (y < minY || y > maxY || !polygonArea.intersects(lon, lat, gridElemWidth, gridElemHeight)) {
                    if (firstY < 0) continue;
                    simpleArea.add(new java.awt.geom.Area(new Rectangle(x, firstY, 1, y - firstY)));
                    firstY = -1;
                    continue;
                }
                if (firstY >= 0) continue;
                firstY = y;
            }
            if (firstY < 0) continue;
            simpleArea.add(new java.awt.geom.Area(new Rectangle(x, firstY, 1, this.height - firstY)));
        }
        if (!simpleArea.isSingular() && (shapes = Utils.areaToShapes(simpleArea)).removeIf(s -> !Utils.clockwise(s))) {
            System.out.println("Warning: Rastered polygon area contains holes, polygon is probably concave, trying to fix this");
            simpleArea.reset();
            shapes.forEach(s -> simpleArea.add(Utils.shapeToArea(s)));
        }
        return simpleArea;
    }

    public int getShift() {
        return this.shift;
    }

    public Area getBounds() {
        return this.bounds;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int addNode(int lat, int lon) {
        int y;
        if (!this.bounds.contains(lat, lon)) {
            return 0;
        }
        ++this.totalNodeCount;
        int x = this.lonToX(lon);
        if (x == this.width) {
            --x;
        }
        if ((y = this.latToY(lat)) == this.height) {
            --y;
        }
        if (this.nodeMap[x] == null) {
            this.nodeMap[x] = new int[this.height];
        }
        int[] nArray = this.nodeMap[x];
        int n = y;
        int n2 = nArray[n] + 1;
        nArray[n] = n2;
        return n2;
    }

    public long getNodeCount() {
        return this.totalNodeCount;
    }

    public int getNodeCount(int x, int y) {
        return this.nodeMap[x] != null ? this.nodeMap[x][y] : 0;
    }

    public DensityMap subset(Area subsetBounds) {
        int minLat = Math.max(this.bounds.getMinLat(), subsetBounds.getMinLat());
        int minLon = Math.max(this.bounds.getMinLong(), subsetBounds.getMinLong());
        int maxLat = Math.min(this.bounds.getMaxLat(), subsetBounds.getMaxLat());
        int maxLon = Math.min(this.bounds.getMaxLong(), subsetBounds.getMaxLong());
        if (minLat > maxLat || minLon > maxLon) {
            return new DensityMap(Area.EMPTY, 24 - this.shift);
        }
        Area subset = new Area(minLat, minLon, maxLat, maxLon);
        if (subset.getWidth() == 0 || subset.getHeight() == 0) {
            return new DensityMap(Area.EMPTY, 24 - this.shift);
        }
        DensityMap result = new DensityMap(subset, 24 - this.shift);
        int startX = this.lonToX(subset.getMinLong());
        int startY = this.latToY(subset.getMinLat());
        int maxX = subset.getWidth() >> this.shift;
        int maxY = subset.getHeight() >> this.shift;
        for (int x = 0; x < maxX; ++x) {
            if (startY == 0 && maxY == this.height) {
                result.nodeMap[x] = this.nodeMap[startX + x];
            } else if (this.nodeMap[startX + x] != null) {
                result.nodeMap[x] = new int[maxY];
                try {
                    System.arraycopy(this.nodeMap[startX + x], startY, result.nodeMap[x], 0, maxY);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("subSet() died at " + startX + ',' + startY + "  " + maxX + ',' + maxY + "  " + x);
                }
            }
            for (int y = 0; y < maxY; ++y) {
                if (result.nodeMap[x] == null) continue;
                result.totalNodeCount += (long)result.nodeMap[x][y];
            }
        }
        return result;
    }

    private int yToLat(int y) {
        return (y << this.shift) + this.bounds.getMinLat();
    }

    private int xToLon(int x) {
        return (x << this.shift) + this.bounds.getMinLong();
    }

    private int latToY(int lat) {
        return lat - this.bounds.getMinLat() >>> this.shift;
    }

    private int lonToX(int lon) {
        return lon - this.bounds.getMinLong() >>> this.shift;
    }

    public void saveMap(String fileName, Area detailBounds, Area collectorBounds) {
        try (FileWriter f = new FileWriter(new File(fileName));){
            f.write(detailBounds.getMinLat() + "," + detailBounds.getMinLong() + "," + detailBounds.getMaxLat() + "," + detailBounds.getMaxLong() + '\n');
            if (collectorBounds != null) {
                f.write(collectorBounds.getMinLat() + "," + collectorBounds.getMinLong() + "," + collectorBounds.getMaxLat() + "," + collectorBounds.getMaxLong() + '\n');
            } else {
                f.write("no_bounds_in_input\n");
            }
            for (int x = 0; x < this.width; ++x) {
                if (this.nodeMap[x] == null) continue;
                for (int y = 0; y < this.height; ++y) {
                    if (this.nodeMap[x][y] == 0) continue;
                    f.write(x + "," + y + "," + this.nodeMap[x][y] + '\n');
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Warning: Could not write " + fileName + ", processing continues.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Area readMap(String fileName, MapDetails details) {
        File mapFile = new File(fileName);
        Area collectorBounds = null;
        if (!mapFile.exists()) {
            System.out.println("Error: map file doesn't exist: " + mapFile);
            return null;
        }
        try (FileInputStream fileStream = new FileInputStream(mapFile);
             LineNumberReader problemReader = new LineNumberReader(new InputStreamReader(fileStream));){
            String[] items;
            Pattern csvSplitter = Pattern.compile(Pattern.quote(","));
            String inLine = problemReader.readLine();
            if (inLine != null) {
                items = csvSplitter.split(inLine);
                if (items.length != 4) {
                    DensityMap.reportErrorLine(problemReader.getLineNumber(), inLine);
                    Area area = null;
                    return area;
                }
                details.addToBounds(Integer.parseInt(items[0]), Integer.parseInt(items[1]));
                details.addToBounds(Integer.parseInt(items[2]), Integer.parseInt(items[3]));
            }
            if ((inLine = problemReader.readLine()) != null && !"no_bounds_in_input".equals(inLine)) {
                items = csvSplitter.split(inLine);
                if (items.length != 4) {
                    DensityMap.reportErrorLine(problemReader.getLineNumber(), inLine);
                    Area area = null;
                    return area;
                }
                collectorBounds = new Area(Integer.parseInt(items[0]), Integer.parseInt(items[1]), Integer.parseInt(items[2]), Integer.parseInt(items[3]));
            }
            while ((inLine = problemReader.readLine()) != null) {
                items = csvSplitter.split(inLine);
                if (items.length != 3) {
                    DensityMap.reportErrorLine(problemReader.getLineNumber(), inLine);
                    Area area = null;
                    return area;
                }
                try {
                    int x = Integer.parseInt(items[0]);
                    int y = Integer.parseInt(items[1]);
                    int sum = Integer.parseInt(items[2]);
                    if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
                        System.out.println("Error: Invalid data in map file, line number " + problemReader.getLineNumber() + ": " + inLine);
                        continue;
                    }
                    if (this.nodeMap[x] == null) {
                        this.nodeMap[x] = new int[this.height];
                    }
                    this.nodeMap[x][y] = sum;
                    this.totalNodeCount += (long)sum;
                }
                catch (NumberFormatException exp) {
                    System.out.println("Error: Invalid number format in density file " + fileName + ", line " + problemReader.getLineNumber() + ": " + inLine);
                    System.out.println(exp);
                    throw new SplitFailedException("Error: Cannot read density file " + mapFile);
                }
            }
            return collectorBounds;
        }
        catch (IOException exp) {
            throw new SplitFailedException("Error: Cannot read density file " + mapFile);
        }
    }

    private static void reportErrorLine(int lineNo, String inLine) {
        System.out.println("Error: Invalid format in map file, line number " + lineNo + ": " + inLine);
    }

    public Area getArea(int x, int y, int width2, int height2) {
        assert (x >= 0);
        assert (y >= 0);
        assert (width2 > 0);
        assert (height2 > 0);
        return new Area(this.yToLat(y), this.xToLon(x), this.yToLat(y + height2), this.xToLon(x + width2));
    }

    public void mergeSeaData(DensityMap seaData, Area area, boolean trim) {
        if (this.shift != seaData.shift || !Utils.area2Rectangle(this.bounds, 0).equals(Utils.area2Rectangle(seaData.getBounds(), 0))) {
            throw new SplitFailedException("cannot merge density maps");
        }
        if (trim && this.totalNodeCount == 0L) {
            return;
        }
        int minX = this.lonToX(area.getMinLong());
        int maxX = this.lonToX(area.getMaxLong());
        int minY = this.latToY(area.getMinLat());
        int maxY = this.latToY(area.getMaxLat());
        if (maxX >= this.width) {
            maxX = this.width - 1;
        }
        if (maxY >= this.height) {
            maxY = this.height - 1;
        }
        if (trim) {
            while (minX < this.width && this.nodeMap[minX] == null) {
                ++minX;
            }
            while (maxX > 0 && this.nodeMap[maxX] == null) {
                --maxX;
            }
            while (minY < this.height && this.rowAllZero(minY, minX, maxX)) {
                ++minY;
            }
            while (maxY > 0 && this.rowAllZero(maxY, minX, maxX)) {
                --maxY;
            }
        }
        long addedSeaNodes = 0L;
        for (int x = minX; x <= maxX; ++x) {
            int[] seaCol = seaData.nodeMap[x];
            if (seaCol == null) continue;
            int[] col = this.nodeMap[x];
            if (col == null) {
                col = new int[this.height + 1];
            }
            for (int y = minY; y <= maxY; ++y) {
                int seaCount;
                if (col[y] != 0) continue;
                col[y] = seaCount = seaCol[y] * 2;
                this.totalNodeCount += (long)seaCount;
                addedSeaNodes += (long)seaCount;
            }
        }
        System.out.println("Added " + addedSeaNodes + " nodes from precompiled sea data.");
    }

    boolean rowAllZero(int row, int minX, int maxX) {
        for (int x = minX; x <= maxX; ++x) {
            if (this.nodeMap[x] == null || this.nodeMap[x][row] <= 0) continue;
            return false;
        }
        return true;
    }
}

