/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.kml;

import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.xml.parser.AbstractXppParser;

public class KmlParser
extends AbstractXppParser {
    private State state = State.None;
    private int currentId;
    private int[] currentCoords = new int[10];
    private List<Area> areas = new ArrayList<Area>();

    public List<Area> getAreas() {
        return this.areas;
    }

    @Override
    protected boolean startElement(String name) throws XmlPullParserException {
        switch (this.state) {
            case None: {
                if (!name.equals("Placemark")) break;
                this.state = State.Placemark;
                break;
            }
            case Placemark: {
                if (name.equals("name")) {
                    this.state = State.Name;
                    break;
                }
                if (!name.equals("Polygon")) break;
                this.state = State.Polygon;
                break;
            }
            case Polygon: {
                if (!name.equals("outerBoundaryIs")) break;
                this.state = State.OuterBoundaryIs;
                break;
            }
            case OuterBoundaryIs: {
                if (!name.equals("LinearRing")) break;
                this.state = State.LinearRing;
                break;
            }
            case LinearRing: {
                if (!name.equals("coordinates")) break;
                this.state = State.Coordinates;
                break;
            }
        }
        return false;
    }

    @Override
    protected void text() throws XmlPullParserException {
        if (this.state == State.Name) {
            String idStr = this.getTextContent();
            try {
                this.currentId = Integer.valueOf(idStr);
            }
            catch (NumberFormatException e) {
                throw this.createException("Unexpected area name encountered. Expected a valid number, found \"" + idStr + '\"');
            }
        } else if (this.state == State.Coordinates) {
            String coordText = this.getTextContent();
            String[] coordPairs = coordText.trim().split("\\s+");
            if (coordPairs.length != 5) {
                throw this.createException("Unexpected number of coordinates. Expected 5, found " + coordPairs.length + " in \"" + coordText + '\"');
            }
            for (int i = 0; i < 5; ++i) {
                String[] coordStrs = coordPairs[i].split(",");
                if (coordStrs.length != 2) {
                    throw this.createException("Unexpected coordinate pair encountered in \"" + coordPairs[i] + "\". Expected 2 numbers, found " + coordStrs.length);
                }
                for (int j = 0; j < 2; ++j) {
                    try {
                        Double val = Double.valueOf(coordStrs[j]);
                        this.currentCoords[i * 2 + j] = Utils.toMapUnit(val);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw this.createException("Unexpected coordinate encountered. \"" + coordStrs[j] + "\" is not a valid number");
                    }
                }
            }
        }
    }

    @Override
    protected void endElement(String name) throws XmlPullParserException {
        if (this.state == State.Name) {
            this.state = State.Placemark;
        } else if (this.state == State.Coordinates) {
            this.state = State.LinearRing;
        } else if (name.equals("Placemark")) {
            int minLat = this.currentCoords[1];
            int minLon = this.currentCoords[0];
            int maxLat = this.currentCoords[5];
            int maxLon = this.currentCoords[4];
            Area a = new Area(minLat, minLon, maxLat, maxLon);
            if (!a.verify()) {
                throw new IllegalArgumentException("invalid area " + this.currentId + " in split file: " + a);
            }
            a.setMapId(this.currentId);
            this.areas.add(a);
            this.state = State.None;
        }
    }

    private static enum State {
        None,
        Placemark,
        Name,
        Polygon,
        OuterBoundaryIs,
        LinearRing,
        Coordinates;

    }
}

