/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.args;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import uk.me.parabola.splitter.args.Param;
import uk.me.parabola.splitter.args.ThreadCount;

public class ParamConverter {
    private final Map<Class<?>, Converter<?>> converterMap = new HashMap(10);
    private final Map<Class<?>, Object> primitiveDefaults;

    public ParamConverter() {
        this.converterMap.put(String.class, new Converter<String>(){

            @Override
            String convert(String value) {
                return value;
            }
        });
        this.converterMap.put(Boolean.class, new Converter<Boolean>(){

            @Override
            Boolean convert(String value) {
                return Boolean.valueOf(value);
            }
        });
        this.converterMap.put(Integer.class, new IntegerConverter());
        this.converterMap.put(Long.class, new LongConverter());
        this.converterMap.put(File.class, new Converter<File>(){

            @Override
            File convert(String value) {
                return new File(value);
            }
        });
        this.converterMap.put(ThreadCount.class, new ThreadCountConverter());
        this.primitiveDefaults = new HashMap(10);
        this.primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        this.primitiveDefaults.put(Byte.TYPE, (byte)0);
        this.primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
        this.primitiveDefaults.put(Short.TYPE, (short)0);
        this.primitiveDefaults.put(Integer.TYPE, 0);
        this.primitiveDefaults.put(Long.TYPE, 0L);
        this.primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        this.primitiveDefaults.put(Double.TYPE, 0.0);
    }

    public Object getPrimitiveDefault(Class<?> returnType) {
        return this.primitiveDefaults.get(returnType);
    }

    public Object convert(Param param, String value) {
        if (value == null) {
            return param.getDefaultValue();
        }
        Converter<?> converter = this.converterMap.get(param.getReturnType());
        if (converter == null) {
            throw new UnsupportedOperationException("Unable to convert parameters of type " + param.getReturnType() + ". Parameter " + param.getName() + " (value=" + value + ") could not be converted.");
        }
        return converter.convert(value);
    }

    private static class ThreadCountConverter
    extends Converter<ThreadCount> {
        private ThreadCountConverter() {
        }

        @Override
        ThreadCount convert(String value) {
            int cpuCores = Runtime.getRuntime().availableProcessors();
            if ("auto".equals(value)) {
                return new ThreadCount(cpuCores, true);
            }
            int threads = 0;
            boolean valid = false;
            try {
                threads = Integer.valueOf(value);
                if (threads >= 1) {
                    valid = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!valid) {
                throw new IllegalArgumentException('\'' + value + "' should be a number >= 1, or 'auto' to use all available CPU cores.");
            }
            return new ThreadCount(threads, false);
        }
    }

    private static class LongConverter
    extends Converter<Long> {
        private LongConverter() {
        }

        @Override
        Long convert(String value) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException('\'' + value + "' is not a valid number.");
            }
        }
    }

    private static class IntegerConverter
    extends Converter<Integer> {
        private IntegerConverter() {
        }

        @Override
        Integer convert(String value) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException('\'' + value + "' is not a valid number.");
            }
        }
    }

    private static abstract class Converter<T> {
        private Converter() {
        }

        abstract T convert(String var1);
    }
}

