/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Way;

public final class ElementQuadTreeNode {
    private static final Logger log = Logger.getLogger(ElementQuadTreeNode.class);
    private static final int MAX_POINTS = 1000;
    private List<BoxedElement> elementList;
    private final Area bounds;
    private final Rectangle boundsRect;
    private Boolean empty;
    private ElementQuadTreeNode[] children;

    public boolean isEmpty() {
        if (this.empty == null) {
            if (this.elementList != null && !this.elementList.isEmpty()) {
                this.empty = false;
            } else {
                this.empty = true;
                for (ElementQuadTreeNode child : this.children) {
                    if (child.isEmpty()) continue;
                    this.empty = false;
                    break;
                }
            }
        }
        return this.empty;
    }

    private long getSize() {
        int items = 0;
        for (BoxedElement bel : this.elementList) {
            items += bel.getSize();
        }
        if (this.children != null) {
            for (ElementQuadTreeNode child : this.children) {
                items = (int)((long)items + child.getSize());
            }
        }
        return items;
    }

    public int getDepth() {
        if (this.children == null) {
            return 1;
        }
        int maxDepth = 0;
        for (ElementQuadTreeNode node : this.children) {
            maxDepth = Math.max(node.getDepth(), maxDepth);
        }
        return maxDepth + 1;
    }

    private ElementQuadTreeNode(Area bounds, List<BoxedElement> elements) {
        this.bounds = bounds;
        this.boundsRect = new Rectangle(bounds.getMinLong(), bounds.getMinLat(), bounds.getWidth(), bounds.getHeight());
        this.children = null;
        this.elementList = elements;
        this.empty = this.elementList.isEmpty();
        this.checkSplit();
    }

    public ElementQuadTreeNode(Area bounds, Collection<Element> elements) {
        this.bounds = bounds;
        this.boundsRect = new Rectangle(bounds.getMinLong(), bounds.getMinLat(), bounds.getWidth(), bounds.getHeight());
        this.children = null;
        this.elementList = new ArrayList<BoxedElement>();
        for (Element el : elements) {
            BoxedElement bel = new BoxedElement(el);
            this.elementList.add(bel);
        }
        this.empty = this.elementList.isEmpty();
        this.checkSplit();
    }

    public Area getBounds() {
        return this.bounds;
    }

    public Rectangle getBoundsAsRectangle() {
        return this.boundsRect;
    }

    private void checkSplit() {
        if (this.elementList != null && this.elementList.size() > 1 && this.getSize() > 1000L) {
            this.split();
        }
    }

    public void get(Area bbox, Set<Element> resultSet) {
        if (this.isEmpty() || !bbox.intersects(this.bounds)) {
            return;
        }
        if (this.elementList != null) {
            for (BoxedElement bel : this.elementList) {
                if (!bbox.intersects(bel.getBBox())) continue;
                resultSet.add(bel.el);
            }
        }
        if (this.children != null) {
            for (ElementQuadTreeNode child : this.children) {
                child.get(bbox, resultSet);
            }
        }
    }

    private void split() {
        if (this.bounds.getHeight() <= 5 || this.bounds.getWidth() <= 5) {
            log.error((Object)("Do not split more due to too small bounds: " + this.bounds));
            return;
        }
        int halfLat = (this.bounds.getMinLat() + this.bounds.getMaxLat()) / 2;
        int halfLong = (this.bounds.getMinLong() + this.bounds.getMaxLong()) / 2;
        Area[] childBounds = new Area[]{new Area(this.bounds.getMinLat(), this.bounds.getMinLong(), halfLat, halfLong), new Area(halfLat, this.bounds.getMinLong(), this.bounds.getMaxLat(), halfLong), new Area(this.bounds.getMinLat(), halfLong, halfLat, this.bounds.getMaxLong()), new Area(halfLat, halfLong, this.bounds.getMaxLat(), this.bounds.getMaxLong())};
        ArrayList childElems = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            childElems.add(new ArrayList());
        }
        boolean modified = false;
        Iterator<BoxedElement> iter = this.elementList.iterator();
        while (iter.hasNext()) {
            BoxedElement bel = iter.next();
            int count = 0;
            int lastIndex = -1;
            for (int i = 0; i < 4; ++i) {
                if (!childBounds[i].intersects(bel.getBBox())) continue;
                ++count;
                lastIndex = i;
                if (childBounds[i].insideBoundary(bel.getBBox())) break;
            }
            if (count != true) continue;
            ((List)childElems.get(lastIndex)).add(bel);
            iter.remove();
            modified = true;
        }
        if (modified) {
            this.children = new ElementQuadTreeNode[4];
            for (int i = 0; i < 4; ++i) {
                this.children[i] = new ElementQuadTreeNode(childBounds[i], (List)childElems.get(i));
            }
        }
        if (this.elementList.isEmpty()) {
            this.elementList = null;
        }
    }

    public void clear() {
        this.children = null;
        this.elementList = null;
    }

    private class BoxedElement {
        private Area bbox;
        private final Element el;

        Area getBBox() {
            if (this.el instanceof Way) {
                if (this.bbox == null) {
                    this.bbox = Area.getBBox(((Way)this.el).getPoints());
                }
                return this.bbox;
            }
            return Area.getBBox(Arrays.asList(((Node)this.el).getLocation()));
        }

        BoxedElement(Element el) {
            this.el = el;
        }

        int getSize() {
            if (this.el instanceof Way) {
                return ((Way)this.el).getPoints().size();
            }
            return 1;
        }
    }
}

