/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;

public class PredictFilterPoints {
    public static int predictedMaxNumPoints(List<Coord> points, int resolution, boolean checkPreserved) {
        int mask;
        int half;
        int shift = 24 - resolution;
        if (shift == 0) {
            half = 0;
            mask = -1;
        } else {
            half = 1 << shift - 1;
            mask = ~((1 << shift) - 1);
        }
        int numPoints = 0;
        int lastLat = 0;
        int lastLon = 0;
        for (Coord p : points) {
            int lat = p.getLatitude() + half & mask;
            int lon = p.getLongitude() + half & mask;
            if (numPoints == 0) {
                numPoints = 1;
            } else if (lat != lastLat || lon != lastLon || checkPreserved && p.isNumberNode()) {
                ++numPoints;
            }
            lastLat = lat;
            lastLon = lon;
        }
        return numPoints;
    }
}

