/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mps;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.mps.MapBlock;
import uk.me.parabola.imgfmt.mps.ProductBlock;

public class MpsFileReader
implements Closeable {
    private final List<MapBlock> maps = new ArrayList<MapBlock>();
    private final List<ProductBlock> products = new ArrayList<ProductBlock>();
    private final ImgChannel chan;
    private final ImgFileReader reader;
    private final CharacterDecoder decoder;
    private final int codePage;

    public MpsFileReader(ImgChannel chan, int codePage) {
        this.chan = chan;
        this.reader = new BufferedImgFileReader(chan);
        this.codePage = codePage;
        CodeFunctions funcs = CodeFunctions.createEncoderForLBL(0, codePage);
        this.decoder = funcs.getDecoder();
        this.readBlocks();
    }

    private void readBlocks() {
        byte type;
        block4: while ((type = this.reader.get()) > 0) {
            int len = this.reader.get2u();
            switch (type) {
                case 76: {
                    this.readMapBlock();
                    continue block4;
                }
                case 70: {
                    this.readProductBlock();
                    continue block4;
                }
            }
            this.reader.get(len);
        }
    }

    private void readMapBlock() {
        MapBlock block = new MapBlock(this.codePage);
        int val = this.reader.get4();
        block.setIds(val >>> 16, val & 0xFFFF);
        block.setMapNumber(this.reader.get4());
        byte[] zString = this.reader.getZString();
        block.setSeriesName(this.decodeToString(zString));
        block.setMapDescription(this.decodeToString(this.reader.getZString()));
        block.setAreaName(this.decodeToString(this.reader.getZString()));
        block.setHexNumber(this.reader.get4());
        this.reader.get4();
        this.maps.add(block);
    }

    private void readProductBlock() {
        ProductBlock block = new ProductBlock(this.codePage);
        block.setProductId(this.reader.get2u());
        block.setFamilyId(this.reader.get2u());
        block.setDescription(this.decodeToString(this.reader.getZString()));
        this.products.add(block);
    }

    private String decodeToString(byte[] zString) {
        this.decoder.reset();
        for (byte b : zString) {
            this.decoder.addByte(b);
        }
        return this.decoder.getText().getText();
    }

    public List<MapBlock> getMaps() {
        return this.maps;
    }

    public List<ProductBlock> getProducts() {
        return this.products;
    }

    @Override
    public void close() throws IOException {
        this.chan.close();
    }
}

