/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.Java2DConverter;

public class ResidentialHook
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(ResidentialHook.class);
    private BoundaryQuadTree residentialBoundaries;
    private ElementSaver saver;
    private NameFinder nameFinder;
    private static final short TK_LANDUSE = TagDict.getInstance().xlate("landuse");
    private static final short TK_NAME = TagDict.getInstance().xlate("name");
    private static final short TKM_STYLEFILTER = TagDict.getInstance().xlate("mkgmap:stylefilter");
    private static final short TKM_OTHER = TagDict.getInstance().xlate("mkgmap:other");

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        if (!props.getProperty("residential-hook", true)) {
            return false;
        }
        this.nameFinder = new NameFinder(props);
        this.saver = saver;
        return true;
    }

    @Override
    public void end() {
        log.info((Object)"Starting with residential hook");
        long t1 = System.currentTimeMillis();
        this.residentialBoundaries = this.buildResidentialBoundaryTree();
        long t2 = System.currentTimeMillis();
        log.info("Creating residential bounds took", t2 - t1, "ms");
        for (Node node : this.saver.getNodes().values()) {
            if (node.getTagCount() <= 0 || !this.saver.getBoundingBox().contains(node.getLocation())) continue;
            this.processElem(node);
        }
        for (Way way : this.saver.getWays().values()) {
            if (way.getTagCount() <= 0) continue;
            this.processElem(way);
        }
        long t3 = System.currentTimeMillis();
        log.info("Using residential bounds took", t3 - t2, "ms");
        this.residentialBoundaries = null;
    }

    private BoundaryQuadTree buildResidentialBoundaryTree() {
        ArrayList<Boundary> residentials = new ArrayList<Boundary>();
        Tags tags = new Tags();
        for (Way way : this.saver.getWays().values()) {
            if (!way.hasIdenticalEndPoints() || !"residential".equals(way.getTag(TK_LANDUSE)) || "polyline".equals(way.getTag(TKM_STYLEFILTER))) continue;
            String name = this.nameFinder.getName(way);
            tags.put(TK_NAME, name == null ? "yes" : name);
            Boundary b = new Boundary(Java2DConverter.createArea(way.getPoints()), tags, "w" + way.getId());
            residentials.add(b);
        }
        return new BoundaryQuadTree(this.saver.getBoundingBox(), residentials, null);
    }

    private void processElem(Element elem) {
        Tags residentialTags = null;
        if (elem instanceof Node) {
            Node node = (Node)elem;
            residentialTags = this.residentialBoundaries.get(node.getLocation());
        } else if (elem instanceof Way) {
            Coord loc;
            Way way = (Way)elem;
            int middle = way.getPoints().size() / 2;
            Coord coord = loc = way.hasIdenticalEndPoints() ? way.getCofG() : way.getPoints().get(middle);
            if (!"residential".equals(way.getTag(TK_LANDUSE))) {
                residentialTags = this.residentialBoundaries.get(loc);
            }
        }
        if (residentialTags != null) {
            elem.addTag("mkgmap:residential", residentialTags.get(TKM_OTHER));
        }
    }

    @Override
    public Set<String> getUsedTags() {
        return new HashSet<String>(Arrays.asList("landuse", "name"));
    }
}

