/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.osmstyle.function.AreaSizeFunction;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class POIGeneratorHook
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(POIGeneratorHook.class);
    private List<Map.Entry<String, String>> poiPlacementTags;
    private IdentityHashMap<Coord, Node> coordToNodeMap;
    private ElementSaver saver;
    private boolean poisToAreas = false;
    private boolean poisToLines = false;
    private boolean poisToLinesStart = false;
    private boolean poisToLinesEnd = false;
    private boolean poisToLinesMid = false;
    private boolean poisToLinesOther = false;
    private NameFinder nameFinder;
    private AreaSizeFunction areaSizeFunction = new AreaSizeFunction();
    private Set<String> usedTagsPOI;
    public static final short TKM_AREA2POI = TagDict.getInstance().xlate("mkgmap:area2poi");
    public static final short TKM_LINE2POI = TagDict.getInstance().xlate("mkgmap:line2poi");
    public static final short TKM_LINE2POI_TYPE = TagDict.getInstance().xlate("mkgmap:line2poitype");
    public static final short TKM_WAY_LENGTH = TagDict.getInstance().xlate("mkgmap:way-length");
    public static final String FROM_NODE_PREFIX = "mkgmap:from-node:";

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.poisToAreas = props.containsKey("add-pois-to-areas");
        this.poisToLines = props.containsKey("add-pois-to-lines");
        if (this.poisToLines) {
            String[] opts = new String[]{"all"};
            if (!props.getProperty("add-pois-to-lines").isEmpty()) {
                opts = props.getProperty("add-pois-to-lines").split(",");
            }
            block14: for (String opt : opts) {
                switch (opt.trim()) {
                    case "start": {
                        this.poisToLinesStart = true;
                        continue block14;
                    }
                    case "end": {
                        this.poisToLinesEnd = true;
                        continue block14;
                    }
                    case "mid": {
                        this.poisToLinesMid = true;
                        continue block14;
                    }
                    case "other": {
                        this.poisToLinesOther = true;
                        continue block14;
                    }
                    case "all": {
                        this.poisToLinesStart = true;
                        this.poisToLinesEnd = true;
                        this.poisToLinesMid = true;
                        this.poisToLinesOther = true;
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalied argument '" + opt + "' for add-pois-to-lines");
                    }
                }
            }
        }
        if (!this.poisToAreas && !this.poisToLines) {
            log.info((Object)"Disable Areas2POIHook because add-pois-to-areas and add-pois-to-lines option is not set.");
            return false;
        }
        this.nameFinder = new NameFinder(props);
        this.poiPlacementTags = POIGeneratorHook.getPoiPlacementTags(props);
        this.saver = saver;
        this.usedTagsPOI = style != null && style.getUsedTagsPOI() != null ? style.getUsedTagsPOI().stream().filter(s -> s.startsWith(FROM_NODE_PREFIX)).map(s -> s.substring(FROM_NODE_PREFIX.length())).collect(Collectors.toSet()) : Collections.emptySet();
        return true;
    }

    public static List<Map.Entry<String, String>> getPoiPlacementTags(EnhancedProperties props) {
        String[] placementDefsParts;
        if (!props.containsKey("add-pois-to-areas")) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> tagList = new ArrayList<Map.Entry<String, String>>();
        String placementDefs = props.getProperty("pois-to-areas-placement", "entrance=main;entrance=yes;building=entrance");
        if ((placementDefs = placementDefs.trim()).length() == 0) {
            return tagList;
        }
        for (String placementDef : placementDefsParts = placementDefs.split(";")) {
            int ind = placementDef.indexOf(61);
            String tagName = null;
            String tagValue = null;
            if (ind < 0) {
                tagName = placementDef;
                tagValue = null;
            } else if (ind > 0) {
                tagName = placementDef.substring(0, ind);
                tagValue = placementDef.substring(ind + 1);
            } else {
                log.error((Object)"Option pois-to-areas-placement contains a tag that starts with '='. This is not allowed. Ignoring it.");
                continue;
            }
            tagName = tagName.trim();
            if (tagName.length() == 0) {
                log.error((Object)"Option pois-to-areas-placement contains a whitespace tag  '='. This is not allowed. Ignoring it.");
                continue;
            }
            if (tagValue != null && ((tagValue = tagValue.trim()).length() == 0 || "*".equals(tagValue))) {
                tagValue = null;
            }
            AbstractMap.SimpleImmutableEntry<String, String> tag = new AbstractMap.SimpleImmutableEntry<String, String>(tagName, tagValue);
            tagList.add(tag);
        }
        return tagList;
    }

    @Override
    public Set<String> getUsedTags() {
        return this.poiPlacementTags.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public void end() {
        log.info(this.getClass().getSimpleName(), "started");
        this.coordToNodeMap = new IdentityHashMap();
        if (!this.usedTagsPOI.isEmpty()) {
            block0: for (Node n : this.saver.getNodes().values()) {
                if (n.getLocation() instanceof CoordPOI) continue;
                for (String key : this.usedTagsPOI) {
                    if (n.getTag(key) == null) continue;
                    this.coordToNodeMap.put(n.getLocation(), n);
                    continue block0;
                }
            }
        }
        this.addPOIsForWays();
        this.addPOIsForMPs();
        this.coordToNodeMap.clear();
        log.info(this.getClass().getSimpleName(), "finished");
    }

    private int getPlacementOrder(Element elem) {
        for (int order = 0; order < this.poiPlacementTags.size(); ++order) {
            Map.Entry<String, String> poiTagDef = this.poiPlacementTags.get(order);
            String tagValue = elem.getTag(poiTagDef.getKey());
            if (tagValue == null || poiTagDef.getValue() != null && !poiTagDef.getValue().equals(tagValue)) continue;
            return order;
        }
        return -1;
    }

    private void addPOIsForWays() {
        IdentityHashMap<Coord, Integer> labelCoords = new IdentityHashMap<Coord, Integer>();
        if (!this.poiPlacementTags.isEmpty() && this.poisToAreas) {
            for (Node n : this.saver.getNodes().values()) {
                Integer prevOrder;
                int order = this.getPlacementOrder(n);
                if (order < 0 || (prevOrder = (Integer)labelCoords.get(n.getLocation())) != null && order >= prevOrder) continue;
                labelCoords.put(n.getLocation(), order);
            }
        }
        log.debug("Found", labelCoords.size(), "label coords");
        int ways2POI = 0;
        int lines2POI = 0;
        for (Way w : this.saver.getWays().values()) {
            if (w.getTagCount() == 0) continue;
            if (w.tagIsLikeYes(MultiPolygonRelation.TKM_MP_CREATED)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("MP processed: Do not create POI for", w.toTagString());
                continue;
            }
            if (w.hasIdenticalEndPoints()) {
                if (!this.poisToAreas) continue;
                this.addPOItoPolygon(w, labelCoords);
                ++ways2POI;
                continue;
            }
            if (!this.poisToLines) continue;
            lines2POI += this.addPOItoLine(w);
        }
        if (this.poisToAreas) {
            log.info(ways2POI, "POIs from single areas created");
        }
        if (this.poisToLines) {
            log.info(lines2POI, "POIs from lines created");
        }
    }

    private void addPOItoPolygon(Way polygon, Map<Coord, Integer> labelCoords) {
        if (!this.poisToAreas) {
            return;
        }
        Coord poiCoord = null;
        if (!labelCoords.isEmpty()) {
            int poiOrder = Integer.MAX_VALUE;
            for (Coord c : polygon.getPoints()) {
                Integer cOrder = labelCoords.get(c);
                if (cOrder == null || cOrder >= poiOrder) continue;
                poiCoord = c;
                poiOrder = cOrder;
                if (poiOrder != 0) continue;
                break;
            }
        }
        if (poiCoord == null) {
            poiCoord = polygon.getCofG();
        }
        this.areaSizeFunction.value(polygon);
        this.addPOI(polygon, poiCoord, TKM_AREA2POI, 0.0);
    }

    private int addPOItoLine(Way line) {
        Coord prevC = null;
        double sumDist = 0.0;
        ArrayList<Double> dists = new ArrayList<Double>(line.getPoints().size() - 1);
        for (Coord c : line.getPoints()) {
            if (prevC != null) {
                double dist = prevC.distance(c);
                dists.add(dist);
                sumDist += dist;
            }
            prevC = c;
        }
        int countPOIs = 0;
        if (this.poisToLinesStart) {
            Node startNode = this.addPOI(line, line.getFirstPoint(), TKM_LINE2POI, sumDist);
            startNode.addTag(TKM_LINE2POI_TYPE, "start");
            ++countPOIs;
        }
        if (this.poisToLinesEnd) {
            Node endNode = this.addPOI(line, line.getLastPoint(), TKM_LINE2POI, sumDist);
            endNode.addTag(TKM_LINE2POI_TYPE, "end");
            ++countPOIs;
        }
        if (this.poisToLinesOther && line.getPoints().size() > 2) {
            Coord lastPoint = line.getFirstPoint();
            for (Coord inPoint : line.getPoints().subList(1, line.getPoints().size() - 1)) {
                if (inPoint.equals(lastPoint)) continue;
                lastPoint = inPoint;
                Node innerNode = this.addPOI(line, inPoint, TKM_LINE2POI, sumDist);
                innerNode.addTag(TKM_LINE2POI_TYPE, "inner");
                ++countPOIs;
            }
        }
        if (this.poisToLinesMid) {
            Coord midPoint = null;
            double remMidDist = sumDist / 2.0;
            for (int midPos = 0; midPos < dists.size(); ++midPos) {
                double nextDist = (Double)dists.get(midPos);
                if (remMidDist <= nextDist) {
                    double frac = remMidDist / nextDist;
                    midPoint = line.getPoints().get(midPos).makeBetweenPoint(line.getPoints().get(midPos + 1), frac);
                    break;
                }
                remMidDist -= nextDist;
            }
            if (midPoint != null) {
                Node midNode = this.addPOI(line, midPoint, TKM_LINE2POI, sumDist);
                midNode.addTag(TKM_LINE2POI_TYPE, "mid");
                ++countPOIs;
            }
        }
        return countPOIs;
    }

    private Node addPOI(Element source, Coord poiCoord, short poiTypeTagKey, double wayLength) {
        Node poi = new Node(source.getOriginalId(), poiCoord);
        poi.markAsGeneratedFrom(source);
        poi.copyTags(source);
        poi.deleteTag("mkgmap:stylefilter");
        poi.addTag(poiTypeTagKey, "true");
        if (poiTypeTagKey == TKM_LINE2POI) {
            poi.addTag(TKM_WAY_LENGTH, String.valueOf(Math.round(wayLength)));
        }
        Node node = null;
        node = poiCoord instanceof CoordPOI ? ((CoordPOI)poiCoord).getNode() : this.coordToNodeMap.get(poiCoord);
        if (node != null) {
            for (Map.Entry<String, String> entry : node.getTagEntryIterator()) {
                if (entry.getKey().startsWith("mkgmap:")) continue;
                poi.addTag(FROM_NODE_PREFIX + entry.getKey(), entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Create POI", poi.toTagString(), "from", source.getId(), source.toTagString());
        }
        this.saver.addNode(poi);
        return poi;
    }

    private void addPOIsForMPs() {
        int mps2POI = 0;
        for (Relation r : this.saver.getRelations().values()) {
            if (!(r instanceof MultiPolygonRelation)) continue;
            Node adminCentre = null;
            Node labelPOI = null;
            String relName = this.nameFinder.getName(r);
            if (relName != null) {
                for (Map.Entry<String, Element> pair : r.getElements()) {
                    String role = pair.getKey();
                    Element el = pair.getValue();
                    if (!(el instanceof Node)) continue;
                    if ("admin_centre".equals(role)) {
                        String pName;
                        if (!"boundary".equals(r.getTag("type")) || !"administrative".equals(r.getTag("boundary")) || !relName.equals(pName = this.nameFinder.getName(el)) && pName != null) continue;
                        adminCentre = (Node)el;
                        if (!log.isDebugEnabled()) continue;
                        log.debug("using admin_centre node as location for POI for rel", r.getId(), relName, "at", ((Node)el).getLocation());
                        continue;
                    }
                    if (!"label".equals(role)) continue;
                    String label = this.nameFinder.getName(el);
                    if (relName.equals(label) || label == null) {
                        labelPOI = (Node)el;
                        log.debug("using label node as location for POI for rel", r.getId(), relName, "at", ((Node)el).getLocation());
                        break;
                    }
                    log.warn("role label", el.toBrowseURL(), label, "is ignored because it has a different name than", r.toBrowseURL(), relName);
                }
            }
            Coord point = null;
            point = adminCentre == null && labelPOI == null ? ((MultiPolygonRelation)r).getCofG() : (labelPOI != null ? labelPOI.getLocation() : adminCentre.getLocation());
            if (point == null) continue;
            Node poi = this.addPOI(r, point, TKM_AREA2POI, 0.0);
            poi.deleteTag("type");
            ++mps2POI;
        }
        log.info(mps2POI, "POIs from multipolygons created");
    }
}

