/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import uk.me.parabola.mkgmap.osmstyle.ActionRule;
import uk.me.parabola.mkgmap.osmstyle.ExpressionRule;
import uk.me.parabola.mkgmap.osmstyle.RuleDetails;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class RuleIndex {
    private final List<RuleDetails> ruleDetails = new ArrayList<RuleDetails>();
    private final Map<Short, TagHelper> tagKeyMap = new HashMap<Short, TagHelper>();
    private TagHelper[] tagKeyArray = null;
    private boolean inited;

    public void addRuleToIndex(RuleDetails rd) {
        assert (!this.inited);
        this.ruleDetails.add(rd);
    }

    public Rule[] getRules() {
        int len = this.ruleDetails.size();
        Rule[] rules = new Rule[len];
        int ruleDetailsSize = this.ruleDetails.size();
        for (int i = 0; i < ruleDetailsSize; ++i) {
            RuleDetails rd = this.ruleDetails.get(i);
            rules[i] = rd.getRule();
        }
        return rules;
    }

    public BitSet getRulesForTag(short tagKey, String tagVal) {
        TagHelper th;
        if (this.tagKeyArray != null) {
            if (tagKey <= 0) {
                throw new IllegalArgumentException("Invalid tagKey: " + tagKey);
            }
            th = tagKey < this.tagKeyArray.length ? this.tagKeyArray[tagKey] : null;
        } else {
            th = this.tagKeyMap.get(tagKey);
        }
        if (th == null) {
            return new BitSet();
        }
        return th.getBitSet(tagVal);
    }

    public void prepare() {
        Optional maxKey;
        if (this.inited) {
            return;
        }
        HashMap<String, BitSet> existKeys = new HashMap<String, BitSet>();
        HashMap<String, BitSet> tagVals = new HashMap<String, BitSet>();
        HashMap<String, BitSet> tagnames = new HashMap<String, BitSet>();
        this.filterRules();
        this.buildInitialIndex(existKeys, tagVals, tagnames);
        this.findDependingRules(existKeys, tagVals, tagnames);
        for (Map.Entry entry : existKeys.entrySet()) {
            Short skey = TagDict.getInstance().xlate((String)entry.getKey());
            this.tagKeyMap.put(skey, new TagHelper((BitSet)entry.getValue()));
        }
        for (Map.Entry entry : tagVals.entrySet()) {
            String keyString = (String)entry.getKey();
            int ind = keyString.indexOf(61);
            if (ind < 0) continue;
            short key = TagDict.getInstance().xlate(keyString.substring(0, ind));
            String val = keyString.substring(ind + 1);
            TagHelper th = this.tagKeyMap.computeIfAbsent(key, k -> new TagHelper(null));
            th.addTag(val, (BitSet)entry.getValue());
        }
        Optional minKey = this.tagKeyMap.keySet().stream().min(Short::compare);
        if (minKey.isPresent() && (Short)minKey.get() > 0 && (maxKey = this.tagKeyMap.keySet().stream().max(Short::compare)).isPresent()) {
            this.tagKeyArray = new TagHelper[(Short)maxKey.get() + 1];
            for (Map.Entry<Short, TagHelper> entry : this.tagKeyMap.entrySet()) {
                this.tagKeyArray[entry.getKey().shortValue()] = entry.getValue();
            }
            this.tagKeyMap.clear();
        }
        this.inited = true;
    }

    private void buildInitialIndex(Map<String, BitSet> existKeys, Map<String, BitSet> tagVals, Map<String, BitSet> tagnames) {
        for (int i = 0; i < this.ruleDetails.size(); ++i) {
            int ruleNumber = i;
            RuleDetails rd = this.ruleDetails.get(i);
            String keystring = rd.getKeystring();
            if (keystring.endsWith("=*")) {
                String key = keystring.substring(0, keystring.length() - 2);
                RuleIndex.addNumberToMap(existKeys, key, ruleNumber);
                RuleIndex.addNumberToMap(tagnames, key, ruleNumber);
                continue;
            }
            RuleIndex.addNumberToMap(tagVals, keystring, ruleNumber);
            int ind = keystring.indexOf(61);
            if (ind >= 0) {
                String key = keystring.substring(0, ind);
                RuleIndex.addNumberToMap(tagnames, key, ruleNumber);
                continue;
            }
            assert (false) : "rule index: no = in keystring " + keystring;
        }
    }

    private void findDependingRules(Map<String, BitSet> existKeys, Map<String, BitSet> tagVals, Map<String, BitSet> tagnames) {
        LinkedHashMap<Integer, BitSet> additionalRules = new LinkedHashMap<Integer, BitSet>();
        for (int i = 0; i < this.ruleDetails.size(); ++i) {
            int ruleNumber = i;
            RuleDetails rd = this.ruleDetails.get(i);
            Set<String> changeableTags = rd.getChangingTags();
            BitSet addedRules = new BitSet();
            for (String s : changeableTags) {
                BitSet set;
                int ind = s.indexOf(61);
                if (ind >= 0) {
                    String key;
                    BitSet set1;
                    set = tagVals.get(s);
                    if (set != null) {
                        addedRules.or(set);
                    }
                    if ((set1 = existKeys.get(key = s.substring(0, ind))) == null) continue;
                    addedRules.or(set1);
                    continue;
                }
                set = tagnames.get(s);
                if (set == null) continue;
                addedRules.or(set);
            }
            addedRules.clear(0, ruleNumber);
            if (addedRules.isEmpty()) continue;
            additionalRules.put(ruleNumber, addedRules);
        }
        for (Map.Entry e : additionalRules.entrySet()) {
            int ruleNumber = (Integer)e.getKey();
            BitSet addSet = (BitSet)e.getValue();
            for (Map m : Arrays.asList(existKeys, tagVals, tagnames)) {
                for (Map.Entry e2 : m.entrySet()) {
                    BitSet bi = (BitSet)e2.getValue();
                    if (!bi.get(ruleNumber)) continue;
                    bi.or(addSet);
                }
            }
        }
    }

    private void filterRules() {
        ArrayList<RuleDetails> filteredRules = new ArrayList<RuleDetails>(this.ruleDetails);
        HashSet<String> usedIfVars = new HashSet<String>();
        for (RuleDetails rd : filteredRules) {
            RuleIndex.findIfVarUsage(rd.getRule(), usedIfVars);
        }
        RuleIndex.removeUnused(filteredRules, usedIfVars);
        this.ruleDetails.clear();
        this.ruleDetails.addAll(filteredRules);
    }

    private static void removeUnused(List<RuleDetails> filteredRules, Set<String> usedIfVars) {
        if (usedIfVars.isEmpty()) {
            return;
        }
        filteredRules.removeIf(rd -> {
            ActionRule ar;
            if (rd.getRule() instanceof ActionRule && (ar = (ActionRule)rd.getRule()).toString().contains("set mkgmap:if:")) {
                for (String ifVars : usedIfVars) {
                    if (!ar.toString().contains("set " + ifVars)) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    private static void findIfVarUsage(Rule rule, Set<String> usedIfVars) {
        if (rule == null) {
            return;
        }
        Op expr = null;
        if (rule instanceof ExpressionRule) {
            expr = ((ExpressionRule)rule).getOp();
        } else if (rule instanceof ActionRule) {
            expr = ((ActionRule)rule).getOp();
        }
        if (expr == null) {
            return;
        }
        for (String usedTag : expr.getEvaluatedTagKeys()) {
            if (!usedTag.startsWith("mkgmap:if:")) continue;
            usedIfVars.add(usedTag);
        }
    }

    private static void addNumberToMap(Map<String, BitSet> map, String key, int ruleNumber) {
        map.computeIfAbsent(key, k -> new BitSet()).set(ruleNumber);
    }

    public List<RuleDetails> getRuleDetails() {
        return this.ruleDetails;
    }

    private class TagHelper {
        final BitSet exists;
        Map<String, BitSet> tagVals;

        public TagHelper(BitSet exits) {
            this.exists = exits;
        }

        public void addTag(String val, BitSet value) {
            if (this.tagVals == null) {
                this.tagVals = new HashMap<String, BitSet>();
            }
            if (this.exists != null) {
                BitSet merged = new BitSet();
                merged.or(this.exists);
                merged.or(value);
                this.tagVals.put(val, merged);
            } else {
                this.tagVals.put(val, value);
            }
        }

        public BitSet getBitSet(String tagVal) {
            BitSet set;
            if (this.tagVals != null && (set = this.tagVals.get(tagVal)) != null) {
                return (BitSet)set.clone();
            }
            if (this.exists != null) {
                return (BitSet)this.exists.clone();
            }
            return new BitSet();
        }
    }
}

