/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.KdTree;

public class NearbyPoiHandler {
    private static final Logger log = Logger.getLogger(NearbyPoiHandler.class);
    private final Map<MapPoint, Node> data = new LinkedHashMap<MapPoint, Node>();
    private final ArrayList<NearbyPoiRule> nearbyPoiRules = new ArrayList();
    private NearbyPoiRule defaultNamedNearbyPoiRule;
    private NearbyPoiRule defaultUnnamedNearbyPoiRule;

    public NearbyPoiHandler(EnhancedProperties props) {
        this.resetRules();
        String[] rules = props.getProperty("nearby-poi-rules", "").split(",");
        String rulesFileName = props.getProperty("nearby-poi-rules-config", "");
        if (!rulesFileName.isEmpty()) {
            File file = new File(rulesFileName);
            try {
                List<String> fileRules = Files.readAllLines(file.toPath());
                for (int i = 0; i < fileRules.size(); ++i) {
                    String rule = fileRules.get(i);
                    int hashPos = rule.indexOf(35);
                    if (hashPos < 0) continue;
                    fileRules.set(i, rule.substring(0, hashPos));
                }
                fileRules.addAll(Arrays.asList(rules));
                rules = fileRules.toArray(rules);
            }
            catch (IOException ex) {
                log.error("Error reading nearby POI rules file", rulesFileName);
            }
        }
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i].replaceAll("\\s+", "");
            if (rule.isEmpty()) continue;
            this.parseRule(rule, i);
        }
        if (!this.checkRules()) {
            this.resetRules();
        }
    }

    private void resetRules() {
        this.nearbyPoiRules.clear();
        this.defaultNamedNearbyPoiRule = new NearbyPoiRule();
        this.defaultUnnamedNearbyPoiRule = new NearbyPoiRule();
        this.defaultNamedNearbyPoiRule.actOn = NearbyPoiActOn.ACT_ON_NAMED;
        this.defaultUnnamedNearbyPoiRule.actOn = NearbyPoiActOn.ACT_ON_UNNAMED;
    }

    private boolean checkRules() {
        HashMap<Integer, NearbyPoiRule> test = new HashMap<Integer, NearbyPoiRule>();
        for (NearbyPoiRule r : this.nearbyPoiRules) {
            for (int i = r.minPoiType; i <= r.maxPoiType; ++i) {
                NearbyPoiRule old;
                if ((i & 0xFF) > 31) {
                    i = (i >> 8) + 1 << 8;
                }
                if ((old = test.put(i, r)) == null || r.maxDistance == old.maxDistance && r.action == old.action && r.actOn == old.actOn) continue;
                log.error("Different rules match for", GType.formatType(i));
                log.error((Object)old);
                log.error((Object)r);
                log.error((Object)"NearbyPoiHandler is disabled, only identical POI will be removed");
                return false;
            }
        }
        return true;
    }

    private void parseRule(String rule, int i) {
        NearbyPoiRule nearbyPoiRule = new NearbyPoiRule();
        boolean valid = true;
        String[] ruleParts = rule.split(":", 4);
        String part1 = ruleParts[0];
        int slashPos = part1.indexOf(47);
        if (slashPos > 0) {
            String part1Suffix = part1.substring(slashPos + 1);
            part1 = part1.substring(0, slashPos);
            switch (part1Suffix.toLowerCase()) {
                case "named": {
                    nearbyPoiRule.actOn = NearbyPoiActOn.ACT_ON_NAMED;
                    break;
                }
                case "unnamed": {
                    nearbyPoiRule.actOn = NearbyPoiActOn.ACT_ON_UNNAMED;
                    break;
                }
                case "all": {
                    break;
                }
                default: {
                    valid = false;
                    log.error("Invalid Act On value", part1Suffix, "in nearby poi rule", i + 1, rule, "- 'all', 'named' or 'unnamed' expected.");
                }
            }
        }
        if (!"*".equals(part1)) {
            String[] poiRange = part1.split("-", 2);
            try {
                nearbyPoiRule.minPoiType = Integer.decode(poiRange[0]);
                if (poiRange.length == 1) {
                    nearbyPoiRule.maxPoiType = nearbyPoiRule.minPoiType;
                } else {
                    nearbyPoiRule.maxPoiType = Integer.decode(poiRange[1]);
                    if (nearbyPoiRule.maxPoiType < nearbyPoiRule.minPoiType) {
                        valid = false;
                        log.error("Invalid POI range", part1, "in nearby poi rule", i + 1, rule);
                    }
                }
            }
            catch (Exception ex) {
                valid = false;
                log.error("Invalid POI type", part1, "in nearby poi rule", i + 1, rule);
            }
        }
        if (ruleParts.length > 1) {
            try {
                nearbyPoiRule.maxDistance = Integer.parseInt(ruleParts[1]);
            }
            catch (Exception ex) {
                valid = false;
                log.error("Invalid maximum distance", ruleParts[1], "in nearby poi rule", i + 1, rule);
            }
            if (ruleParts.length > 2) {
                switch (ruleParts[2].toLowerCase()) {
                    case "delete-poi": {
                        break;
                    }
                    case "delete-name": {
                        nearbyPoiRule.action = NearbyPoiAction.DELETE_NAME;
                        break;
                    }
                    default: {
                        valid = false;
                        log.error("Invalid Action value", ruleParts[2], "in nearby poi rule", i + 1, rule, "- 'delete-poi', or 'delete-name' expected.");
                    }
                }
            }
            if (ruleParts.length > 3) {
                log.warn("Unexpected text", ruleParts[3], "in nearby poi rule", i + 1, rule);
            }
            if (valid) {
                if ("*".equals(part1)) {
                    if (nearbyPoiRule.actOn != NearbyPoiActOn.ACT_ON_UNNAMED) {
                        this.defaultNamedNearbyPoiRule = nearbyPoiRule;
                    }
                    if (nearbyPoiRule.actOn != NearbyPoiActOn.ACT_ON_NAMED) {
                        this.defaultUnnamedNearbyPoiRule = nearbyPoiRule;
                    }
                } else {
                    int index;
                    int count = this.nearbyPoiRules.size();
                    for (index = 0; index < count; ++index) {
                        NearbyPoiRule ruleAtIndex = this.nearbyPoiRules.get(index);
                        if (nearbyPoiRule.minPoiType >= ruleAtIndex.minPoiType && (nearbyPoiRule.minPoiType != ruleAtIndex.minPoiType || nearbyPoiRule.maxDistance >= ruleAtIndex.maxDistance)) continue;
                        this.nearbyPoiRules.add(index, nearbyPoiRule);
                        break;
                    }
                    if (index == count) {
                        this.nearbyPoiRules.add(nearbyPoiRule);
                    }
                }
            }
        } else {
            log.error("Maximum distance expected for POI type", part1, "in nearby poi rule", i + 1, rule);
        }
    }

    public void add(MapPoint mp, Node node) {
        this.data.put(mp, node);
    }

    public Set<MapPoint> getAllPOI() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public Collection<MapPoint> deDuplicate() {
        Set<MapPoint> allPOI = this.data.keySet();
        if (allPOI.size() < 2) {
            return allPOI;
        }
        Comparator<MapPoint> typeAndName = Comparator.comparingInt(MapElement::getType).thenComparing(mp -> mp.getName() == null ? "" : mp.getName());
        List sorted = allPOI.stream().sorted(typeAndName).collect(Collectors.toList());
        HashSet<MapPoint> toKeep = new HashSet<MapPoint>();
        int first = 0;
        int last = 0;
        int n = sorted.size();
        while (first < n) {
            while (last < n && 0 == typeAndName.compare((MapPoint)sorted.get(first), (MapPoint)sorted.get(last))) {
                ++last;
            }
            toKeep.addAll(this.reduce(sorted.subList(first, last)));
            first = last;
        }
        if (toKeep.size() < allPOI.size()) {
            return allPOI.stream().filter(toKeep::contains).collect(Collectors.toList());
        }
        return allPOI;
    }

    private Collection<MapPoint> reduce(List<MapPoint> points) {
        if (points.size() == 1) {
            return points;
        }
        int type = points.get(0).getType();
        String name = points.get(0).getName();
        boolean isNamed = name != null && !name.isEmpty();
        for (NearbyPoiRule rule : this.nearbyPoiRules) {
            if (rule.minPoiType > type) break;
            if (rule.minPoiType > type || rule.maxPoiType < type || rule.actOn != NearbyPoiActOn.ACT_ON_ALL && (rule.actOn != NearbyPoiActOn.ACT_ON_NAMED || !isNamed) && (rule.actOn != NearbyPoiActOn.ACT_ON_UNNAMED || isNamed)) continue;
            return this.applyRule(points, rule);
        }
        NearbyPoiRule defaultRule = isNamed ? this.defaultNamedNearbyPoiRule : this.defaultUnnamedNearbyPoiRule;
        return this.applyRule(points, defaultRule);
    }

    private Collection<MapPoint> applyRule(List<MapPoint> points, NearbyPoiRule rule) {
        Set biggestCloud;
        ArrayList<MapPoint> toKeep = new ArrayList<MapPoint>();
        Map<MapPoint, Set<MapPoint>> groupsMap = NearbyPoiHandler.buildGroups(points, rule.maxDistance, toKeep);
        while (!groupsMap.isEmpty() && (biggestCloud = (Set)groupsMap.values().stream().max(Comparator.comparingInt(Set::size)).orElse(null)) != null && !biggestCloud.isEmpty()) {
            Coord middle = NearbyPoiHandler.calcMiddle(biggestCloud).getDisplayedCoord();
            HashSet done = new HashSet(biggestCloud);
            this.removeSimpleDuplicates(biggestCloud);
            MapPoint bestPoint = biggestCloud.stream().min(Comparator.comparingDouble(mp -> middle.distance(mp.getLocation().getDisplayedCoord()))).orElse((MapPoint)biggestCloud.iterator().next());
            this.performAction(rule.action, bestPoint, biggestCloud, toKeep);
            groupsMap.entrySet().forEach(e -> ((Set)e.getValue()).removeAll(done));
            groupsMap.entrySet().removeIf(e -> ((Set)e.getValue()).isEmpty());
        }
        return rule.action != NearbyPoiAction.DELETE_NAME ? toKeep : points;
    }

    private void removeSimpleDuplicates(Set<MapPoint> biggestCloud) {
        Long2ObjectOpenHashMap<MapPoint> locations = new Long2ObjectOpenHashMap<MapPoint>();
        Iterator<MapPoint> iter = biggestCloud.iterator();
        while (iter.hasNext()) {
            MapPoint mp = iter.next();
            if (locations.put(Utils.coord2Long(mp.getLocation()), mp) == null) continue;
            if (log.isInfoEnabled()) {
                log.info("Removed duplicate", this.getLogInfo(mp));
            }
            iter.remove();
        }
    }

    private static Map<MapPoint, Set<MapPoint>> buildGroups(List<MapPoint> points, int maxDistance, List<MapPoint> toKeep) {
        KdTree kdTree = new KdTree();
        points.forEach(kdTree::add);
        LinkedHashMap<MapPoint, Set<MapPoint>> groupsMap = new LinkedHashMap<MapPoint, Set<MapPoint>>();
        for (MapPoint mp : points) {
            Set set = kdTree.findClosePoints(mp, maxDistance);
            if (set.size() <= 1) {
                toKeep.add(mp);
                continue;
            }
            groupsMap.put(mp, set);
        }
        return groupsMap;
    }

    private void performAction(NearbyPoiAction action, MapPoint bestPoint, Set<MapPoint> biggestCloud, List<MapPoint> toKeep) {
        if (action == NearbyPoiAction.DELETE_NAME) {
            MapPoint midPoint = bestPoint;
            biggestCloud.stream().filter(mp -> mp != midPoint).forEach(mp -> {
                if (log.isInfoEnabled()) {
                    double dist = mp.getLocation().getDisplayedCoord().distance(bestPoint.getLocation().getDisplayedCoord());
                    log.info(String.format("Removed name from nearby(<= %d m)", (long)Math.ceil(dist)), this.getLogInfo((MapPoint)mp));
                }
                mp.setName(null);
            });
            return;
        }
        toKeep.add(bestPoint);
        if (log.isInfoEnabled()) {
            this.logRemoval(biggestCloud, bestPoint);
        }
    }

    private void logRemoval(Set<MapPoint> biggestCloud, MapPoint bestPoint) {
        for (MapPoint mp : biggestCloud) {
            if (mp == bestPoint) continue;
            double dist = mp.getLocation().getDisplayedCoord().distance(bestPoint.getLocation().getDisplayedCoord());
            log.info(String.format("Removed", this.getLogInfo(mp), "nearby (<= %d m)", (long)Math.ceil(dist)), this.getLogInfo(bestPoint));
        }
    }

    private static Coord calcMiddle(Set<MapPoint> points) {
        double lat = 0.0;
        double lon = 0.0;
        int n = points.size();
        for (MapPoint mp : points) {
            Coord p = mp.getLocation().getDisplayedCoord();
            lat += (double)p.getHighPrecLat() / (double)n;
            lon += (double)p.getHighPrecLon() / (double)n;
        }
        return Coord.makeHighPrecCoord((int)Math.round(lat), (int)Math.round(lon));
    }

    private String getLogInfo(MapPoint mp) {
        StringBuilder sb = new StringBuilder();
        String name = mp.getName();
        sb.append("POI with type " + GType.formatType(mp.getType()));
        sb.append(" \"");
        if (name != null && !name.isEmpty()) {
            sb.append(mp.getName());
        }
        sb.append('\"');
        Node n = this.data.get(mp);
        if (n != null) {
            sb.append(" for ");
            sb.append(n.toString());
        }
        return sb.toString();
    }

    private class NearbyPoiRule {
        int minPoiType = 0;
        int maxPoiType = 0;
        int maxDistance = 0;
        NearbyPoiActOn actOn = NearbyPoiActOn.ACT_ON_ALL;
        NearbyPoiAction action = NearbyPoiAction.DELETE_POI;

        private NearbyPoiRule() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(GType.formatType(this.minPoiType));
            if (this.minPoiType != this.maxPoiType) {
                sb.append('-').append(GType.formatType(this.maxPoiType));
            }
            if (this.actOn == NearbyPoiActOn.ACT_ON_NAMED) {
                sb.append("/named");
            }
            if (this.actOn == NearbyPoiActOn.ACT_ON_UNNAMED) {
                sb.append("/unnamed");
            }
            sb.append(':').append(this.maxDistance);
            if (this.action == NearbyPoiAction.DELETE_NAME) {
                sb.append(":delete-name");
            }
            return sb.toString();
        }
    }

    private static enum NearbyPoiAction {
        DELETE_POI,
        DELETE_NAME;

    }

    private static enum NearbyPoiActOn {
        ACT_ON_ALL,
        ACT_ON_NAMED,
        ACT_ON_UNNAMED;

    }
}

