/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.List;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.actions.Action;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;

public class ActionRule
implements Rule {
    private static final Logger statsLog = Logger.getLogger(ActionRule.class.getPackage().getName() + ".stats");
    private Op expression;
    private final List<Action> actions;
    private final GType type;
    private Rule finalizeRule;
    private long numEval;
    private long numTrue;
    private static final TypeResult finalizeTypeResult = (el, t) -> {
        throw new UnsupportedOperationException("Finalize rules must not contain an element type definition.");
    };

    public ActionRule(Op expression, List<Action> actions, GType type) {
        assert (actions != null);
        this.expression = expression;
        this.actions = actions;
        this.type = type;
    }

    public ActionRule(Op expression, List<Action> actions) {
        assert (actions != null);
        this.expression = expression;
        this.actions = actions;
        this.type = null;
    }

    @Override
    public int resolveType(int cacheId, Element el, TypeResult result) {
        Element element = el;
        if (this.expression != null) {
            ++this.numEval;
            if (!this.expression.eval(cacheId, element)) {
                return cacheId;
            }
            ++this.numTrue;
            if (this.type != null && !this.type.isPropogateActions() && !(element instanceof Relation)) {
                element = element.copy();
            }
        }
        boolean invalidateCache = false;
        for (Action a : this.actions) {
            invalidateCache |= a.perform(element);
        }
        if (invalidateCache) {
            ++cacheId;
        }
        if (this.type != null && this.finalizeRule != null) {
            if (el == element && this.type.isContinueSearch()) {
                element = element.copy();
            }
            if (this.type.getDefaultName() != null) {
                element.addTag("mkgmap:default_name", this.type.getDefaultName());
            }
            cacheId = this.finalizeRule.resolveType(cacheId, element, finalizeTypeResult);
        }
        result.add(element, this.type);
        return cacheId;
    }

    @Override
    public void resolveType(Element el, TypeResult result) {
        Element element = el;
        if (this.expression != null) {
            ++this.numEval;
            if (!this.expression.eval(element)) {
                return;
            }
            ++this.numTrue;
            if (this.type != null && !this.type.isPropogateActions() && !(element instanceof Relation)) {
                element = element.copy();
            }
        }
        for (Action a : this.actions) {
            a.perform(element);
        }
        if (this.type != null && this.finalizeRule != null) {
            if (el == element && this.type.isContinueSearch()) {
                element = element.copy();
            }
            if (this.type.getDefaultName() != null) {
                element.addTag("mkgmap:default_name", this.type.getDefaultName());
            }
            this.finalizeRule.resolveType(element, finalizeTypeResult);
        }
        result.add(element, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.expression != null) {
            sb.append(this.expression);
        }
        sb.append(" {");
        for (Action a : this.actions) {
            sb.append(a);
        }
        sb.append("}");
        if (this.type != null) {
            sb.append(' ');
            sb.append(this.type);
        }
        return sb.toString();
    }

    @Override
    public void setFinalizeRule(Rule finalizeRule) {
        this.finalizeRule = finalizeRule;
    }

    @Override
    public Rule getFinalizeRule() {
        return this.finalizeRule;
    }

    public Op getOp() {
        return this.expression;
    }

    public void setOp(Op expression) {
        this.expression = expression;
    }

    @Override
    public void printStats(String header) {
        if (statsLog.isInfoEnabled()) {
            statsLog.info(header, "stats (rule/evals/true)", this.toString() + "/" + this.numEval + "/" + this.numTrue);
        }
    }

    @Override
    public boolean containsExpression(String exp) {
        return this.expression.toString().contains(exp);
    }

    @Override
    public void augmentWith(ElementSaver elementSaver) {
        this.expression.augmentWith(elementSaver);
    }
}

