/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.osmstyle.ActionRule;
import uk.me.parabola.mkgmap.osmstyle.ExpressionRule;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.osmstyle.StyledConverter;
import uk.me.parabola.mkgmap.osmstyle.TypeReader;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionList;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionReader;
import uk.me.parabola.mkgmap.osmstyle.eval.ExpressionReader;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.mkgmap.reader.osm.WatchableTypeResult;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.xml.OsmXmlHandler;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.util.EnhancedProperties;

public class StyleTester
implements OsmConverter {
    private static final Pattern SPACES_PATTERN = Pattern.compile(" +");
    private static final Pattern EQUAL_PATTERN = Pattern.compile("=");
    private static final String STYLETESTER_STYLE = "styletester.style";
    private static PrintStream out = System.out;
    private static boolean reference;
    private final OsmConverter converter;
    private static boolean forceUseOfGiven;
    private static boolean showMatches;
    private static boolean print;

    private StyleTester(String stylefile, MapCollector coll, boolean reference) throws FileNotFoundException {
        this.converter = reference ? this.makeStrictStyleConverter(stylefile, coll) : StyleTester.makeStyleConverter(stylefile, coll);
    }

    public static void main(String ... args) throws IOException {
        String[] a = StyleTester.processOptions(args);
        if (a.length == 1) {
            StyleTester.runSimpleTest(a[0]);
        } else {
            StyleTester.runTest(a[0], a[1]);
        }
    }

    public static void setOut(PrintStream out) {
        StyleTester.out = out;
    }

    private static String[] processOptions(String ... args) {
        ArrayList<String> a = new ArrayList<String>();
        for (String s : args) {
            if (s.startsWith("--reference")) {
                System.out.println("# using reference method of calculation");
                reference = true;
                continue;
            }
            if (s.startsWith("--show-matches")) {
                if (!reference) {
                    System.out.println("# using reference method of calculation");
                }
                reference = true;
                showMatches = true;
                continue;
            }
            if (s.startsWith("--no-print")) {
                print = false;
                continue;
            }
            a.add(s);
        }
        return a.toArray(new String[a.size()]);
    }

    private static void runTest(String stylefile, String mapfile) {
        StyleTester normal;
        PrintingMapCollector collector = new PrintingMapCollector();
        try {
            normal = new StyleTester(stylefile, collector, reference);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open style file " + stylefile);
            return;
        }
        try {
            InputStream is = Utils.openFile(mapfile);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setXIncludeAware(true);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                EnhancedProperties props = new EnhancedProperties();
                props.put("preserve-element-order", "1");
                ElementSaver saver = new ElementSaver(props);
                OsmXmlHandler handler = new OsmXmlHandler();
                OsmXmlHandler.SaxHandler saxHandler = new OsmXmlHandler.SaxHandler(handler);
                handler.setElementSaver(saver);
                parser.parse(is, (DefaultHandler)saxHandler);
                saver.finishLoading();
                saver.convert(normal);
                System.err.println("Conversion time " + (System.currentTimeMillis() - collector.getStart()) + "ms");
            }
            catch (IOException e) {
                throw new FormatException("Error reading file", e);
            }
        }
        catch (SAXException e) {
            throw new FormatException("Error parsing file", e);
        }
        catch (ParserConfigurationException e) {
            throw new FormatException("Internal error configuring xml parser", e);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open file " + mapfile);
        }
    }

    public static void runSimpleTest(String filename) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));){
            List<Way> ways = StyleTester.readSimpleTestFile(br);
            List<String> givenList = StyleTester.readGivenResults();
            boolean noStrict = false;
            if (!givenList.isEmpty() && Objects.equals(givenList.get(0), "NO-STRICT")) {
                givenList.remove(0);
                noStrict = true;
            }
            ArrayList<MapElement> strictResults = new ArrayList<MapElement>();
            ArrayList<MapElement> results = new ArrayList<MapElement>();
            ArrayList<String> actual = new ArrayList<String>();
            ArrayList<String> expected = new ArrayList<String>();
            for (Way w : ways) {
                StyleTester normal = new StyleTester(STYLETESTER_STYLE, new LocalMapCollector(results), false);
                String prefix = "WAY " + w.getId() + ": ";
                normal.convertWay(w.copy());
                normal.end();
                actual.addAll(StyleTester.formatResults(prefix, results));
                results.clear();
                if (noStrict) continue;
                StyleTester strict = new StyleTester(STYLETESTER_STYLE, new LocalMapCollector(strictResults), true);
                strict.convertWay(w.copy());
                strict.end();
                expected.addAll(StyleTester.formatResults(prefix, strictResults));
                strictResults.clear();
            }
            StyleTester.printResult("", actual);
            if (!noStrict && !Objects.equals(actual, expected)) {
                out.println("ERROR expected result is:");
                StyleTester.printResult("|", expected);
            }
            if (!(givenList.isEmpty() && !forceUseOfGiven || Objects.equals(actual, givenList))) {
                out.println("ERROR given results were:");
                StyleTester.printResult("", givenList);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open test file " + filename);
        }
        catch (IOException e) {
            System.err.println("Failure while reading test file " + filename);
        }
    }

    private static List<String> readGivenResults() {
        ArrayList<String> givenResults = new ArrayList<String>();
        try (StyleFileLoader fileLoader = StyleFileLoader.createStyleLoader(STYLETESTER_STYLE, null);
             Reader reader = fileLoader.open("results");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                givenResults.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return givenResults;
    }

    @Override
    public void convertWay(Way way) {
        this.converter.convertWay(way);
    }

    @Override
    public void convertNode(Node node) {
        this.converter.convertNode(node);
    }

    @Override
    public void convertRelation(Relation relation) {
        this.converter.convertRelation(relation);
    }

    @Override
    public void setBoundingBox(Area bbox) {
        this.converter.setBoundingBox(bbox);
    }

    @Override
    public void end() {
        this.converter.end();
    }

    private static void printResult(String prefix, List<String> results) {
        for (String s : results) {
            out.println(prefix + s);
        }
    }

    private static List<Way> readSimpleTestFile(BufferedReader br) throws IOException {
        String line;
        ArrayList<Way> ways = new ArrayList<Way>();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).toLowerCase(Locale.ENGLISH).startsWith("way")) {
                Way w = StyleTester.readWayTags(br, line);
                ways.add(w);
                continue;
            }
            if (!line.startsWith("<<<")) continue;
            StyleTester.readStyles(br, line);
        }
        return ways;
    }

    private static Way readWayTags(BufferedReader br, String waydef) throws IOException {
        String line;
        int id = 1;
        String[] strings = SPACES_PATTERN.split(waydef);
        if (strings.length > 1) {
            id = Integer.parseInt(strings[1]);
        }
        Way w = new Way(id);
        w.addPoint(new Coord(1, 1));
        w.addPoint(new Coord(2, 2));
        while ((line = br.readLine()) != null && line.indexOf(61) >= 0) {
            String[] tagval = EQUAL_PATTERN.split(line, 2);
            if (tagval.length != 2) continue;
            w.addTag(tagval[0], tagval[1]);
        }
        return w;
    }

    private static List<String> formatResults(String prefix, List<MapElement> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (MapElement el : lines) {
            String s = el instanceof MapRoad ? StyleTester.roadToString((MapRoad)el) : StyleTester.lineToString((MapLine)el);
            result.add(prefix + s);
        }
        return result;
    }

    private static String lineToString(MapLine el) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Line 0x%x, labels=%s, res=%d-%d", el.getType(), Arrays.toString(el.getLabels()), el.getMinResolution(), el.getMaxResolution()));
        if (el.isDirection()) {
            sb.append(" oneway");
        }
        sb.append(' ');
        for (Coord co : el.getPoints()) {
            sb.append(String.format("(%s),", co.toGarminString()));
        }
        return sb.toString();
    }

    private static String roadToString(MapRoad el) {
        StringBuilder sb = new StringBuilder(StyleTester.lineToString(el));
        sb.replace(0, 4, "Road");
        sb.append(String.format(" road class=%d speed=%d", el.getRoadDef().getRoadClass(), StyleTester.getRoadSpeed(el.getRoadDef())));
        return sb.toString();
    }

    private static int getRoadSpeed(RoadDef roadDef) {
        try {
            Field field = RoadDef.class.getDeclaredField("tabAInfo");
            field.setAccessible(true);
            int tabA = (Integer)field.get(roadDef);
            return tabA & 7;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readStyles(BufferedReader br, String initLine) throws IOException {
        FileWriter writer = new FileWriter(STYLETESTER_STYLE);
        PrintWriter pw = new PrintWriter(writer);
        pw.println("<<<version>>>\n0");
        pw.println(initLine);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                pw.println(line);
            }
        }
        finally {
            pw.close();
        }
    }

    private static StyledConverter makeStyleConverter(String styleFile, MapCollector coll) throws FileNotFoundException {
        StyleImpl style = new StyleImpl(styleFile, null);
        return new StyledConverter(style, coll, new EnhancedProperties());
    }

    private StyledConverter makeStrictStyleConverter(String styleFile, MapCollector coll) throws FileNotFoundException {
        ReferenceStyle style = new ReferenceStyle(styleFile, null);
        return new StyledConverter(style, coll, new EnhancedProperties());
    }

    public static void forceUseOfGiven() {
        forceUseOfGiven = true;
    }

    static {
        print = true;
    }

    private static class PrintingMapCollector
    implements MapCollector {
        private long start;

        private PrintingMapCollector() {
        }

        @Override
        public void addToBounds(Coord p) {
            if (this.start == 0L) {
                System.err.println("start collection");
                this.start = System.currentTimeMillis();
            }
        }

        @Override
        public void addPoint(MapPoint point) {
        }

        @Override
        public void addLine(MapLine line) {
            if (this.start == 0L) {
                System.err.println("start collection");
                this.start = System.currentTimeMillis();
            }
            if (print) {
                List strings = StyleTester.formatResults("", Collections.singletonList(line));
                StyleTester.printResult("", strings);
            }
        }

        @Override
        public void addShape(MapShape shape) {
        }

        @Override
        public void addRoad(MapRoad road) {
            if (print) {
                List strings = StyleTester.formatResults("", Collections.singletonList(road));
                StyleTester.printResult("", strings);
            }
        }

        @Override
        public int addRestriction(GeneralRouteRestriction grr) {
            return 0;
        }

        public long getStart() {
            return this.start;
        }
    }

    private static class LocalMapCollector
    implements MapCollector {
        private final List<MapElement> lines;

        private LocalMapCollector(List<MapElement> lines) {
            this.lines = lines;
        }

        @Override
        public void addToBounds(Coord p) {
        }

        @Override
        public void addPoint(MapPoint point) {
        }

        @Override
        public void addLine(MapLine line) {
            this.lines.add(line);
        }

        @Override
        public void addShape(MapShape shape) {
        }

        @Override
        public void addRoad(MapRoad road) {
            this.lines.add(road);
        }

        @Override
        public int addRestriction(GeneralRouteRestriction grr) {
            return 0;
        }
    }

    private class ReferenceStyle
    extends StyleImpl {
        private final StyleFileLoader fileLoader;
        private LevelInfo[] levels;

        ReferenceStyle(String loc, String name) throws FileNotFoundException {
            super(loc, name);
            this.fileLoader = StyleFileLoader.createStyleLoader(loc, name);
            this.setupReader();
        }

        private void setupReader() {
            String l = "0:24, 1:22, 2:20, 3:18, 4:16";
            this.levels = LevelInfo.createFromString(l);
        }

        @Override
        public Rule getWayRules() {
            ReferenceRuleSet r = new ReferenceRuleSet();
            r.addAll((ReferenceRuleSet)this.getLineRules());
            r.addAll((ReferenceRuleSet)this.getPolygonRules());
            return r;
        }

        @Override
        public Rule getLineRules() {
            ReferenceRuleSet r = new ReferenceRuleSet();
            SimpleRuleFileReader ruleFileReader = new SimpleRuleFileReader(FeatureKind.POLYLINE, this.levels, r);
            try {
                ruleFileReader.load(this.fileLoader, "lines");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            return r;
        }

        @Override
        public Rule getPolygonRules() {
            ReferenceRuleSet r = new ReferenceRuleSet();
            SimpleRuleFileReader ruleFileReader = new SimpleRuleFileReader(FeatureKind.POLYGON, this.levels, r);
            try {
                ruleFileReader.load(this.fileLoader, "polygons");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return r;
        }

        @Override
        public Rule getRelationRules() {
            ReferenceRuleSet r = new ReferenceRuleSet();
            SimpleRuleFileReader ruleFileReader = new SimpleRuleFileReader(FeatureKind.RELATION, this.levels, r);
            try {
                ruleFileReader.load(this.fileLoader, "relations");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return r;
        }

        @Override
        public Set<String> getUsedTags() {
            return null;
        }

        class SimpleRuleFileReader {
            private final TypeReader typeReader;
            private final ReferenceRuleSet rules;
            private ReferenceRuleSet finalizeRules;
            private TokenScanner scanner;
            private boolean inFinalizeSection;

            SimpleRuleFileReader(FeatureKind kind, LevelInfo[] levels, ReferenceRuleSet rules) {
                this.rules = rules;
                this.typeReader = new TypeReader(kind, levels);
            }

            public void load(StyleFileLoader loader, String name) throws FileNotFoundException {
                Reader r = loader.open(name);
                this.load(r, name);
            }

            void load(Reader r, String name) {
                this.scanner = new TokenScanner(name, r);
                this.scanner.setExtraWordChars("-:");
                ExpressionReader expressionReader = new ExpressionReader(this.scanner, FeatureKind.POLYLINE);
                ActionReader actionReader = new ActionReader(this.scanner);
                this.scanner.skipSpace();
                while (!this.scanner.isEndOfFile()) {
                    if (this.checkCommand(this.scanner)) continue;
                    Op expr = expressionReader.readConditions();
                    ActionList actions = actionReader.readActions();
                    GType type = null;
                    if (this.scanner.checkToken("[")) {
                        type = this.typeReader.readType(this.scanner);
                    } else if (actions == null) {
                        throw new SyntaxException(this.scanner, "No type definition given");
                    }
                    this.saveRule(expr, actions, type);
                    this.scanner.skipSpace();
                }
                if (this.finalizeRules != null) {
                    this.rules.setFinalizeRule(this.finalizeRules);
                }
            }

            private boolean checkCommand(TokenScanner scanner) {
                scanner.skipSpace();
                if (scanner.isEndOfFile()) {
                    return false;
                }
                if (!this.inFinalizeSection && scanner.checkToken("<")) {
                    Token token = scanner.nextToken();
                    if (scanner.checkToken("finalize")) {
                        Token finalizeToken = scanner.nextToken();
                        if (scanner.checkToken(">")) {
                            scanner.nextToken();
                            this.inFinalizeSection = true;
                            this.finalizeRules = new ReferenceRuleSet();
                            return true;
                        }
                        scanner.pushToken(finalizeToken);
                        scanner.pushToken(token);
                    } else {
                        scanner.pushToken(token);
                    }
                }
                scanner.skipSpace();
                return false;
            }

            private void saveRule(Op op, ActionList actions, GType gt) {
                Rule rule = actions.isEmpty() ? new ExpressionRule(op, gt) : new ActionRule(op, actions.getList(), gt);
                if (this.inFinalizeSection) {
                    this.finalizeRules.add(rule);
                } else {
                    this.rules.add(rule);
                }
            }
        }

        private class ReferenceRuleSet
        implements Rule {
            private final List<Rule> rules = new ArrayList<Rule>();
            int cacheId;

            private ReferenceRuleSet() {
            }

            public void add(Rule rule) {
                this.rules.add(rule);
            }

            public void addAll(ReferenceRuleSet rs) {
                for (Rule r : rs.rules) {
                    this.add(r);
                }
            }

            @Override
            public void resolveType(Element el, TypeResult result) {
                String tagsBefore = el.toTagString();
                if (showMatches) {
                    out.println("# Tags before: " + tagsBefore);
                }
                WatchableTypeResult a = new WatchableTypeResult(result);
                for (Rule rule : this.rules) {
                    a.reset();
                    this.cacheId = rule.resolveType(this.cacheId, el, a);
                    if (showMatches) {
                        if (a.isFound()) {
                            out.println("# Matched: " + rule);
                        } else if (a.isActionsOnly()) {
                            out.println("# Matched for actions: " + rule);
                        }
                    }
                    if (!a.isResolved()) continue;
                    break;
                }
                if (showMatches && !Objects.equals(tagsBefore, el.toTagString())) {
                    out.println("# Way tags after: " + el.toTagString());
                }
            }

            @Override
            public int resolveType(int cacheId, Element el, TypeResult result) {
                this.resolveType(el, result);
                return cacheId;
            }

            @Override
            public void setFinalizeRule(Rule finalizeRule) {
                for (Rule rule : this.rules) {
                    rule.setFinalizeRule(finalizeRule);
                }
            }

            @Override
            public Rule getFinalizeRule() {
                if (this.rules.isEmpty()) {
                    return null;
                }
                return this.rules.get(0).getFinalizeRule();
            }

            @Override
            public void printStats(String header) {
            }

            @Override
            public boolean containsExpression(String exp) {
                if (this.rules.isEmpty()) {
                    throw new IllegalStateException("First call prepare() before setting the finalize rules");
                }
                for (Rule rule : this.rules) {
                    if (!rule.containsExpression(exp)) continue;
                    return true;
                }
                return this.getFinalizeRule() != null && this.getFinalizeRule().containsExpression(exp);
            }
        }
    }
}

