/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.ArgumentProcessor;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.CommandArgsReader;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.GmapiBuilder;
import uk.me.parabola.mkgmap.combiners.GmapsuppBuilder;
import uk.me.parabola.mkgmap.combiners.MdrBuilder;
import uk.me.parabola.mkgmap.combiners.MdxBuilder;
import uk.me.parabola.mkgmap.combiners.NsisBuilder;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.combiners.TdbBuilder;
import uk.me.parabola.mkgmap.main.MapMaker;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.main.TypCompiler;
import uk.me.parabola.mkgmap.main.TypSaver;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.StyleInfo;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.srt.SrtTextReader;
import uk.me.parabola.util.EnhancedProperties;

public class Main
implements ArgumentProcessor {
    private static final Logger log = Logger.getLogger(Main.class);
    private static final Date StartTime = new Date();
    private final List<Combiner> combiners = new ArrayList<Combiner>();
    private final Map<String, MapProcessor> processMap = new HashMap<String, MapProcessor>();
    private String styleFile = "classpath:styles";
    private String styleOption;
    private boolean verbose;
    private final List<FilenameTask> futures = new LinkedList<FilenameTask>();
    private ExecutorService threadPool;
    private int maxJobs = 0;
    private boolean createTdbFiles = false;
    private boolean tdbBuilderAdded = false;
    private String searchedStyleName;
    private volatile int programRC = 0;
    private final Map<String, Combiner> combinerMap = new HashMap<String, Combiner>();
    private final Map<String, String> sourceMap = new HashMap<String, String>();
    private boolean informationDisplayed = false;

    public static void mainNoSystemExit(String ... args) {
        Main.mainStart(args);
    }

    public static void main(String ... args) {
        int rc = Main.mainStart(args);
        if (rc != 0) {
            System.exit(1);
        }
    }

    private static int mainStart(String ... args) {
        String message;
        Instant start = Instant.now();
        if (args.length < 1) {
            Main.printUsage();
            Main.printHelp(System.err, Main.getLang(), "options");
            return 0;
        }
        Main mm = new Main();
        int numExitExceptions = 0;
        CommandArgsReader commandArgs = new CommandArgsReader(mm);
        try {
            commandArgs.setValidOptions(Main.getValidOptions(System.err));
            commandArgs.readArgs(args);
        }
        catch (OutOfMemoryError e) {
            ++numExitExceptions;
            message = "Out of memory.\r\n";
            message = mm.maxJobs > 1 ? message + "Try using the mkgmap --max-jobs option with a value less than " + mm.maxJobs + " to reduce the memory requirement, or use the Java -Xmx option to increase the available heap memory." : message + "Try using the Java -Xmx option to increase the available heap memory.";
            Logger.defaultLogger.error((Object)message, e);
        }
        catch (ExitException | MapFailedException e) {
            ++numExitExceptions;
            message = e.getMessage();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = message + "\r\n" + cause.toString();
            }
            Logger.defaultLogger.error((Object)message);
        }
        if (commandArgs.getHasFiles()) {
            Logger.defaultLogger.write("Number of ExitExceptions: " + numExitExceptions);
            Logger.defaultLogger.write("Time finished: " + new Date());
            Duration duration = Duration.between(start, Instant.now());
            long seconds = duration.getSeconds();
            if (seconds > 0L) {
                long hours = seconds / 3600L;
                long minutes = (seconds -= hours * 3600L) / 60L;
                Logger.defaultLogger.write("Total time taken: " + (hours > 0L ? hours + (hours > 1L ? " hours " : " hour ") : "") + (minutes > 0L ? minutes + (minutes > 1L ? " minutes " : " minute ") : "") + (seconds > 0L ? (seconds -= minutes * 60L) + (seconds > 1L ? " seconds" : " second") : ""));
            } else {
                Logger.defaultLogger.write("Total time taken: " + duration.getNano() / 1000000 + " ms");
            }
        } else if (numExitExceptions == 0 && !mm.informationDisplayed) {
            System.err.println("The command line does not appear to require mkgmap to do anything.");
        }
        return numExitExceptions > 0 || mm.getProgramRC() != 0 ? 1 : 0;
    }

    private static void printUsage() {
        System.err.println("Usage: mkgmap [options...] <file.osm>");
    }

    private void setProgramRC(int rc) {
        this.programRC = rc;
    }

    private int getProgramRC() {
        return this.programRC;
    }

    private static void printHelp(PrintStream err, String lang, String file) {
        String path = "/help/" + lang + '/' + file;
        try (InputStream stream = Main.class.getResourceAsStream(path);){
            String line;
            if (stream == null) {
                err.println("Could not find the help topic: " + file + ", sorry");
                return;
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = r.readLine()) != null) {
                err.println(line);
            }
        }
        catch (IOException e) {
            err.println("Could not read the help topic: " + file + ", sorry");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> getValidOptions(PrintStream err) {
        try (InputStream stream = Main.class.getResourceAsStream("/help/en/options");){
            String line;
            if (stream == null) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            HashSet<String> knownOptions = new HashSet<String>();
            BufferedReader r = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            Pattern p = Pattern.compile("^--?([a-zA-Z0-9-]*).*$");
            while ((line = r.readLine()) != null) {
                Matcher matcher = p.matcher(line);
                if (!matcher.matches()) continue;
                knownOptions.add(matcher.group(1));
            }
            HashSet<String> hashSet = knownOptions;
            return hashSet;
        }
        catch (IOException e) {
            err.println("Could not read valid options");
            return Collections.emptySet();
        }
    }

    @Override
    public void startOptions() {
        MapProcessor saver = (args, filename) -> filename;
        this.processMap.put("img", saver);
        this.processMap.put("mdx", saver);
        this.processMap.put("typ", new TypSaver());
        this.processMap.put("rgn", saver);
        this.processMap.put("tre", saver);
        this.processMap.put("lbl", saver);
        this.processMap.put("net", saver);
        this.processMap.put("nod", saver);
        this.processMap.put("txt", new TypCompiler());
    }

    @Override
    public void processFilename(CommandArgs args, String filename) {
        String ext = Main.extractExtension(filename);
        log.debug("file", filename, ", extension is", ext);
        if (OverviewBuilder.isOverviewImg(filename)) {
            return;
        }
        MapProcessor mp = this.mapMaker(ext);
        args.setSort(this.getSort(args));
        log.info((Object)("Submitting job " + filename));
        FilenameTask task = new FilenameTask(() -> {
            log.threadTag(filename);
            if (filename.startsWith("test-map:") || new File(filename).exists()) {
                String output = mp.makeMap(args, filename);
                log.debug("adding output name", output);
                log.threadTag(null);
                return output;
            }
            log.error((Object)("input file '" + filename + "' doesn't exist"));
            return null;
        });
        task.setArgs(args);
        task.setSource(filename);
        this.futures.add(task);
    }

    private MapProcessor mapMaker(String ext) {
        MapProcessor mp = this.processMap.get(ext);
        if (mp == null) {
            mp = new MapMaker(this.createTdbFiles);
        }
        return mp;
    }

    @Override
    public void processOption(String opt, String val) {
        log.debug("option:", opt, val);
        switch (opt) {
            case "number-of-files": {
                int n = Integer.parseInt(val);
                if (n <= 0) break;
                this.createTdbFiles = true;
                break;
            }
            case "help": {
                this.informationDisplayed = true;
                Main.printHelp(System.out, Main.getLang(), !val.isEmpty() ? val : "help");
                break;
            }
            case "style-file": 
            case "map-features": {
                this.styleFile = val;
                break;
            }
            case "style": {
                this.styleOption = val;
                break;
            }
            case "verbose": {
                this.verbose = true;
                break;
            }
            case "list-styles": {
                this.informationDisplayed = true;
                this.listStyles();
                break;
            }
            case "check-styles": {
                this.informationDisplayed = true;
                this.checkStyles();
                break;
            }
            case "max-jobs": {
                if (val.isEmpty()) {
                    this.maxJobs = Runtime.getRuntime().availableProcessors();
                    break;
                }
                this.maxJobs = Integer.parseInt(val);
                if (this.maxJobs < 1) {
                    Logger.defaultLogger.warn((Object)"max-jobs has to be at least 1");
                    this.maxJobs = 1;
                }
                if (this.maxJobs <= Runtime.getRuntime().availableProcessors()) break;
                Logger.defaultLogger.warn((Object)"It is recommended that max-jobs be no greater that the number of processor cores");
                break;
            }
            case "version": {
                this.informationDisplayed = true;
                System.err.println("Mkgmap version " + Version.VERSION);
                System.err.println(Version.VERSION);
                System.exit(0);
            }
        }
    }

    @Override
    public void removeOption(String opt) {
        if ("tdbfile".equals(opt)) {
            this.createTdbFiles = false;
        }
    }

    private void addTdbBuilder() {
        if (!this.tdbBuilderAdded) {
            OverviewBuilder overviewBuilder = new OverviewBuilder();
            this.addCombiner("img", overviewBuilder);
            TdbBuilder tdbBuilder = new TdbBuilder(overviewBuilder);
            this.addCombiner("tdb", tdbBuilder);
            this.tdbBuilderAdded = true;
        }
    }

    private void listStyles() {
        Object[] names;
        try {
            StyleFileLoader loader = StyleFileLoader.createStyleLoader(this.styleFile, null);
            names = loader.list();
            loader.close();
        }
        catch (FileNotFoundException e) {
            log.debug("didn't find style file", e);
            throw new ExitException("Could not list style file " + this.styleFile);
        }
        Arrays.sort(names);
        System.out.println("The following styles are available:");
        for (Object name : names) {
            Style style = this.readOneStyle((String)name, false);
            if (style == null) continue;
            StyleInfo info = style.getInfo();
            System.out.format("%-15s %6s: %s\n", this.searchedStyleName, info.getVersion(), info.getSummary());
            if (!this.verbose) continue;
            for (String s : info.getLongDescription().split("\n")) {
                System.out.printf("\t%s\n", s.trim());
            }
        }
    }

    private void checkStyles() {
        Object[] names;
        try {
            StyleFileLoader loader = StyleFileLoader.createStyleLoader(this.styleFile, null);
            names = loader.list();
            loader.close();
        }
        catch (FileNotFoundException e) {
            log.debug("didn't find style file", e);
            throw new ExitException("Could not check style file " + this.styleFile);
        }
        Arrays.sort(names);
        if (this.styleOption == null) {
            if (names.length > 1) {
                System.out.println("The following styles are available:");
            } else {
                System.out.println("Found one style in " + this.styleFile);
            }
        }
        int checked = 0;
        for (Object name : names) {
            Style style;
            if (this.styleOption != null && !Objects.equals(name, this.styleOption)) continue;
            if (names.length > 1) {
                System.out.println("checking style: " + (String)name);
            }
            ++checked;
            boolean performChecks = true;
            if ("classpath:styles".equals(this.styleFile) && !"default".equals(name)) {
                performChecks = false;
            }
            if ((style = this.readOneStyle((String)name, performChecks)) != null) continue;
            System.out.println("could not open style " + (String)name);
        }
        if (checked == 0) {
            System.out.println("could not open style " + this.styleOption + " in " + this.styleFile);
        }
        System.out.println("finished check-styles");
    }

    private Style readOneStyle(String name, boolean performChecks) {
        this.searchedStyleName = name;
        StyleImpl style = null;
        try {
            style = new StyleImpl(this.styleFile, name, new EnhancedProperties(), performChecks);
        }
        catch (SyntaxException e) {
            Logger.defaultLogger.error((Object)("Error in style: " + e.getMessage()));
        }
        catch (FileNotFoundException e) {
            log.debug("could not find style", name);
            try {
                this.searchedStyleName = new File(this.styleFile).getName();
                style = new StyleImpl(this.styleFile, null, new EnhancedProperties(), performChecks);
            }
            catch (SyntaxException e1) {
                Logger.defaultLogger.error((Object)("Error in style: " + e1.getMessage()));
            }
            catch (FileNotFoundException e1) {
                log.debug("could not find style", this.styleFile);
            }
        }
        return style;
    }

    private static String getLang() {
        return "en";
    }

    private void addCombiner(String name, Combiner combiner) {
        this.combinerMap.put(name, combiner);
        this.combiners.add(combiner);
    }

    @Override
    public void endOptions(CommandArgs args) {
        this.fileOptions(args);
        int taskCount = this.futures.size();
        if (taskCount > 0) {
            Logger.defaultLogger.write("Mkgmap version " + Version.VERSION);
            Logger.defaultLogger.write("Time started: " + StartTime);
        }
        log.info((Object)"Start tile processors");
        int threadCount = this.maxJobs;
        Runtime runtime = Runtime.getRuntime();
        if (this.threadPool == null) {
            if (threadCount == 0) {
                threadCount = 1;
                if (taskCount > 2) {
                    log.info((Object)("Max Memory: " + runtime.maxMemory()));
                    this.futures.get(0).run();
                    long maxMemory = 0L;
                    for (MemoryPoolMXBean mxBean : ManagementFactory.getMemoryPoolMXBeans()) {
                        if (mxBean.getType() != MemoryType.HEAP) continue;
                        MemoryUsage memoryUsage = mxBean.getPeakUsage();
                        log.info((Object)("Max: " + memoryUsage.getMax()));
                        log.info((Object)("Used: " + memoryUsage.getUsed()));
                        if (memoryUsage.getMax() <= maxMemory || memoryUsage.getUsed() == 0L) continue;
                        maxMemory = memoryUsage.getMax();
                        threadCount = (int)(memoryUsage.getMax() / memoryUsage.getUsed());
                    }
                    threadCount = Math.max(threadCount, 1);
                    threadCount = Math.min(threadCount, runtime.availableProcessors());
                    Logger.defaultLogger.warn((Object)("Setting max-jobs to " + threadCount));
                }
            }
            log.info((Object)("Creating thread pool with " + threadCount + " threads"));
            this.threadPool = Executors.newFixedThreadPool(threadCount);
        }
        for (FilenameTask task : this.futures) {
            this.threadPool.execute(task);
        }
        ArrayList<FilenameTask> filenames = new ArrayList<FilenameTask>();
        int numMapFailedExceptions = 0;
        if (this.threadPool != null) {
            this.threadPool.shutdown();
            while (!this.futures.isEmpty()) {
                try {
                    try {
                        if (this.futures.get(0).isDone()) {
                            FilenameTask future = this.futures.remove(0);
                            future.setFilename((String)future.get());
                            filenames.add(future);
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (ExecutionException e) {
                        Iterator<Combiner> cause = e.getCause();
                        if (cause instanceof Exception) {
                            throw (Exception)((Object)cause);
                        }
                        if (cause instanceof Error) {
                            throw (Error)((Object)cause);
                        }
                        throw e;
                    }
                }
                catch (OutOfMemoryError | ExitException e) {
                    throw e;
                }
                catch (MapFailedException mfe) {
                    ++numMapFailedExceptions;
                    this.setProgramRC(-1);
                    if (args.getProperties().getProperty("keep-going", false)) continue;
                    throw new ExitException("Exiting - if you want to carry on regardless, use the --keep-going option");
                }
                catch (Exception e) {
                    Logger.defaultLogger.error((Object)"Unexpected error", e);
                    throw new ExitException("Exiting due to unexpected error");
                }
            }
        }
        Logger.defaultLogger.write("Number of MapFailedExceptions: " + numMapFailedExceptions);
        if (taskCount > threadCount + 1 && this.maxJobs == 0 && threadCount < runtime.availableProcessors()) {
            Logger.defaultLogger.warn((Object)("To reduce the run time, consider increasing the amnount of memory available for use by mkgmap by using the Java -Xmx flag to set the memory to more than " + 100L * (1L + runtime.maxMemory() * (long)runtime.availableProcessors() / (long)(threadCount * 1024 * 1024 * 100)) + " MB, providing this is less than the amount of physical memory installed."));
        }
        if (this.combiners.isEmpty()) {
            return;
        }
        boolean hasFiles = false;
        for (FilenameTask filenameTask : filenames) {
            if (filenameTask == null || filenameTask.isCancelled() || filenameTask.getFilename() == null) {
                if (args.getProperties().getProperty("keep-going", false)) continue;
                throw new ExitException("Exiting - if you want to carry on regardless, use the --keep-going option");
            }
            hasFiles = true;
        }
        if (!hasFiles) {
            log.info((Object)"nothing to do for combiners.");
            return;
        }
        log.info((Object)"Combining maps");
        args.setSort(this.getSort(args));
        for (Combiner combiner : this.combiners) {
            combiner.init(args);
        }
        filenames.removeIf(f -> f == null || f.getFilename() == null || f.isCancelled());
        HashMap<String, Integer> nameToHex = new HashMap<String, Integer>();
        for (FilenameTask f2 : filenames) {
            int hex;
            if (!f2.getFilename().endsWith(".img")) continue;
            this.sourceMap.put(f2.getFilename(), f2.getSource());
            try {
                hex = FileInfo.getFileInfo(f2.getFilename()).getHexname();
            }
            catch (FileNotFoundException ignored) {
                hex = 0;
            }
            nameToHex.put(f2.getFilename(), hex);
        }
        filenames.sort((o1, o2) -> {
            if (!o1.getFilename().endsWith(".img") || !o2.getFilename().endsWith(".img")) {
                return o1.getFilename().compareTo(o2.getFilename());
            }
            return Integer.compare(nameToHex.getOrDefault(o1.getFilename(), 0), nameToHex.getOrDefault(o2.getFilename(), 0));
        });
        HashSet<String> hashSet = new HashSet<String>();
        if (this.tdbBuilderAdded) {
            for (FilenameTask file : filenames) {
                try {
                    String fileName = file.getFilename();
                    if (!fileName.endsWith(".img")) continue;
                    File f1 = new File(fileName);
                    fileName = new File(f1.getParent(), OverviewBuilder.getOverviewImgName(fileName)).getAbsolutePath();
                    log.info((Object)("  " + fileName));
                    FileInfo fileInfo = FileInfo.getFileInfo(fileName);
                    fileInfo.setArgs(file.getArgs());
                    hashSet.add(file.getFilename());
                    for (Combiner c : this.combiners) {
                        if (!(c instanceof OverviewBuilder)) continue;
                        c.onMapEnd(fileInfo);
                    }
                }
                catch (FileNotFoundException fileName) {
                }
            }
        }
        for (FilenameTask file : filenames) {
            try {
                log.info((Object)("  " + file));
                FileInfo fileInfo = FileInfo.getFileInfo(file.getFilename());
                fileInfo.setArgs(file.getArgs());
                for (Combiner c : this.combiners) {
                    if (c instanceof OverviewBuilder && hashSet.contains(file.getFilename())) continue;
                    c.onMapEnd(fileInfo);
                }
                fileInfo.closeMapReader();
            }
            catch (FileNotFoundException e) {
                throw new MapFailedException("could not open file " + e.getMessage());
            }
        }
        for (Combiner c : this.combiners) {
            c.onFinish();
        }
        if (this.tdbBuilderAdded && args.getProperties().getProperty("remove-ovm-work-files", false)) {
            for (String fName : hashSet) {
                String ovmFile = OverviewBuilder.getOverviewImgName(fName);
                File f3 = new File(args.getOutputDir(), ovmFile);
                if (!f3.exists() || !f3.isFile()) continue;
                try {
                    Files.delete(f3.toPath());
                    log.info((Object)("removed " + f3));
                }
                catch (IOException e) {
                    log.warn((Object)("removing " + f3 + "failed with " + e.getMessage()));
                }
            }
        }
    }

    private void fileOptions(CommandArgs args) {
        boolean indexOpt = args.exists("index");
        boolean gmapsuppOpt = args.exists("gmapsupp");
        boolean tdbOpt = args.exists("tdbfile");
        boolean gmapiOpt = args.exists("gmapi") || args.exists("gmapi-minimal");
        boolean nsisOpt = args.exists("nsis");
        if (args.exists("gmapi") && args.exists("gmapi-minimal")) {
            throw new ExitException("Options --gmapi and --gmapi-minimal are mutually exclusive");
        }
        for (String opt : Arrays.asList("gmapi", "nsis", "gmapi-minimal")) {
            if (this.createTdbFiles || !args.exists(opt)) continue;
            throw new ExitException("Options --" + opt + " and --no-tdbfiles are mutually exclusive");
        }
        if (tdbOpt || this.createTdbFiles) {
            this.addTdbBuilder();
        }
        if (gmapsuppOpt) {
            GmapsuppBuilder gmapBuilder = new GmapsuppBuilder();
            gmapBuilder.setCreateIndex(indexOpt);
            this.addCombiner("gmapsupp", gmapBuilder);
        }
        if (indexOpt && (tdbOpt || !gmapsuppOpt || gmapiOpt || nsisOpt)) {
            this.addCombiner("mdr", new MdrBuilder());
            this.addCombiner("mdx", new MdxBuilder());
        }
        if (gmapiOpt) {
            this.addCombiner("gmapi", new GmapiBuilder(this.combinerMap, this.sourceMap));
        }
        if (nsisOpt) {
            this.addCombiner("nsis", new NsisBuilder(this.combinerMap));
        }
    }

    private static String extractExtension(String filename) {
        String[] parts = filename.toLowerCase(Locale.ENGLISH).split("\\.");
        List<String> ignore = Arrays.asList("gz", "bz2", "bz");
        for (int i = parts.length - 1; i > 0; --i) {
            String ext = parts[i];
            if (ignore.contains(ext)) continue;
            return ext;
        }
        return "";
    }

    public Sort getSort(CommandArgs args) {
        return SrtTextReader.sortForCodepage(args.getCodePage());
    }

    private static class FilenameTask
    extends FutureTask<String> {
        private CommandArgs args;
        private String filename;
        private String source;

        private FilenameTask(Callable<String> callable) {
            super(callable);
        }

        public void setArgs(CommandArgs args) {
            this.args = args;
        }

        public CommandArgs getArgs() {
            return this.args;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        @Override
        public String toString() {
            return this.source + " -> " + this.filename;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }
    }
}

