/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;

public class NsisBuilder
implements Combiner {
    private String baseFilename;
    private String nsisFilename;
    private String licenseFilename;
    private String outputDir;
    private String familyName;
    private String id;
    private int productId;
    private final boolean hasIndex;
    private boolean hasTyp;
    private final List<String> mapList = new ArrayList<String>();
    private String typName;

    public NsisBuilder(Map<String, Combiner> combinerMap) {
        this.hasIndex = combinerMap.containsKey("mdx");
    }

    @Override
    public void init(CommandArgs args) {
        int familyId = args.get("family-id", 6324);
        this.productId = args.get("product-id", 1);
        this.baseFilename = args.get("overview-mapname", "osmmap");
        this.familyName = args.get("family-name", "OSM map");
        String tmpId = Integer.toHexString(0x10000 | familyId);
        this.id = tmpId.substring(3, 5) + tmpId.substring(1, 3);
        this.nsisFilename = this.baseFilename + ".nsi";
        this.licenseFilename = this.baseFilename + "_license.txt";
        this.outputDir = args.getOutputDir();
    }

    @Override
    public void onMapEnd(FileInfo info) {
        switch (info.getKind()) {
            case IMG_KIND: {
                this.mapList.add(info.getMapname());
                break;
            }
            case TYP_KIND: {
                this.hasTyp = true;
                File typFile = new File(info.getFilename());
                this.typName = typFile.getName();
                break;
            }
        }
    }

    @Override
    public void onFinish() {
        this.writeNsisFile();
        this.writeLicenceFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNsisFile() {
        InputStream inStream;
        block36: {
            try {
                inStream = new FileInputStream("resources/installer_template.nsi");
            }
            catch (Exception ex) {
                inStream = this.getClass().getResourceAsStream("/installer/installer_template.nsi");
                if (inStream != null) break block36;
                Logger.defaultLogger.error((Object)"Could not find the installer template.");
                return;
            }
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
             PrintWriter pw = new PrintWriter(new FileWriter(Utils.joinPath(this.outputDir, this.nsisFilename)));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                if (strLine.contains("INSERT_DEFINES_HERE")) {
                    this.writeDefines(pw);
                    continue;
                }
                if (strLine.contains("INSERT_REGBIN_HERE")) {
                    this.writeRegBin(pw);
                    continue;
                }
                if (strLine.contains("INSERT_ADDED_FILES_HERE")) {
                    this.writeAddedFiles(pw);
                    continue;
                }
                if (strLine.contains("INSERT_REMOVED_FILES_HERE")) {
                    this.writeRemovedFiles(pw);
                    continue;
                }
                pw.format(Locale.ROOT, "%s\n", strLine);
            }
        }
        catch (IOException e) {
            Logger.defaultLogger.error((Object)"Could not write NSIS file");
        }
        finally {
            Utils.closeFile(inStream);
        }
    }

    private void writeDefines(PrintWriter pw) {
        pw.format(Locale.ROOT, "!define DEFAULT_DIR \"C:\\Garmin\\Maps\\%s\"\n", this.familyName);
        pw.format(Locale.ROOT, "!define INSTALLER_DESCRIPTION \"%s\"\n", this.familyName);
        pw.format(Locale.ROOT, "!define INSTALLER_NAME \"%s\"\n", this.familyName);
        pw.format(Locale.ROOT, "!define MAPNAME \"%s\"\n", this.baseFilename);
        pw.format(Locale.ROOT, "!define PRODUCT_ID \"%s\"\n", this.productId);
        pw.format(Locale.ROOT, "!define REG_KEY \"%s\"\n", this.familyName);
        if (this.hasIndex) {
            pw.append("!define INDEX\n");
        }
        if (this.hasTyp) {
            pw.format(Locale.ROOT, "!define TYPNAME \"%s\"\n", this.typName);
        }
    }

    private void writeRegBin(PrintWriter pw) {
        pw.format(Locale.ROOT, "  WriteRegBin HKLM \"SOFTWARE\\Garmin\\MapSource\\Families\\${REG_KEY}\" \"ID\" %s\n", this.id);
    }

    private void writeAddedFiles(PrintWriter pw) {
        pw.append("  File \"${MAPNAME}.img\"\n");
        if (this.hasIndex) {
            pw.append("  File \"${MAPNAME}_mdr.img\"\n");
            pw.append("  File \"${MAPNAME}.mdx\"\n");
        }
        if (this.hasTyp) {
            pw.format(Locale.ROOT, "  File \"%s\"\n", this.typName);
        }
        pw.append("  File \"${MAPNAME}.tdb\"\n");
        for (String file : this.mapList) {
            pw.format(Locale.ROOT, "  File \"%s.img\"\n", file);
        }
    }

    private void writeRemovedFiles(PrintWriter pw) {
        pw.append("  Delete \"$INSTDIR\\${MAPNAME}.img\"\n");
        if (this.hasIndex) {
            pw.append("  Delete \"$INSTDIR\\${MAPNAME}_mdr.img\"\n");
            pw.append("  Delete \"$INSTDIR\\${MAPNAME}.mdx\"\n");
        }
        if (this.hasTyp) {
            pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\%s\"\n", this.typName);
        }
        pw.append("  Delete \"$INSTDIR\\${MAPNAME}.tdb\"\n");
        for (String file : this.mapList) {
            pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\%s.img\"\n", file);
        }
        pw.append("  Delete \"$INSTDIR\\Uninstall.exe\"\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLicenceFile() {
        InputStream inStream;
        block32: {
            try {
                inStream = new FileInputStream("resources/license_template.txt");
            }
            catch (Exception ex) {
                inStream = this.getClass().getResourceAsStream("/installer/license_template.txt");
                if (inStream != null) break block32;
                Logger.defaultLogger.error((Object)"Could not find the license template.");
                return;
            }
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
             PrintWriter pw = new PrintWriter(new FileWriter(Utils.joinPath(this.outputDir, this.licenseFilename)));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                pw.format(Locale.ROOT, "%s\n", strLine);
            }
            pw.format(Locale.ROOT, "Map created with mkgmap-r%s\n", Version.VERSION);
        }
        catch (IOException e) {
            Logger.defaultLogger.error((Object)"Could not write license file");
        }
        finally {
            Utils.closeFile(inStream);
        }
    }
}

