/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.srt.CodePosition;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.srt.SrtSortKey;

public class Sort {
    private static final byte[] ZERO_KEY = new byte[4];
    private static final Integer NO_ORDER = 0;
    private int codepage;
    private int id1;
    private int id2;
    private String description;
    private Charset charset;
    private Page[] pages = new Page[256];
    private final List<CodePosition> expansions = new ArrayList<CodePosition>();
    private int maxExpSize = 1;
    private CharsetEncoder encoder;
    private boolean multi;
    private int maxPage;
    private int headerLen = 29;
    private int header3Len = -1;
    private int maxPrimary = 0;

    public Sort() {
        this.pages[0] = new Page();
    }

    public void add(int ch, int primary, int secondary, int tertiary, int flags) {
        this.ensurePage(ch >>> 8);
        if (this.getPrimary(ch) != 0) {
            throw new ExitException(String.format("Repeated primary index 0x%x", ch & 0xFF));
        }
        if (primary > this.maxPrimary) {
            this.maxPrimary = primary;
        }
        this.setPrimary(ch, primary);
        this.setSecondary(ch, secondary);
        this.setTertiary(ch, tertiary);
        this.setFlags(ch, flags);
        int numExp = flags >> 4 & 0xF;
        if (numExp + 1 > this.maxExpSize) {
            this.maxExpSize = numExp + 1;
        }
    }

    public char[] encode(String s) {
        char[] chars = null;
        try {
            if (this.isMulti()) {
                chars = s.toCharArray();
            } else {
                ByteBuffer out = this.encoder.encode(CharBuffer.wrap(s));
                byte[] bval = out.array();
                chars = new char[bval.length];
                for (int i = 0; i < bval.length; ++i) {
                    chars[i] = (char)(bval[i] & 0xFF);
                }
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return chars;
    }

    public char[] getPrefix(String name, int prefixLen) {
        char[] chars = this.encode(name);
        return Arrays.copyOf(chars, prefixLen);
    }

    public void finish() {
        int i;
        int maxSecondary = 0;
        int maxTertiary = 0;
        for (Page p : this.pages) {
            if (p == null) continue;
            for (i = 0; i < 256; ++i) {
                if ((p.flags[i] >>> 4 & 0xF) != 0 || p.getPrimary(i) == 0) continue;
                int second = p.getSecondary(i);
                maxSecondary = Math.max(maxSecondary, second);
                if (second == 0) continue;
                maxTertiary = Math.max(maxTertiary, p.getTertiary(i));
            }
        }
        for (Page p : this.pages) {
            if (p == null) continue;
            for (i = 0; i < 256; ++i) {
                if ((p.flags[i] >>> 4 & 0xF) != 0 || p.getPrimary(i) != 0) continue;
                if (p.getSecondary(i) == 0) {
                    if (p.getTertiary(i) == 0) continue;
                    p.setTertiary(i, p.getTertiary(i) + maxTertiary);
                    continue;
                }
                p.setSecondary(i, p.getSecondary(i) + maxSecondary);
            }
        }
    }

    public char[] getSortPositions() {
        char[] tab = new char[256];
        for (int i = 1; i < 256; ++i) {
            tab[i] = (char)(this.getPrimary(i) << 8 & 0xFF00 | this.getSecondary(i) << 4 & 0xF0 | this.getTertiary(i) & 0xF);
        }
        return tab;
    }

    public <T> SortKey<T> createSortKey(T object, String s, int second, Map<String, byte[]> cache) {
        byte[] key;
        if (s.length() == 0) {
            return new SrtSortKey<T>(object, ZERO_KEY, second);
        }
        if (cache != null && (key = cache.get(s)) != null) {
            return new SrtSortKey<T>(object, key, second);
        }
        try {
            char[] chars;
            if (this.isMulti()) {
                chars = s.toCharArray();
            } else {
                ByteBuffer out = this.encoder.encode(CharBuffer.wrap(s));
                byte[] bval = out.array();
                chars = new char[bval.length];
                for (int i = 0; i < bval.length; ++i) {
                    chars[i] = (char)(bval[i] & 0xFF);
                }
            }
            key = this.makeKey(chars);
            if (cache != null) {
                cache.put(s, key);
            }
            return new SrtSortKey<T>(object, key, second);
        }
        catch (CharacterCodingException e) {
            return new SrtSortKey<T>(object, ZERO_KEY);
        }
    }

    public <T> SortKey<T> createSortKey(T object, Label label, int second, Map<Label, byte[]> cache) {
        byte[] key;
        if (label.getLength() == 0) {
            return new SrtSortKey<T>(object, ZERO_KEY, second);
        }
        if (cache != null && (key = cache.get(label)) != null) {
            return new SrtSortKey<T>(object, key, second);
        }
        char[] encText = label.getEncText();
        key = this.makeKey(encText);
        if (cache != null) {
            cache.put(label, key);
        }
        return new SrtSortKey<T>(object, key, second);
    }

    public <T> SortKey<T> createSortKeyPartial(T object, Label label, int second, Map<Label, byte[]> cache) {
        byte[] key;
        if (label.getLength() == 0) {
            return new SrtSortKey<T>(object, ZERO_KEY, second);
        }
        if (cache != null && (key = cache.get(label)) != null) {
            return new SrtSortKey<T>(object, key, second);
        }
        char[] encText = label.getEncText();
        int prefix = -1;
        for (int i = 0; i < encText.length; ++i) {
            char c = encText[i];
            if (c != '\u001e' && c != '\u001b') continue;
            prefix = i;
            break;
        }
        int suffix = -1;
        for (int i = 0; i < encText.length; ++i) {
            char c = encText[i];
            if (c != '\u001f' && c != '\u001c') continue;
            suffix = i;
            break;
        }
        if (prefix > 0 || suffix > 0) {
            int partLen = prefix > 0 && suffix > 0 ? suffix - prefix - 1 : (prefix > 0 ? encText.length - (prefix + 1) : suffix);
            char[] newEncText = new char[partLen];
            System.arraycopy(encText, prefix + 1, newEncText, 0, partLen);
            encText = newEncText;
        }
        key = this.makeKey(encText);
        if (cache != null) {
            cache.put(label, key);
        }
        return new SrtSortKey<T>(object, key, second);
    }

    public <T> SortKey<T> createSortKey(T object, String s, int second) {
        return this.createSortKey(object, s, second, null);
    }

    public <T> SortKey<T> createSortKey(T object, String s) {
        return this.createSortKey(object, s, 0, null);
    }

    public <T> SortKey<T> createSortKey(T object, Label label) {
        return this.createSortKey(object, label, 0, null);
    }

    public <T> SortKey<T> createSortKey(T object, Label label, int second) {
        return this.createSortKey(object, label, second, null);
    }

    private byte[] makeKey(char[] chars) {
        int needed;
        byte[] key = new byte[(chars.length + 1 + 2) * 4];
        try {
            needed = this.fillCompleteKey(chars, key);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            key = new byte[(chars.length + 1) * 4 * this.maxExpSize];
            needed = this.fillCompleteKey(chars, key);
        }
        int neededBytes = needed;
        int padding2 = 8 - (needed & 7);
        if (padding2 != 8) {
            neededBytes += padding2;
        }
        if (neededBytes < key.length) {
            key = Arrays.copyOf(key, needed);
        }
        return key;
    }

    private int fillCompleteKey(char[] bVal, byte[] key) {
        int start = this.fillKey(0, bVal, key, 0);
        start = this.fillKey(1, bVal, key, start);
        return this.fillKey(2, bVal, key, start);
    }

    private static int writeSort(int strength, int pos, byte[] outKey, int start) {
        if (strength == 0) {
            outKey[start++] = (byte)(pos >> 8 & 0xFF);
        }
        outKey[start++] = (byte)(pos & 0xFF);
        return start;
    }

    private int fillKey(int type, char[] input, byte[] outKey, int start) {
        int index = start;
        for (char c : input) {
            if (!this.hasPage(c >>> 8)) {
                if (!this.isMulti() || type != 0) continue;
                index = Sort.writeSort(type, c + this.maxPrimary, outKey, index);
                continue;
            }
            int exp = this.getFlags(c) >> 4 & 0xF;
            if (exp == 0) {
                index = this.writePos(type, c, outKey, index);
                continue;
            }
            int idx = this.getPrimary(c);
            for (int i = idx - 1; i < idx + exp; ++i) {
                int pos = this.expansions.get(i).getPosition(type);
                index = Sort.writeSort(type, pos, outKey, index);
            }
        }
        if (type == 0) {
            outKey[index++] = 0;
        }
        outKey[index++] = 0;
        return index;
    }

    public int getPrimary(int ch) {
        return this.pages[ch >>> 8].getPrimary(ch);
    }

    public int getSecondary(int ch) {
        return this.pages[ch >>> 8].getSecondary(ch);
    }

    public int getTertiary(int ch) {
        return this.pages[ch >>> 8].getTertiary(ch);
    }

    public byte getFlags(int ch) {
        assert (ch >= 0);
        return this.pages[ch >>> 8].flags[ch & 0xFF];
    }

    public int getCodepage() {
        return this.codepage;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getId1() {
        return this.id1;
    }

    public void setId1(int id1) {
        this.id1 = id1;
    }

    public int getId2() {
        return this.id2;
    }

    public void setId2(int id2) {
        this.id2 = id2 & Short.MAX_VALUE;
    }

    public int getSortOrderId() {
        return (this.id2 << 16) + (this.id1 & 0xFFFF);
    }

    public void setSortOrderId(int id) {
        this.id1 = id & 0xFFFF;
        this.id2 = id >>> 16 & Short.MAX_VALUE;
    }

    public void setCodepage(int codepage) {
        this.codepage = codepage;
        this.charset = Sort.charsetFromCodepage(codepage);
        this.encoder = this.charset.newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CodePosition getExpansion(int val) {
        return this.expansions.get(val - 1);
    }

    public Collator getCollator() {
        return new SrtCollator(this.codepage);
    }

    public int getExpansionSize() {
        return this.expansions.size();
    }

    public String toString() {
        return String.format("sort cp=%d order=%08x", this.codepage, this.getSortOrderId());
    }

    private void setPrimary(int ch, int val) {
        this.pages[ch >>> 8].setPrimary(ch, val);
    }

    private void setSecondary(int ch, int val) {
        this.pages[ch >>> 8].setSecondary(ch, val);
    }

    private void setTertiary(int ch, int val) {
        this.pages[ch >>> 8].setTertiary(ch, val);
    }

    private void setFlags(int ch, int val) {
        ((Page)this.pages[ch >>> 8]).flags[ch & 0xFF] = (byte)val;
    }

    public static Charset charsetFromCodepage(int codepage) {
        Charset charset;
        switch (codepage) {
            case 0: {
                charset = StandardCharsets.US_ASCII;
                break;
            }
            case 65001: {
                charset = StandardCharsets.UTF_8;
                break;
            }
            case 932: {
                charset = Charset.forName("ms932");
                break;
            }
            default: {
                charset = Charset.forName("cp" + codepage);
            }
        }
        return charset;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public int getPos(int type, int ch) {
        return this.pages[ch >>> 8].getPos(type, ch);
    }

    public int writePos(int type, int ch, byte[] outkey, int start) {
        return this.pages[ch >>> 8].writePos(type, ch, outkey, start);
    }

    private void ensurePage(int n) {
        assert (n == 0 || this.isMulti());
        if (n > this.pages.length) {
            this.pages = Arrays.copyOf(this.pages, n + 1);
        }
        if (this.pages[n] == null) {
            this.pages[n] = new Page();
            if (n > this.maxPage) {
                this.maxPage = n;
            }
        }
    }

    public void setMaxPage(int n) {
        this.pages = Arrays.copyOf(this.pages, n + 1);
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public boolean hasPage(int p) {
        return this.pages[p] != null;
    }

    public void setExpansions(List<CodePosition> expansionList) {
        this.expansions.clear();
        this.expansions.addAll(expansionList);
    }

    public int getHeaderLen() {
        return this.headerLen;
    }

    public void setHeaderLen(int headerLen) {
        this.headerLen = headerLen;
    }

    public int getHeader3Len() {
        if (this.header3Len < 0) {
            this.header3Len = this.isMulti() ? 92 : 52;
        }
        return this.header3Len;
    }

    public void setHeader3Len(int header3Len) {
        this.header3Len = header3Len;
    }

    public class SrtCollator
    extends Collator {
        private final int codepage;

        private SrtCollator(int codepage) {
            this.codepage = codepage;
        }

        @Override
        public int compare(String source, String target) {
            char[] chars2;
            char[] chars1;
            if (source == target) {
                return 0;
            }
            if (Sort.this.isMulti()) {
                chars1 = source.toCharArray();
                chars2 = target.toCharArray();
            } else {
                CharBuffer in1 = CharBuffer.wrap(source);
                CharBuffer in2 = CharBuffer.wrap(target);
                try {
                    int i;
                    byte[] bytes1 = Sort.this.encoder.encode(in1).array();
                    byte[] bytes2 = Sort.this.encoder.encode(in2).array();
                    chars1 = new char[bytes1.length];
                    for (i = 0; i < bytes1.length; ++i) {
                        chars1[i] = (char)(bytes1[i] & 0xFF);
                    }
                    chars2 = new char[bytes2.length];
                    for (i = 0; i < bytes2.length; ++i) {
                        chars2[i] = (char)(bytes2[i] & 0xFF);
                    }
                }
                catch (CharacterCodingException e) {
                    throw new ExitException("character encoding failed unexpectedly", e);
                }
            }
            int strength = this.getStrength();
            int res = this.compareOneStrength(chars1, chars2, 0);
            if (res == 0 && strength != 0 && (res = this.compareOneStrength(chars1, chars2, 1)) == 0 && strength != 1) {
                res = this.compareOneStrength(chars1, chars2, 2);
            }
            return res;
        }

        public int compareOneStrength(char[] char1, char[] char2, int type) {
            PositionIterator it1 = new PositionIterator(char1, type);
            PositionIterator it2 = new PositionIterator(char2, type);
            while (it1.hasNext() || it2.hasNext()) {
                int p2;
                int p1 = it1.next();
                if (p1 < (p2 = it2.next())) {
                    return -1;
                }
                if (p1 <= p2) continue;
                return 1;
            }
            return 0;
        }

        public int compareOneStrengthWithLength(char[] char1, char[] char2, int type, int len) {
            PositionIterator it1 = new PositionIterator(char1, type);
            PositionIterator it2 = new PositionIterator(char2, type);
            int todo = len;
            while (it1.hasNext() || it2.hasNext()) {
                int p1 = it1.next();
                int p2 = it2.next();
                if (--todo < 0) {
                    return 0;
                }
                if (p1 < p2) {
                    return -1;
                }
                if (p1 <= p2) continue;
                return 1;
            }
            return 0;
        }

        @Override
        public CollationKey getCollationKey(String source) {
            throw new UnsupportedOperationException("use Sort.createSortKey() instead");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SrtCollator that = (SrtCollator)o;
            return this.codepage == that.codepage;
        }

        @Override
        public int hashCode() {
            return this.codepage;
        }

        class PositionIterator {
            private final char[] chars;
            private final int len;
            private final int type;
            private int pos;
            private int expStart;
            private int expEnd;
            private int expPos;

            PositionIterator(char[] chars, int type) {
                this.chars = chars;
                this.len = chars.length;
                this.type = type;
            }

            public boolean hasNext() {
                return this.pos < this.len || this.expPos != 0;
            }

            public int next() {
                int next;
                if (this.expPos == 0) {
                    do {
                        char c;
                        if (this.pos >= this.len) {
                            next = NO_ORDER;
                            break;
                        }
                        if (!Sort.this.hasPage((c = this.chars[this.pos++]) >>> 8)) {
                            if (Sort.this.isMulti() && this.type == 0) {
                                return c + Sort.this.maxPrimary & 0xFFFF;
                            }
                            next = 0;
                            continue;
                        }
                        int nExpand = Sort.this.getFlags(c) >> 4 & 0xF;
                        if (nExpand > 0) {
                            this.expStart = Sort.this.getPrimary(c) - 1;
                            this.expEnd = this.expStart + nExpand;
                            this.expPos = this.expStart;
                            next = ((CodePosition)Sort.this.expansions.get(this.expPos)).getPosition(this.type);
                            if (++this.expPos <= this.expEnd) continue;
                            this.expPos = 0;
                            continue;
                        }
                        next = Sort.this.getPos(this.type, c);
                    } while (next == 0);
                } else {
                    next = ((CodePosition)Sort.this.expansions.get(this.expPos)).getPosition(this.type);
                    if (++this.expPos > this.expEnd) {
                        this.expPos = 0;
                    }
                }
                return next;
            }
        }
    }

    private static class Page {
        private final char[] primary = new char[256];
        private final byte[] secondary = new byte[256];
        private final byte[] tertiary = new byte[256];
        private final byte[] flags = new byte[256];

        private Page() {
        }

        int getPrimary(int ch) {
            return this.primary[ch & 0xFF];
        }

        void setPrimary(int ch, int val) {
            this.primary[ch & 0xFF] = (char)val;
        }

        int getSecondary(int ch) {
            return this.secondary[ch & 0xFF] & 0xFF;
        }

        void setSecondary(int ch, int val) {
            this.secondary[ch & 0xFF] = (byte)val;
        }

        int getTertiary(int ch) {
            return this.tertiary[ch & 0xFF] & 0xFF;
        }

        void setTertiary(int ch, int val) {
            this.tertiary[ch & 0xFF] = (byte)val;
        }

        public int getPos(int type, int ch) {
            switch (type) {
                case 0: {
                    return this.getPrimary(ch);
                }
                case 1: {
                    return this.getSecondary(ch);
                }
                case 2: {
                    return this.getTertiary(ch);
                }
            }
            assert (false) : "bad collation type passed";
            return 0;
        }

        public int writePos(int strength, int ch, byte[] outKey, int start) {
            int pos = this.getPos(strength, ch);
            if (pos != 0) {
                start = Sort.writeSort(strength, pos, outKey, start);
            }
            return start;
        }
    }
}

