/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class PlacesHeader {
    private static final char COUNTRY_REC_LEN = '\u0003';
    private static final char REGION_REC_LEN = '\u0005';
    private static final char CITY_REC_LEN = '\u0005';
    private static final char POI_INDEX_REC_LEN = '\u0004';
    private static final char POI_TYPE_INDEX_REC_LEN = '\u0004';
    private static final char ZIP_REC_LEN = '\u0003';
    private static final char HIGHWAY_REC_LEN = '\u0006';
    private static final char EXIT_REC_LEN = '\u0005';
    private static final char HIGHWAYDATA_REC_LEN = '\u0003';
    private final Section country = new Section(3);
    private final Section region = new Section(this.country, 5);
    private final Section city = new Section(this.region, 5);
    private final Section poiIndex = new Section(this.city, 4);
    private final Section poiProperties = new Section(this.poiIndex);
    private final Section poiTypeIndex = new Section(this.poiProperties, 4);
    private final Section zip = new Section(this.poiTypeIndex, 3);
    private final Section highway = new Section(this.zip, 6);
    private final Section exitFacility = new Section(this.highway, 5);
    private final Section highwayData = new Section(this.exitFacility, 3);
    private int POIGlobalFlags;

    void setPOIGlobalFlags(int flags) {
        this.POIGlobalFlags = flags;
    }

    int getPOIGlobalFlags() {
        return this.POIGlobalFlags;
    }

    void writeFileHeader(ImgFileWriter writer) {
        writer.put4(this.country.getPosition());
        writer.put4(this.country.getSize());
        writer.put2u(this.country.getItemSize());
        writer.put4(0);
        writer.put4(this.region.getPosition());
        writer.put4(this.region.getSize());
        writer.put2u(this.region.getItemSize());
        writer.put4(0);
        writer.put4(this.city.getPosition());
        writer.put4(this.city.getSize());
        writer.put2u(this.city.getItemSize());
        writer.put4(0);
        writer.put4(this.poiIndex.getPosition());
        writer.put4(this.poiIndex.getSize());
        writer.put2u(this.poiIndex.getItemSize());
        writer.put4(0);
        writer.put4(this.poiProperties.getPosition());
        writer.put4(this.poiProperties.getSize());
        writer.put1u(0);
        writer.put1u(this.POIGlobalFlags);
        writer.put2u(0);
        writer.put1u(0);
        writer.put4(this.poiTypeIndex.getPosition());
        writer.put4(this.poiTypeIndex.getSize());
        writer.put2u(this.poiTypeIndex.getItemSize());
        writer.put4(0);
        writer.put4(this.zip.getPosition());
        writer.put4(this.zip.getSize());
        writer.put2u(this.zip.getItemSize());
        writer.put4(0);
        writer.put4(this.highway.getPosition());
        writer.put4(this.highway.getSize());
        writer.put2u(this.highway.getItemSize());
        writer.put4(0);
        writer.put4(this.exitFacility.getPosition());
        writer.put4(this.exitFacility.getSize());
        writer.put2u(this.exitFacility.getItemSize());
        writer.put4(0);
        writer.put4(this.highwayData.getPosition());
        writer.put4(this.highwayData.getSize());
        writer.put2u(this.highwayData.getItemSize());
        writer.put4(0);
    }

    void readFileHeader(ImgFileReader reader) {
        reader.position((long)reader.getGMPOffset() + 31L);
        this.country.readSectionInfo(reader, true, true);
        this.region.readSectionInfo(reader, true, true);
        this.city.readSectionInfo(reader, true, true);
        this.poiIndex.readSectionInfo(reader, true, true);
        this.poiProperties.readSectionInfo(reader, false);
        reader.get();
        this.POIGlobalFlags = reader.get1u();
        reader.get2u();
        reader.get();
        this.poiTypeIndex.readSectionInfo(reader, true, true);
        this.zip.readSectionInfo(reader, true, true);
        this.highway.readSectionInfo(reader, true, true);
        this.exitFacility.readSectionInfo(reader, true, true);
        this.highwayData.readSectionInfo(reader, true, true);
    }

    int getLastPos() {
        return this.highwayData.getEndPos();
    }

    void setLabelEnd(int pos) {
        this.country.setPosition(pos);
    }

    void endCountries(int pos) {
        this.country.setSize(pos - this.country.getPosition());
    }

    void endRegions(int pos) {
        this.region.setSize(pos - this.region.getPosition());
    }

    void endCity(int pos) {
        this.city.setSize(pos - this.city.getPosition());
    }

    void endPOI(int pos) {
        this.poiProperties.setSize(pos - this.poiProperties.getPosition());
    }

    void endPOIIndex(int pos) {
        this.poiIndex.setSize(pos - this.poiIndex.getPosition());
    }

    void endPOITypeIndex(int pos) {
        this.poiTypeIndex.setSize(pos - this.poiTypeIndex.getPosition());
    }

    void endZip(int pos) {
        this.zip.setSize(pos - this.zip.getPosition());
    }

    void endHighway(int pos) {
        this.highway.setSize(pos - this.highway.getPosition());
    }

    void endExitFacility(int pos) {
        this.exitFacility.setSize(pos - this.exitFacility.getPosition());
    }

    void endHighwayData(int pos) {
        this.highwayData.setSize(pos - this.highwayData.getPosition());
    }

    public int getNumCities() {
        return this.city.getNumItems();
    }

    public int getNumZips() {
        return this.zip.getNumItems();
    }

    public int getPoiPropertiesStart() {
        return this.poiProperties.getPosition();
    }

    public int getPoiPropertiesEnd() {
        return this.poiProperties.getEndPos();
    }

    public Section getCitySection() {
        return this.city;
    }

    public int getNumExits() {
        return this.exitFacility.getNumItems();
    }

    public Section getCountrySection() {
        return this.country;
    }

    public Section getRegionSection() {
        return this.region;
    }

    public int getNumHighways() {
        return this.highway.getNumItems();
    }

    public Section getZipSection() {
        return this.zip;
    }
}

