/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.nio.charset.Charset;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;
import uk.me.parabola.log.Logger;

public class BaseEncoder {
    private static final Logger log = Logger.getLogger(BaseEncoder.class);
    public static final EncodedText NO_TEXT = new EncodedText(null, 0, null);
    private boolean charsetSupported = true;
    private boolean upperCase;

    protected boolean isCharsetSupported() {
        return this.charsetSupported;
    }

    protected void prepareForCharacterSet(String name) {
        if (Charset.isSupported(name)) {
            this.charsetSupported = true;
        } else {
            this.charsetSupported = false;
            log.warn((Object)("requested character set not found " + name));
        }
    }

    protected EncodedText simpleEncode(String text) {
        if (text == null) {
            return NO_TEXT;
        }
        char[] in = text.toCharArray();
        byte[] out = new byte[in.length + 1];
        int off = 0;
        for (char c : in) {
            out[off++] = (byte)(c & 0xFF);
        }
        return new EncodedText(out, out.length, in);
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }
}

