/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.DecodedText;

public class AnyCharsetDecoder
implements CharacterDecoder {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private boolean needReset;
    private final Charset charSet;

    public AnyCharsetDecoder(String charsetName) {
        this.charSet = Charset.forName(charsetName);
    }

    @Override
    public boolean addByte(int b) {
        if (b == 0) {
            this.needReset = true;
            return true;
        }
        if (this.needReset) {
            this.needReset = false;
            this.out.reset();
        }
        this.out.write(b);
        return false;
    }

    @Override
    public DecodedText getText() {
        byte[] ba = this.out.toByteArray();
        return new DecodedText(ba, this.charSet);
    }

    @Override
    public void reset() {
        this.needReset = false;
        this.out.reset();
    }
}

