/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.skin.tablerow;

import javafx.scene.Node;
import javafx.scene.control.TableRow;
import javafx.scene.control.skin.TableRowSkin;
import tornadofx.ExpanderColumn;

public final class ExpandableTableRowSkin<S>
extends TableRowSkin<S> {
    private double tableRowPrefHeight = -1.0;
    private final TableRow<S> tableRow;
    private final ExpanderColumn<S> expander;

    public ExpandableTableRowSkin(TableRow<S> tableRow, ExpanderColumn<S> expander) {
        super(tableRow);
        this.tableRow = tableRow;
        this.expander = expander;
        this.tableRow.itemProperty().addListener((observable2, oldValue, newValue) -> {
            Node expandedNode;
            if (oldValue != null && (expandedNode = expander.getExpandedNode(oldValue)) != null) {
                this.getChildren().remove((Object)expandedNode);
            }
        });
    }

    private boolean getExpanded() {
        TableRow tableRow = (TableRow)this.getSkinnable();
        Object item2 = tableRow.getItem();
        return item2 != null && (Boolean)this.expander.getCellData(((TableRow)this.getSkinnable()).getIndex()) != false;
    }

    private Node getContent() {
        Node node = this.expander.getOrCreateExpandedNode(this.tableRow);
        if (!this.getChildren().contains((Object)node)) {
            this.getChildren().add((Object)node);
        }
        return node;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.tableRowPrefHeight = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        return this.getExpanded() && this.getContent() != null ? this.tableRowPrefHeight + this.getContent().prefHeight(width) : this.tableRowPrefHeight;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.getExpanded() && this.getContent() != null) {
            this.getContent().resizeRelocate(0.0, this.tableRowPrefHeight, w, h - this.tableRowPrefHeight);
        }
    }
}

