/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.views.highlight;

import io.conduktor.views.highlight.Highlighter;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/conduktor/views/highlight/JsonHighlighter;", "Lio/conduktor/views/highlight/Highlighter;", "()V", "BOOLEAN_PATTERN", "", "BRACE_PATTERN", "BRACKET_PATTERN", "KEY_PATTERN", "NULL_PATTERN", "NUMBER_PATTERN", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "STRING_PATTERN", "logger", "Lorg/slf4j/Logger;", "getStyleClass", "matcher", "Ljava/util/regex/Matcher;", "highlight", "Lorg/fxmisc/richtext/model/StyleSpans;", "", "text", "nonHighlightedText", "textLength", "", "desktop"})
public final class JsonHighlighter
implements Highlighter {
    @NotNull
    public static final JsonHighlighter INSTANCE = new JsonHighlighter();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
    @NotNull
    private static final String BRACE_PATTERN = "(\\{|\\})";
    @NotNull
    private static final String BRACKET_PATTERN = "(\\[|\\])";
    @NotNull
    private static final String STRING_PATTERN = "\"([^\"\\\\]|\\\\.)*\"";
    @NotNull
    private static final String KEY_PATTERN = "\"([^\"\\\\]|\\\\.)*\"\\s*\\:";
    @NotNull
    private static final String NUMBER_PATTERN = "-?[0-9]+(.[0-9]+)?((e|E)?[0-9]+)?";
    @NotNull
    private static final String BOOLEAN_PATTERN = "(?i:true|false)";
    @NotNull
    private static final String NULL_PATTERN = "(?i:null)";
    private static final Pattern PATTERN = Pattern.compile("(?<KEY>\"([^\"\\\\]|\\\\.)*\"\\s*\\:)|(?<BRACE>(\\{|\\}))|(?<BRACKET>(\\[|\\]))|(?<STRING>\"([^\"\\\\]|\\\\.)*\")|(?<NUMBER>-?[0-9]+(.[0-9]+)?((e|E)?[0-9]+)?)|(?<NULL>(?i:null))|(?<BOOLEAN>(?i:true|false))");

    private JsonHighlighter() {
    }

    @NotNull
    public final StyleSpans<Collection<String>> nonHighlightedText(int textLength) {
        return StyleSpans.singleton((Object)CollectionsKt.listOf((Object)"whiteTextFill"), (int)textLength);
    }

    @Override
    @Nullable
    public StyleSpans<Collection<String>> highlight(@NotNull String text) {
        int textLength = text.length();
        return textLength < 100000 ? JsonHighlighter.highlight$doHighlight(text) : this.nonHighlightedText(textLength);
    }

    private final String getStyleClass(Matcher matcher) {
        return matcher.group("KEY") != null ? "json_key" : (matcher.group("BRACE") != null ? "json_brace" : (matcher.group("BRACKET") != null ? "json_bracket" : (matcher.group("STRING") != null ? "json_string" : (matcher.group("NUMBER") != null ? "json_number" : (matcher.group("NULL") != null ? "json_null" : (matcher.group("BOOLEAN") != null ? "json_boolean" : ""))))));
    }

    private static final StyleSpans<Collection<String>> highlight$doHighlight(String $text) {
        StyleSpans styleSpans;
        try {
            StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
            Matcher matcher = PATTERN.matcher($text);
            int previousEnd = 0;
            while (matcher.find()) {
                String styleClass = INSTANCE.getStyleClass(matcher);
                spansBuilder.add(Collections.emptyList(), matcher.start() - previousEnd);
                spansBuilder.add((Object)CollectionsKt.listOf((Object)styleClass), matcher.end() - matcher.start());
                previousEnd = matcher.end();
            }
            spansBuilder.add(Collections.emptyList(), $text.length() - previousEnd);
            styleSpans = spansBuilder.create();
        }
        catch (Exception e) {
            logger.warn("Error highlighting JSON", (Throwable)e);
            styleSpans = null;
        }
        catch (StackOverflowError e) {
            logger.warn("Ignoring Regex StackOverflow, cancelling JSON highlighting...");
            styleSpans = null;
        }
        return styleSpans;
    }
}

