/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.auth;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import io.conduktor.ExtensionsKt;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.analytics.tracking.User;
import io.conduktor.app.Conduktor;
import io.conduktor.auth.AuthConfiguration;
import io.conduktor.auth.ConduktorAuth;
import io.conduktor.auth.LoggedInUserChanged;
import io.conduktor.auth.OfflineConfig;
import io.conduktor.auth.OfflineConfigJSON;
import io.conduktor.auth.flow.AccessToken;
import io.conduktor.auth.flow.IdToken;
import io.conduktor.auth.flow.RefreshToken;
import io.conduktor.auth.flow.Tokens;
import io.conduktor.auth.http.AuthClient;
import io.conduktor.auth.offline.OfflineAuthClient;
import io.conduktor.auth.sub.SubscriptionType;
import io.conduktor.auth.user.ConduktorUser;
import io.conduktor.auth.user.IdentityOrigin;
import io.conduktor.auth.user.SubscriptionFallbackReason;
import io.conduktor.common.locale.Locales;
import io.conduktor.config.ConfigurationExtension;
import io.conduktor.utils.CryptoUtils;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.stage.Stage;
import javax.json.JsonObject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.javafx.JavaFxDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tornadofx.AsyncKt;
import tornadofx.ConfigProperties;
import tornadofx.FX;
import tornadofx.FXEvent;
import tornadofx.JsonModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 Q2\u00020\u0001:\u0001QB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020(J\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020(0-J\u0006\u0010/\u001a\u00020$J\u0006\u00100\u001a\u00020$J$\u00101\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\t0-2\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u000204H\u0002J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J\u001c\u00108\u001a\u00020(2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(0:H\u0002J\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020(0-J\u0018\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020.H\u0002J\u0006\u0010?\u001a\u00020(J$\u0010@\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\t0-2\u0006\u00103\u001a\u0002042\u0006\u00102\u001a\u00020$H\u0002J\u0006\u0010A\u001a\u00020(J\u0012\u0010B\u001a\u00020(2\b\u0010C\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010D\u001a\u00020(2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(0:H\u0002J\"\u0010F\u001a\u00020(2\u0018\u0010G\u001a\u0014\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020(0HH\u0002J\u0010\u0010J\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tH\u0002J\b\u0010K\u001a\u00020(H\u0002J\u0012\u0010L\u001a\u00020(2\b\u0010C\u001a\u0004\u0018\u00010\tH\u0002J$\u0010M\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\t0-2\u0006\u0010N\u001a\u0002042\u0006\u0010O\u001a\u00020IH\u0002J*\u0010P\u001a\u00020(2\u0006\u0010=\u001a\u00020\t2\u0018\u0010G\u001a\u0014\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020(0HH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006R"}, d2={"Lio/conduktor/auth/ConduktorAuth;", "Lkotlinx/coroutines/CoroutineScope;", "authConfig", "Lio/conduktor/auth/AuthConfiguration;", "userConfig", "Ltornadofx/ConfigProperties;", "(Lio/conduktor/auth/AuthConfiguration;Ltornadofx/ConfigProperties;)V", "_loggedInUser", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "Lio/conduktor/auth/user/ConduktorUser;", "getAuthConfig", "()Lio/conduktor/auth/AuthConfiguration;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "loggedInUser", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "getLoggedInUser", "()Ljavafx/beans/property/ReadOnlyObjectProperty;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "offlineConfig", "Lio/conduktor/auth/OfflineConfigJSON;", "getOfflineConfig", "()Lio/conduktor/auth/OfflineConfigJSON;", "offlineService", "Lio/conduktor/auth/offline/OfflineAuthClient;", "getOfflineService", "()Lio/conduktor/auth/offline/OfflineAuthClient;", "offlineService$delegate", "Lkotlin/Lazy;", "service", "Lio/conduktor/auth/http/AuthClient;", "tokenSecretKey", "", "getUserConfig", "()Ltornadofx/ConfigProperties;", "changeSubscription", "", "subscriptionType", "Lio/conduktor/auth/sub/SubscriptionType;", "clearAllAuthInfoAndLogoutUser", "generateOfflineCode", "Larrow/core/Either;", "", "getLoginUrl", "getLogoutUrl", "identifyUser", "pkey", "tokens", "Lio/conduktor/auth/flow/Tokens;", "isLoggedInOffline", "", "isLoggedInOnline", "loadUserFromTokenInConfig", "onUserLoggedIn", "Lkotlin/Function1;", "offlineLogin", "onTokenRefreshError", "currentUser", "err", "refresh", "refreshUserNow", "saveOfflineConfig", "setUser", "user", "startRefreshTokenScheduler", "onUserRefreshed", "startRefreshTokenSchedulerInner", "onTokenRefreshSuccess", "Lkotlin/Function2;", "Ljava/security/PublicKey;", "switchToFreeOnMultiTrial", "syncUserTokenInConfigFile", "updateUserTokenInConfig", "userFromTokens", "newTokens", "key", "validateAndRefreshCurrentToken", "Companion", "desktop"})
public final class ConduktorAuth
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthConfiguration authConfig;
    @NotNull
    private final ConfigProperties userConfig;
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private final Logger logger;
    @NotNull
    private final AuthClient service;
    @NotNull
    private final Lazy offlineService$delegate;
    @NotNull
    private final String tokenSecretKey;
    @NotNull
    private final ReadOnlyObjectWrapper<ConduktorUser> _loggedInUser;
    @NotNull
    private final ReadOnlyObjectProperty<ConduktorUser> loggedInUser;
    @NotNull
    private final OfflineConfigJSON offlineConfig;
    @NotNull
    private static final String trialEmailConfigKey = "te";
    @NotNull
    private static final String onlineTokensConfigKey = "cv";
    @NotNull
    private static final String offlineConfigKey = "off_cv";
    private static final long refreshTokenSchedulerPeriod = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS);

    /*
     * WARNING - void declaration
     */
    public ConduktorAuth(@NotNull AuthConfiguration authConfig, @NotNull ConfigProperties userConfig) {
        OfflineConfigJSON offlineConfigJSON;
        JsonModel jsonModel2;
        void this_$iv;
        this.authConfig = authConfig;
        this.userConfig = userConfig;
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)JavaFxDispatcherKt.getJavaFx((Dispatchers)Dispatchers.INSTANCE)));
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.service = new AuthClient(Conduktor.Companion.getVersion(), this.authConfig, (Function1)service.1.INSTANCE);
        this.offlineService$delegate = LazyKt.lazy((Function0)offlineService.2.INSTANCE);
        String string = AnalyticsTracker.Companion.getUserFromEnv();
        if (string == null) {
            string = "whatdidyoudo";
        }
        this.tokenSecretKey = string;
        this._loggedInUser = new ReadOnlyObjectWrapper();
        this.loggedInUser = this._loggedInUser.getReadOnlyProperty();
        ConfigProperties configProperties = this.userConfig;
        String key$iv = offlineConfigKey;
        boolean $i$f$jsonModel = false;
        JsonObject jsonObject = this_$iv.jsonObject(key$iv);
        if (jsonObject != null) {
            JsonObject $this$toModel$iv$iv = jsonObject;
            boolean $i$f$toModel = false;
            JsonModel model$iv$iv = (JsonModel)OfflineConfigJSON.class.newInstance();
            model$iv$iv.updateModel($this$toModel$iv$iv);
            JsonModel jsonModel3 = model$iv$iv;
            jsonModel2 = jsonModel3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonModel3, (String)"model");
        } else {
            jsonModel2 = null;
        }
        if ((offlineConfigJSON = (OfflineConfigJSON)jsonModel2) == null) {
            offlineConfigJSON = new OfflineConfigJSON(new OfflineConfig(null, null, null, 7, null));
        }
        this.offlineConfig = offlineConfigJSON;
        this.loadUserFromTokenInConfig((Function1<? super ConduktorUser, Unit>)((Function1)new Function1<ConduktorUser, Unit>(){

            public final void invoke(@NotNull ConduktorUser it) {
                logger.debug("Setting Conduktor user to " + it.getUsername());
                this.setUser(it);
            }
        }));
        this.syncUserTokenInConfigFile();
        this.startRefreshTokenScheduler((Function1<? super ConduktorUser, Unit>)((Function1)new Function1<ConduktorUser, Unit>(){

            public final void invoke(@NotNull ConduktorUser it) {
                logger.debug("Refreshing user successfully: " + it);
                this.setUser(it);
            }
        }));
    }

    @NotNull
    public final AuthConfiguration getAuthConfig() {
        return this.authConfig;
    }

    @NotNull
    public final ConfigProperties getUserConfig() {
        return this.userConfig;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    private final OfflineAuthClient getOfflineService() {
        Lazy lazy = this.offlineService$delegate;
        return (OfflineAuthClient)lazy.getValue();
    }

    @NotNull
    public final ReadOnlyObjectProperty<ConduktorUser> getLoggedInUser() {
        return this.loggedInUser;
    }

    @NotNull
    public final OfflineConfigJSON getOfflineConfig() {
        return this.offlineConfig;
    }

    public final boolean isLoggedInOffline() {
        ConduktorUser conduktorUser = (ConduktorUser)this._loggedInUser.getValue();
        return conduktorUser != null ? conduktorUser.isOffline() : false;
    }

    public final boolean isLoggedInOnline() {
        ConduktorUser conduktorUser = (ConduktorUser)this._loggedInUser.getValue();
        return conduktorUser != null ? conduktorUser.isOnline() : false;
    }

    private final void setUser(ConduktorUser user2) {
        AsyncKt.runLater((Function0)((Function0)new Function0<Unit>(user2, this){
            final /* synthetic */ ConduktorUser $user;
            final /* synthetic */ ConduktorAuth this$0;
            {
                this.$user = $user;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConduktorUser conduktorUser;
                ConduktorUser conduktorUser2 = this.$user;
                if (conduktorUser2 != null) {
                    ConduktorUser conduktorUser3 = conduktorUser2;
                    ConduktorAuth conduktorAuth = this.this$0;
                    ConduktorUser it = conduktorUser3;
                    boolean bl = false;
                    conduktorUser = ConduktorAuth.access$switchToFreeOnMultiTrial(conduktorAuth, it);
                } else {
                    conduktorUser = null;
                }
                ConduktorUser checkedUser = conduktorUser;
                ConduktorAuth.access$get_loggedInUser$p(this.this$0).setValue(checkedUser);
                FX.Companion.getEventbus().fire((FXEvent)new LoggedInUserChanged(checkedUser));
                if (this.$user != null) {
                    AnalyticsTracker.action$default(Conduktor.Companion.getTracker(), User.INSTANCE.loggedIn(), null, 2, null);
                }
                if (checkedUser == null || checkedUser.tokenExpired()) {
                    AsyncKt.runLater((Function0)setUser.1.INSTANCE);
                }
            }
        }));
    }

    public final void refresh() {
        ConduktorUser currentUser = (ConduktorUser)this._loggedInUser.getValue();
        ConduktorUser conduktorUser = currentUser;
        if (conduktorUser != null && (conduktorUser = conduktorUser.getIdentityOrigin()) != null && (conduktorUser = conduktorUser.ifOnline()) != null) {
            ConduktorUser identityOrigin = conduktorUser;
            boolean bl = false;
            this.logger.debug("Forcing refreshing user");
            Either tokens = this.service.refreshTokens-j0cGsus(identityOrigin.getTokens().getRefreshToken-me7gRtM());
            if (tokens instanceof Either.Left) {
                this.logger.debug("Forcing refreshing token failed: " + ((Throwable)((Either.Left)tokens).getValue()).getMessage());
            } else if (tokens instanceof Either.Right) {
                Either<Throwable, ConduktorUser> this_$iv = this.userFromTokens((Tokens)((Either.Right)tokens).getValue(), identityOrigin.getPublicKey());
                boolean $i$f$map = false;
                Either<Throwable, ConduktorUser> $this$flatMap$iv$iv = this_$iv;
                boolean $i$f$flatMap = false;
                Either<Throwable, ConduktorUser> either2 = $this$flatMap$iv$iv;
                if (either2 instanceof Either.Right) {
                    Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    ConduktorUser it = (ConduktorUser)it$iv;
                    boolean bl3 = false;
                    this.setUser(it);
                    Unit unit = Unit.INSTANCE;
                    Either cfr_ignored_0 = (Either)new Either.Right((Object)unit);
                } else if (!(either2 instanceof Either.Left)) {
                    throw new NoWhenBranchMatchedException();
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void clearAllAuthInfoAndLogoutUser() {
        ConduktorUser conduktorUser = (ConduktorUser)this._loggedInUser.getValue();
        if (conduktorUser != null && (conduktorUser = conduktorUser.getIdentityOrigin()) != null && (conduktorUser = conduktorUser.ifOnline()) != null && (conduktorUser = conduktorUser.getTokens()) != null) {
            String it = conduktorUser.getRefreshToken-me7gRtM();
            boolean bl = false;
            this.service.dropRefreshToken-j0cGsus(it);
        }
        this.setUser(null);
        this.updateUserTokenInConfig(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadUserFromTokenInConfig(Function1<? super ConduktorUser, Unit> onUserLoggedIn) {
        Either line;
        Ref.BooleanRef onlineLoggedIn = new Ref.BooleanRef();
        String onlineToken = this.userConfig.string(onlineTokensConfigKey);
        CharSequence charSequence = onlineToken;
        if (!(charSequence == null || charSequence.length() == 0)) {
            line = CryptoUtils.INSTANCE.decrypt(onlineToken, this.tokenSecretKey);
            if (line instanceof Either.Left) {
                this.logger.warn("Error decrypting token", (Throwable)((Either.Left)line).getValue());
            } else if (line instanceof Either.Right) {
                String[] stringArray = new String[]{";"};
                List list2 = StringsKt.split$default((CharSequence)((CharSequence)((Either.Right)line).getValue()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String version2 = (String)list2.get(0);
                String ac = (String)list2.get(1);
                String id2 = (String)list2.get(2);
                String refresh = (String)list2.get(3);
                String pkey = (String)list2.get(4);
                if (Intrinsics.areEqual((Object)version2, (Object)"1")) {
                    Tokens tokens = new Tokens(AccessToken.constructor-impl((String)ac), RefreshToken.constructor-impl((String)refresh), IdToken.constructor-impl((String)id2), null);
                    this.logger.trace("Tokens: " + tokens);
                    Either<Throwable, ConduktorUser> user2 = this.identifyUser(pkey, tokens);
                    if (user2 instanceof Either.Left) {
                        if (((Either.Left)user2).getValue() instanceof ExpiredJwtException) {
                            Either<Throwable, ConduktorUser> this_$iv = this.refreshUserNow(tokens, pkey);
                            boolean $i$f$map = false;
                            Either<Throwable, ConduktorUser> $this$flatMap$iv$iv = this_$iv;
                            boolean $i$f$flatMap = false;
                            Either<Throwable, ConduktorUser> either2 = $this$flatMap$iv$iv;
                            if (either2 instanceof Either.Right) {
                                Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                                boolean bl = false;
                                ConduktorUser it = (ConduktorUser)it$iv;
                                boolean bl2 = false;
                                ConduktorAuth.loadUserFromTokenInConfig$onOnlineLoggedInSuccess(onlineLoggedIn, onUserLoggedIn, it);
                                Unit unit = Unit.INSTANCE;
                                Either cfr_ignored_0 = (Either)new Either.Right((Object)unit);
                            } else if (!(either2 instanceof Either.Left)) {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    } else if (user2 instanceof Either.Right) {
                        ConduktorAuth.loadUserFromTokenInConfig$onOnlineLoggedInSuccess(onlineLoggedIn, onUserLoggedIn, (ConduktorUser)((Either.Right)user2).getValue());
                    }
                }
            }
        }
        if (!onlineLoggedIn.element && this.offlineConfig.getPortalCode().isNotEmpty().getValue().booleanValue()) {
            void this_$iv;
            line = this.getOfflineService().decodeTokenToUser(this.offlineConfig.getPortalCode().getValue(), this.offlineConfig.getEmail().getValue());
            boolean $i$f$map = false;
            void $this$flatMap$iv$iv = this_$iv;
            boolean $i$f$flatMap = false;
            void var8_10 = $this$flatMap$iv$iv;
            if (var8_10 instanceof Either.Right) {
                Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                boolean bl = false;
                ConduktorUser user3 = (ConduktorUser)it$iv;
                boolean bl3 = false;
                onUserLoggedIn.invoke((Object)user3);
                Unit unit = Unit.INSTANCE;
                Either cfr_ignored_1 = (Either)new Either.Right((Object)unit);
            } else if (!(var8_10 instanceof Either.Left)) {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final Either<Throwable, ConduktorUser> refreshUserNow(Tokens tokens, String pkey) {
        Either either2;
        Either<Throwable, ConduktorUser> either3;
        this.logger.debug("Token expired: try refreshing...");
        Either<Throwable, ConduktorUser> $this$flatMap$iv = this.service.refreshTokens-j0cGsus(tokens.getRefreshToken-me7gRtM());
        boolean $i$f$flatMap = false;
        Either<Throwable, ConduktorUser> either4 = $this$flatMap$iv;
        if (either4 instanceof Either.Right) {
            Tokens it = (Tokens)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            either3 = this.identifyUser(pkey, it);
        } else if (either4 instanceof Either.Left) {
            either3 = $this$flatMap$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Either<Throwable, ConduktorUser> this_$iv = either3;
        boolean $i$f$mapLeft = false;
        Either<Throwable, ConduktorUser> this_$iv$iv = this_$iv;
        boolean $i$f$fold = false;
        Either<Throwable, ConduktorUser> either5 = this_$iv$iv;
        if (either5 instanceof Either.Right) {
            Object it$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            either2 = (Either)new Either.Right(it$iv);
        } else if (either5 instanceof Either.Left) {
            Object it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            Throwable it = (Throwable)it$iv;
            boolean bl2 = false;
            this.logger.debug("Refreshing token failed: " + it.getMessage());
            Throwable throwable = it;
            either2 = (Either)new Either.Left((Object)throwable);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either<Throwable, ConduktorUser> identifyUser(String pkey, Tokens tokens) {
        Either either2;
        Either either3;
        Either $this$flatMap$iv = AuthClient.Companion.publicKeyFromBase64(pkey);
        boolean $i$f$flatMap = false;
        Either either4 = $this$flatMap$iv;
        if (either4 instanceof Either.Right) {
            void this_$iv;
            PublicKey pk = (PublicKey)((Either.Right)$this$flatMap$iv).getValue();
            boolean bl = false;
            Either either5 = AuthClient.Companion.verifyJwts-TenCrxo(this.authConfig, tokens.getIdToken-mXC59TU(), pk);
            boolean $i$f$map = false;
            void $this$flatMap$iv$iv = this_$iv;
            boolean $i$f$flatMap2 = false;
            void var12_14 = $this$flatMap$iv$iv;
            if (var12_14 instanceof Either.Right) {
                Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                boolean bl2 = false;
                Jws it = (Jws)it$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)new IdentityOrigin.OnlineIdentityOrigin(tokens, pk), (Object)it);
                either3 = (Either)new Either.Right((Object)pair);
            } else {
                if (!(var12_14 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                either3 = $this$flatMap$iv$iv;
            }
        } else {
            if (!(either4 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
            either3 = $this$flatMap$iv;
        }
        Either this_$iv = either3;
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap3 = false;
        Either either6 = $this$flatMap$iv$iv;
        if (either6 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            Pair pair = (Pair)it$iv;
            boolean bl4 = false;
            IdentityOrigin.OnlineIdentityOrigin origin = (IdentityOrigin.OnlineIdentityOrigin)pair.component1();
            Jws claims = (Jws)pair.component2();
            ConduktorUser user2 = ConduktorUser.Companion.fromClaims((IdentityOrigin)origin, claims);
            this.logger.debug("User identified: " + user2);
            ConduktorUser conduktorUser = user2;
            either2 = (Either)new Either.Right((Object)conduktorUser);
            return either2;
        } else {
            if (!(either6 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
            either2 = $this$flatMap$iv$iv;
        }
        return either2;
    }

    private final ConduktorUser switchToFreeOnMultiTrial(ConduktorUser user2) {
        Object object;
        Either.Companion companion;
        Object it$iv;
        Either either2;
        if (user2.subscriptionToConsider() != SubscriptionType.TRIALING) {
            return user2;
        }
        String lastTrialEmailHash = this.userConfig.string(trialEmailConfigKey);
        Either.Companion this_$iv = Either.Companion;
        boolean $i$f$tryCatch = false;
        try {
            boolean bl = false;
            String string = user2.getEmail().toLowerCase(Locales.INSTANCE.getForLegacyPersistedValues());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            either2 = EitherKt.right((Object)CryptoUtils.INSTANCE.encrypt(string, user2.getUsername()));
        }
        catch (Throwable t$iv) {
            either2 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
        }
        this_$iv = either2;
        boolean $i$f$map = false;
        Either.Companion $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either.Companion companion2 = $this$flatMap$iv$iv;
        if (companion2 instanceof Either.Right) {
            ConduktorUser conduktorUser;
            it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            String emailHash = (String)it$iv;
            boolean bl2 = false;
            if (lastTrialEmailHash == null) {
                this.userConfig.set(trialEmailConfigKey, emailHash);
                ConfigurationExtension.INSTANCE.atomicSave(this.userConfig);
                conduktorUser = user2;
            } else {
                conduktorUser = !Intrinsics.areEqual((Object)lastTrialEmailHash, (Object)emailHash) ? ConduktorUser.copy$default((ConduktorUser)user2, null, (boolean)false, null, (SubscriptionType)SubscriptionType.FREE, (SubscriptionFallbackReason)SubscriptionFallbackReason.MultipleTrials, null, null, null, null, (int)487, null) : user2;
            }
            ConduktorUser conduktorUser2 = conduktorUser;
            companion = (Either)new Either.Right((Object)conduktorUser2);
        } else if (companion2 instanceof Either.Left) {
            companion = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Either.Companion $this$getOrElse$iv = companion;
        boolean $i$f$getOrElse = false;
        Either.Companion this_$iv$iv = $this$getOrElse$iv;
        boolean $i$f$fold = false;
        companion2 = this_$iv$iv;
        if (companion2 instanceof Either.Right) {
            Object p1$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object = p1$iv;
        } else if (companion2 instanceof Either.Left) {
            it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            boolean bl3 = false;
            object = user2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (ConduktorUser)object;
    }

    @NotNull
    public final String getLoginUrl() {
        return this.service.getLoginScreenUrl((Function1)new Function1<ConduktorUser, Unit>(this){
            final /* synthetic */ ConduktorAuth this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ConduktorUser it) {
                ConduktorAuth.access$setUser(this.this$0, it);
            }
        });
    }

    @NotNull
    public final String getLogoutUrl() {
        return this.service.getLogoutUrl();
    }

    private final void startRefreshTokenScheduler(Function1<? super ConduktorUser, Unit> onUserRefreshed) {
        this.startRefreshTokenSchedulerInner((Function2<? super PublicKey, ? super Tokens, Unit>)((Function2)new Function2<PublicKey, Tokens, Unit>(this, onUserRefreshed){
            final /* synthetic */ ConduktorAuth this$0;
            final /* synthetic */ Function1<ConduktorUser, Unit> $onUserRefreshed;
            {
                this.this$0 = $receiver;
                this.$onUserRefreshed = $onUserRefreshed;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PublicKey key2, @NotNull Tokens newTokens) {
                void this_$iv;
                Either either2 = ConduktorAuth.access$userFromTokens(this.this$0, newTokens, key2);
                Function1<ConduktorUser, Unit> f$iv = this.$onUserRefreshed;
                boolean $i$f$map = false;
                void $this$flatMap$iv$iv = this_$iv;
                boolean $i$f$flatMap = false;
                void var8_8 = $this$flatMap$iv$iv;
                if (var8_8 instanceof Either.Right) {
                    Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                    boolean bl = false;
                    Either cfr_ignored_0 = (Either)new Either.Right(f$iv.invoke(it$iv));
                } else if (!(var8_8 instanceof Either.Left)) {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }));
    }

    private final Either<Throwable, ConduktorUser> userFromTokens(Tokens newTokens, PublicKey key2) {
        Either either2;
        Either this_$iv = AuthClient.Companion.verifyJwts-TenCrxo(this.authConfig, newTokens.getIdToken-mXC59TU(), key2);
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either3 = $this$flatMap$iv$iv;
        if (either3 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            Jws it = (Jws)it$iv;
            boolean bl2 = false;
            ConduktorUser conduktorUser = ConduktorUser.Companion.fromClaims((IdentityOrigin)new IdentityOrigin.OnlineIdentityOrigin(newTokens, key2), it);
            either2 = (Either)new Either.Right((Object)conduktorUser);
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either2;
    }

    private final void startRefreshTokenSchedulerInner(Function2<? super PublicKey, ? super Tokens, Unit> onTokenRefreshSuccess) {
        this.logger.debug("Refresh token every " + Duration.toString-impl((long)refreshTokenSchedulerPeriod) + "...");
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> ConduktorAuth.startRefreshTokenSchedulerInner$lambda-14(this, onTokenRefreshSuccess), 1L, Duration.toLong-impl((long)refreshTokenSchedulerPeriod, (DurationUnit)DurationUnit.SECONDS), TimeUnit.SECONDS);
    }

    private final void validateAndRefreshCurrentToken(ConduktorUser currentUser, Function2<? super PublicKey, ? super Tokens, Unit> onTokenRefreshSuccess) {
        IdentityOrigin origin = currentUser.getIdentityOrigin();
        if (origin instanceof IdentityOrigin.OnlineIdentityOrigin) {
            Either tokens = this.service.refreshTokens-j0cGsus(((IdentityOrigin.OnlineIdentityOrigin)origin).getTokens().getRefreshToken-me7gRtM());
            if (tokens instanceof Either.Left) {
                this.onTokenRefreshError(currentUser, (Throwable)((Either.Left)tokens).getValue());
            } else if (tokens instanceof Either.Right) {
                onTokenRefreshSuccess.invoke((Object)((IdentityOrigin.OnlineIdentityOrigin)origin).getPublicKey(), ((Either.Right)tokens).getValue());
            }
        } else if (origin instanceof IdentityOrigin.OfflineIdentityOrigin && currentUser.tokenExpired()) {
            this.logger.debug("Token has expired. Can't refresh as it is an offline token. Logging out");
            this.clearAllAuthInfoAndLogoutUser();
        }
    }

    private final void onTokenRefreshError(ConduktorUser currentUser, Throwable err) {
        String msg = err.getMessage();
        this.logger.debug("Refreshing token failed for: " + msg);
        if (currentUser.tokenExpired()) {
            this.logger.debug("Token is expired, we couldn't refresh, we don't know the state of the user: we clear everything up");
            this.clearAllAuthInfoAndLogoutUser();
        }
        String string = msg;
        boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"HTTP Exception 403", (boolean)false, (int)2, null) : false;
        if (bl) {
            this.logger.debug("Refreshing token failed with 403: Invalid Refresh Token. Logging out.");
            this.updateUserTokenInConfig(null);
        } else {
            String string2 = msg;
            boolean bl2 = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"HTTP Exception 401", (boolean)false, (int)2, null) : false;
            if (bl2) {
                this.logger.debug("Refreshing token failed with 401: Unauthorized. Logging out.");
                this.clearAllAuthInfoAndLogoutUser();
            } else {
                this.logger.debug("Error refreshing token, will retry later... (" + msg + ")");
            }
        }
    }

    private final void syncUserTokenInConfigFile() {
        this._loggedInUser.addListener((arg_0, arg_1, arg_2) -> ConduktorAuth.syncUserTokenInConfigFile$lambda-15(this, arg_0, arg_1, arg_2));
    }

    private final void updateUserTokenInConfig(ConduktorUser user2) {
        IdentityOrigin origin;
        ConduktorUser conduktorUser = user2;
        Object object = origin = conduktorUser != null ? conduktorUser.getIdentityOrigin() : null;
        if (origin instanceof IdentityOrigin.OnlineIdentityOrigin) {
            Tokens tokens = ((IdentityOrigin.OnlineIdentityOrigin)origin).getTokens();
            String pkey = new String(Base64.getEncoder().encode(((IdentityOrigin.OnlineIdentityOrigin)origin).getPublicKey().getEncoded()), Charsets.UTF_8);
            String token2 = "1;" + tokens.getAccessToken-ygiL754() + ";" + tokens.getIdToken-mXC59TU() + ";" + tokens.getRefreshToken-me7gRtM() + ";" + pkey;
            this.userConfig.set(onlineTokensConfigKey, CryptoUtils.INSTANCE.encrypt(token2, this.tokenSecretKey));
            this.userConfig.set(offlineConfigKey, null);
        } else if (origin instanceof IdentityOrigin.OfflineIdentityOrigin) {
            Either this_$iv = this.getOfflineService().encodeJwsToToken(((IdentityOrigin.OfflineIdentityOrigin)origin).getJws(), user2.getEmail());
            boolean $i$f$map = false;
            Either $this$flatMap$iv$iv = this_$iv;
            boolean $i$f$flatMap = false;
            Either either2 = $this$flatMap$iv$iv;
            if (either2 instanceof Either.Right) {
                Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                boolean bl = false;
                String it = (String)it$iv;
                boolean bl2 = false;
                this.offlineConfig.getPortalCode().setValue(it);
                Unit unit = Unit.INSTANCE;
                Either cfr_ignored_0 = (Either)new Either.Right((Object)unit);
            } else if (!(either2 instanceof Either.Left)) {
                throw new NoWhenBranchMatchedException();
            }
            this.userConfig.set(offlineConfigKey, this.offlineConfig.toJSON().toString());
            this.userConfig.set(onlineTokensConfigKey, "");
        } else {
            this.userConfig.set(onlineTokensConfigKey, "");
            this.userConfig.set(offlineConfigKey, null);
        }
        ConfigurationExtension.INSTANCE.atomicSave(this.userConfig);
    }

    public final void saveOfflineConfig() {
        this.userConfig.set(offlineConfigKey, this.offlineConfig.toJSON().toString());
        ConfigurationExtension.INSTANCE.atomicSave(this.userConfig);
    }

    @NotNull
    public final Either<Throwable, Unit> generateOfflineCode() {
        Either either2;
        Either this_$iv = this.getOfflineService().generateOfflineConduktorCode(this.offlineConfig.getEmail().getValue(), LocalDateTime.now());
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either3 = $this$flatMap$iv$iv;
        if (either3 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            String it = (String)it$iv;
            boolean bl2 = false;
            this.offlineConfig.getDesktopCode().setValue(it);
            this.saveOfflineConfig();
            Unit unit = Unit.INSTANCE;
            either2 = (Either)new Either.Right((Object)unit);
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either2;
    }

    @NotNull
    public final Either<Throwable, Unit> offlineLogin() {
        Either either2;
        this.saveOfflineConfig();
        Either this_$iv = this.getOfflineService().decodeTokenToUser(this.offlineConfig.getPortalCode().getValue(), this.offlineConfig.getEmail().getValue());
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either3 = $this$flatMap$iv$iv;
        if (either3 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            ConduktorUser user2 = (ConduktorUser)it$iv;
            boolean bl2 = false;
            Conduktor.Companion.getTracking().stop();
            this.setUser(user2);
            this.updateUserTokenInConfig(user2);
            Unit unit = Unit.INSTANCE;
            either2 = (Either)new Either.Right((Object)unit);
        } else if (either3 instanceof Either.Left) {
            either2 = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either2;
    }

    public final void changeSubscription(@NotNull SubscriptionType subscriptionType) {
        boolean bl;
        boolean bl2 = bl = ExtensionsKt.isDev() && ((ConduktorUser)this._loggedInUser.getValue()).isAwesomeDev();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setUser(ConduktorUser.copy$default((ConduktorUser)((ConduktorUser)this._loggedInUser.getValue()), null, (boolean)false, null, (SubscriptionType)subscriptionType, null, null, null, null, null, (int)503, null));
    }

    private static final void loadUserFromTokenInConfig$onOnlineLoggedInSuccess(Ref.BooleanRef onlineLoggedIn, Function1<? super ConduktorUser, Unit> $onUserLoggedIn, ConduktorUser user2) {
        onlineLoggedIn.element = true;
        $onUserLoggedIn.invoke((Object)user2);
    }

    private static final void startRefreshTokenSchedulerInner$lambda-14(ConduktorAuth this$0, Function2 $onTokenRefreshSuccess) {
        ConduktorUser currentUser = (ConduktorUser)this$0._loggedInUser.getValue();
        if (currentUser != null) {
            this$0.logger.debug("Refreshing token (sub: " + currentUser.getSubscriptionExpiry() + ", token: " + currentUser.getTokenExpirationDate() + ")");
            this$0.validateAndRefreshCurrentToken(currentUser, (Function2<? super PublicKey, ? super Tokens, Unit>)$onTokenRefreshSuccess);
        } else {
            this$0.logger.debug("No user logged in, nothing to refresh");
        }
    }

    private static final void syncUserTokenInConfigFile$lambda-15(ConduktorAuth this$0, ObservableValue observableValue, ConduktorUser oldUser, ConduktorUser newUser) {
        block3: {
            ConduktorUser conduktorUser = newUser;
            this$0.logger.debug("Saving token in config (" + (conduktorUser != null ? conduktorUser.getUsername() : null) + ")");
            if (newUser == null) {
                this$0.updateUserTokenInConfig(null);
            } else {
                this$0.updateUserTokenInConfig(newUser);
            }
            if (oldUser != null && newUser != null) break block3;
            Stage stage2 = FX.Companion.getPrimaryStage$default((FX.Companion)FX.Companion, null, (int)1, null);
            if (stage2 != null) {
                stage2.requestFocus();
            }
        }
    }

    public static final /* synthetic */ ReadOnlyObjectWrapper access$get_loggedInUser$p(ConduktorAuth $this) {
        return $this._loggedInUser;
    }

    public static final /* synthetic */ ConduktorUser access$switchToFreeOnMultiTrial(ConduktorAuth $this, ConduktorUser user2) {
        return $this.switchToFreeOnMultiTrial(user2);
    }

    public static final /* synthetic */ Either access$userFromTokens(ConduktorAuth $this, Tokens newTokens, PublicKey key2) {
        return $this.userFromTokens(newTokens, key2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\n"}, d2={"Lio/conduktor/auth/ConduktorAuth$Companion;", "", "()V", "offlineConfigKey", "", "onlineTokensConfigKey", "refreshTokenSchedulerPeriod", "Lkotlin/time/Duration;", "J", "trialEmailConfigKey", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

