/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.analytics.tracking;

import com.segment.analytics.Analytics;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.PageMessage;
import com.segment.analytics.messages.TrackMessage;
import io.conduktor.ExtensionsKt;
import io.conduktor.HashUtils;
import io.conduktor.analytics.domain.KafkaClusterProvider;
import io.conduktor.analytics.tracking.AnalyticsObject;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.analytics.tracking.Application;
import io.conduktor.analytics.tracking.ObjectAction;
import io.conduktor.auth.ConduktorAuth;
import io.conduktor.auth.user.ConduktorUser;
import io.conduktor.config.AppVersion;
import io.conduktor.developers.Activity;
import io.conduktor.models.ClusterConfigurationJson;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0013H\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u0002J \u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u00130\u0013H\u0002J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J$\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/conduktor/analytics/tracking/SegmentTracker;", "Lio/conduktor/analytics/tracking/AnalyticsTracker;", "deviceId", "", "auth", "Lio/conduktor/auth/ConduktorAuth;", "(Ljava/lang/String;Lio/conduktor/auth/ConduktorAuth;)V", "getAuth", "()Lio/conduktor/auth/ConduktorAuth;", "devKey", "getDeviceId", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "productionKey", "segmentClient", "Lcom/segment/analytics/Analytics;", "staticContext", "", "action", "", "objectAction", "Lio/conduktor/analytics/tracking/ObjectAction;", "props", "", "error", "ex", "", "getKafkaContext", "getUserContext", "minimalContext", "start", "stop", "systemInfo", "time", "activity", "Lio/conduktor/developers/Activity;", "visit", "path", "Lio/conduktor/analytics/tracking/AnalyticsObject;", "desktop"})
public final class SegmentTracker
extends AnalyticsTracker {
    @NotNull
    private final String deviceId;
    @NotNull
    private final ConduktorAuth auth;
    private final Logger logger;
    @NotNull
    private final String productionKey;
    @NotNull
    private final String devKey;
    private Analytics segmentClient;
    @NotNull
    private final Map<String, String> staticContext;

    public SegmentTracker(@NotNull String deviceId, @NotNull ConduktorAuth auth2) {
        this.deviceId = deviceId;
        this.auth = auth2;
        this.logger = LoggerFactory.getLogger(SegmentTracker.class);
        this.productionKey = "aaY21gPdvLrmhdkIK9nhBJ5YdDnmak4f";
        this.devKey = "6im6UTG1qqKPg6u8D1vN0jo5VTqtMQOS";
        this.segmentClient = Analytics.builder((String)(ExtensionsKt.isDev() ? this.devKey : this.productionKey)).endpoint("https://events.eu1.segmentapis.com").build();
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"name", (Object)"desktop");
        pairArray[1] = TuplesKt.to((Object)"version", (Object)AppVersion.getBuildVersion((String)"conduktor-version.properties"));
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        pairArray[2] = TuplesKt.to((Object)"os", (Object)string);
        this.staticContext = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    @NotNull
    public final ConduktorAuth getAuth() {
        return this.auth;
    }

    private final Map<String, Object> getKafkaContext() {
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"version", (Object)this.getKafkaVersion());
        pairArray[1] = TuplesKt.to((Object)"provider", (Object)KafkaClusterProvider.stringFromKafkaClusterProvider((KafkaClusterProvider)this.getKafkaProvider()));
        ClusterConfigurationJson clusterConfigurationJson = this.getClusterConfiguration();
        pairArray[2] = TuplesKt.to((Object)"cluster", clusterConfigurationJson != null ? io.conduktor.analytics.tracking.ExtensionsKt.analytics(clusterConfigurationJson) : null);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, String> getUserContext() {
        Object object;
        Object domainHash;
        String[] stringArray;
        Object object2;
        Object subType;
        ConduktorUser user2 = (ConduktorUser)this.auth.getLoggedInUser().getValue();
        Object object3 = user2;
        if (object3 == null || (object3 = object3.getOriginalSubscriptionType()) == null || (object3 = object3.getLabel()) == null) {
            object3 = subType = "unknown";
        }
        if ((object2 = user2) == null || (object2 = object2.getEmail()) == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(stringArray = new String[]{"@"}), (boolean)false, (int)0, (int)6, null)) == null || (object2 = (String)CollectionsKt.last((List)object2)) == null) {
            object2 = domainHash = "unknown";
        }
        if ((object = user2) == null || (object = object.getUsername()) == null || (object = HashUtils.INSTANCE.hash256((String)object)) == null) {
            object = "unknown";
        }
        Object usernameHash = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)subType), TuplesKt.to((Object)"domain", (Object)domainHash), TuplesKt.to((Object)"username", (Object)usernameHash)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Map<String, Object>> minimalContext() {
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"app", this.staticContext);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"kafka", io.conduktor.analytics.tracking.ExtensionsKt.flatten(this.getKafkaContext())), TuplesKt.to((Object)"subscription", this.getUserContext())};
        pairArray[1] = TuplesKt.to((Object)"traits", (Object)MapsKt.mapOf((Pair[])pairArray2));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> systemInfo() {
        Map map2;
        try {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            HardwareAbstractionLayer system = new SystemInfo().getHardware();
            GlobalMemory ram = system.getMemory();
            CentralProcessor cpu = system.getProcessor();
            Object object = new Pair[7];
            object[0] = TuplesKt.to((Object)"cpuCores", (Object)cpu.getPhysicalProcessorCount());
            object[1] = TuplesKt.to((Object)"cpuThreads", (Object)cpu.getLogicalProcessorCount());
            object[2] = TuplesKt.to((Object)"ramTotal", (Object)ram.getTotal());
            object[3] = TuplesKt.to((Object)"ramFree", (Object)ram.getAvailable());
            String string = System.getProperty("os.name");
            if (string == null) {
                string = "";
            }
            object[4] = TuplesKt.to((Object)"osName", (Object)string);
            String string2 = System.getProperty("os.version");
            if (string2 == null) {
                string2 = "";
            }
            object[5] = TuplesKt.to((Object)"osVersion", (Object)string2);
            String string3 = System.getProperty("os.arch");
            if (string3 == null) {
                string3 = "";
            }
            object[6] = TuplesKt.to((Object)"osArch", (Object)string3);
            object = MapsKt.mapOf((Pair[])object);
            boolean $i$f$mapValues = false;
            void var6_7 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                String string4 = it.getValue().toString();
                map4.put(k, string4);
            }
            map2 = destination$iv$iv;
        }
        catch (Exception e) {
            this.logger.warn("Error reading system information", (Throwable)e);
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Override
    public void start() {
        this.action(Application.INSTANCE.started(), this.systemInfo());
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.segmentClient.flush();
            this.segmentClient.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void time(@NotNull Activity activity) {
    }

    @Override
    public void visit(@NotNull AnalyticsObject path, @NotNull Map<String, ? extends Object> props) {
        PageMessage.Builder message2 = (PageMessage.Builder)((PageMessage.Builder)PageMessage.builder((String)("cdk.desktop." + path.name() + ".Viewed")).userId(this.deviceId)).properties(io.conduktor.analytics.tracking.ExtensionsKt.flatten(props)).context(this.minimalContext());
        this.segmentClient.enqueue((MessageBuilder)message2);
    }

    @Override
    public void error(@NotNull Throwable ex) {
    }

    @Override
    public void action(@NotNull ObjectAction objectAction, @NotNull Map<String, ? extends Object> props) {
        TrackMessage.Builder message2 = (TrackMessage.Builder)((TrackMessage.Builder)TrackMessage.builder((String)("cdk.desktop." + objectAction)).userId(this.deviceId)).properties(io.conduktor.analytics.tracking.ExtensionsKt.flatten(props)).context(this.minimalContext());
        this.segmentClient.enqueue((MessageBuilder)message2);
    }
}

